<?php

//initialize the page
require_once(public_path("smart/inc/init.php"));

//require UI configuration (nav, ribbon, etc.)
require_once(public_path("smart/inc/config.ui.php"));

include_once(public_path("smart/inc/user_variables.php"));


/*---------------- PHP Custom Scripts ---------

YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
E.G. $page_title = "Custom Title" */

$page_title = trans("modules.flight_watch");

/* ---------------- END PHP Custom Scripts ------------- */

//include header
//you can add your custom css in $page_css array.
//Note: all css files are inside css/ folder
$page_css[] = "your_style.css";

$no_main_header = true;

$page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

include(public_path("smart/inc/header.php"));

?>

<style>
#header_container{
    display: flex;
    flex-flow: row;
    width: 100%;
    padding-top: 20px;
}

#airports_airlines_group {
    display: flex;
    flex-flow: column;
    flex-grow: 1;
    justify-content: center;
}

#airports_container{
    display: flex;
    justify-content: center;
}

#airports_container > a{
    margin-right: 5px;
}

#airlines_container{
    display: flex;
    justify-content: center;
}

#airlines_container > a, #airlines_container > img{
    margin: 2px;
}
</style>


<div id="header_container">
    <div id="logo-group" style="{{ $div_external_page }}">
        <img style="{{ $logo_external_page }}" src="{{ $logo }}"  alt="">
        <h2 style="{{ $logo_text_external_page }}">{{ $logo_text }}</h2>
        <!-- END AJAX-DROPDOWN -->
    </div>

    @if (env(CARRIER) == HANDLING)
        <div id="airports_airlines_group">
           @if(count($handlingAirports) > 1)
               <div id="airports_container">
                   <a id="all_stations" style="cursor:pointer;  margin-bottom: 5px;" class="btn btn-success font-md quick-airports {{ !count($staffStations) ? "btn-warning" : "" }}" data-id="">ALL</a>
                   @foreach($handlingAirports as $id => $each)
                       @if (in_array($id, $staffStations))
                           <a style="cursor:pointer; margin-bottom: 5px;" class="btn btn-primary font-md quick-airports {{ in_array($id, $staffStations) ? "btn-warning" : "" }}" data-id="{{ $id }}">{{ $each }}</a>
                       @endif
                   @endforeach
               </div>
           @endif

           @if (!$isMobile && count($handlingAirlines) > 1)
               <div id="airlines_container">
                   <a id="all_airlines" style="cursor:pointer;" class="btn btn-success font-sm quick-airlines {{ !count($staffAirlines) ? "selected" : "" }}" data-id="">ALL</a>
                   @foreach($handlingAirlines as $id => $each)
                       @if (in_array($id, $staffAirlines))
                           <img style="cursor:pointer;"  data-id="{{ $id }}" class="header-airline-logo quick-airlines {{ in_array($id, $staffAirlines) ? "selected" : "" }}" src="{{  asset("storage/airlines/img/{$each}")}}" />
                       @endif
                   @endforeach
               </div>
           @endif
        </div>
   @endif

    <div style="width: 185px;">
    </div>
</div>

<div id="main" role="main" style="padding-bottom: 10px !important;">
<!-- MAIN CONTENT -->
<div id="content" class="">
</div>
</div>

<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline.css?5") }}" />
<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline-theme.css?5") }}" />
<link rel="stylesheet" href="{{ asset("/packages/ionicons/css/ionicons.min.css") }}" />
