{{--@include("flight-view.layouts.form")--}}

<div class="clearfix"></div>

@if (!count($flights))
    <div class="alert alert-info">
        @if (\request("type") && \request("type") == $type)
            @lang("content.found") 0 @lang("content.records")
        @else
            @lang("content.please_select_period_and_press_submit")
        @endif
    </div>
@else

    <div class="col-md-12 form-inline" style="margin: 10px 0 20px 0">
        <label class="control-label" style="margin-right: 20px">
            {!! Form::checkbox("select_all", "1", false, ['class' => 'form-control select-all']) !!}
            @lang("content.select_all")
        </label>
        @if ($type == CANCELLED)
            <button type="button" class="btn btn-danger confirmation-modal-action-btn" data-action="delete-selected"
                    data-url="{{ url("flight-view/delete-selected") }}"
                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.remove") @lang("content.selected_flights")</button>

            <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected"
                    data-url="{{ url("flight-view/restore-selected") }}"
                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.restore") @lang("content.selected_flights")</button>
        @elseif($type == REMOVED)
            <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="cancel-selected"
                    data-url="{{ url("flight-view/cancel-selected") }}"
                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.cancel") @lang("content.selected_flights")</button>

            <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected"
                    data-url="{{ url("flight-view/restore-selected") }}"
                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.restore") @lang("content.selected_flights")</button>
        @else
            <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="cancel-selected"
                    data-url="{{ url("flight-view/cancel-selected") }}"
                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.cancel") @lang("content.selected_flights")</button>

            <button type="button" class="btn btn-danger confirmation-modal-action-btn" data-action="delete-selected"
                    data-url="{{ url("flight-view/delete-selected") }}"
                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.remove") @lang("content.selected_flights")</button>
        @endif
    </div>

    <div class="clearfix"></div>

    <div class="jarviswidget jarviswidget-color-blueDark" id="{{ $type }}_container" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important; ">

            <div class="table-responsive">

                <table class="table table-bordered table-hover">
                    <thead>
                    <tr>
                        <th rowspan="2">SEL</th>
                        <th rowspan="2">No</th>
{{--                        @if ($sprAdm || $adm)--}}
                            <th rowspan="2" style="min-width: 160px;">@lang("content.actions")</th>
{{--                        @endif--}}

                        <th rowspan="2" style="min-width: 50px;">@lang("content.flight")</th>
                        <th rowspan="2">SVC TYPE</th>
                        <th rowspan="2">DEP</th>
                        <th rowspan="2">ARR</th>
                        <th rowspan="2">AC TYPE</th>
                        <th rowspan="2">@lang("content.aircraft")</th>
                        <th class="bg-success" rowspan="2">@lang("content.staff_assigned")</th>

                        <th colspan="5" data-center>@lang("content.departure_time")</th>
                        <th colspan="5" data-center>@lang("content.arrival_time")</th>

                        <th colspan="3">PAX BKD</th>
                        <th colspan="3">PAX ACT</th>

                        <th rowspan="2" style="min-width: 200px;">@lang("content.messages")</th>

                        @if ($type == CANCELLED)
                            <th colspan="2">@lang("content.cancelled")</th>
                        @elseif ($type == REMOVED)
                            <th colspan="2">@lang("content.removed")</th>
                        @else
                            <th rowspan="2">@lang("content.notes")</th>
                        @endif

                        <th colspan="2" data-center>@lang("content.last_update")</th>
                        <th colspan="2" data-center>@lang("content.created")</th>
                    </tr>
                    <tr>
                        <th style="min-width: 100px;">STD</th>
                        <th style="min-width: 100px;">PTD</th>
                        <th style="min-width: 100px;">ETD</th>
                        <th style="min-width: 100px;">ATD</th>
                        <th style="min-width: 100px;">ABN</th>

                        <th style="min-width: 100px;">STA</th>
                        <th style="min-width: 100px;">PTA</th>
                        <th style="min-width: 100px;">ETA</th>
                        <th style="min-width: 100px;">TDN</th>
                        <th style="min-width: 100px;">ATA</th>

                        <th>C</th>
                        <th>Y</th>
                        <th>INF</th>

                        <th>C</th>
                        <th>Y</th>
                        <th>INF</th>

                        @if ($type == CANCELLED || $type == REMOVED)
                            <th style="min-width: 80px;">@lang("content.date")</th>
                            <th style="min-width: 120px;">@lang("content.reason")</th>
                        @endif

                        <th style="min-width: 120px;">@lang("content.user")</th>
                        <th style="min-width: 100px;">@lang("content.date")</th>

                        <th style="min-width: 140px;">@lang("content.schedule")</th>
                        <th style="min-width: 100px;">@lang("content.data")</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($flights as $j => $each)
                        @php $aircraft = $each->aircraft @endphp
                        @php $flightNumber = $each->flightNumber @endphp
                        @php $acType = getFlightAircraftType($each) @endphp

                        @if ($each->deleted_at)
                            @php $notes = "Removed at ". $each->deleted_at. " (".$each->remark.")"; @endphp
                        @elseif ($each->cancelled_at)
                            @php $notes = "Cancelled at ". $each->cancelled_at. " (".$each->remark.")"; @endphp
                        @else
                            @php $notes = $each->remark @endphp
                        @endif

                        <tr data-flight_id="{{ $each->id }}">
                            <td>
                                {!! Form::checkbox("selected", "1", false, ['class' => 'form-control flight', "data-flight_id" => $each->id ]) !!}
                            </td>
                            <td>{{ $j + 1 }}</td>
{{--                            @if ($sprAdm || $adm)--}}
                                <td>
                                    <div class="btn-group">
                                        @if ($type == REMOVED)
                                            <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected" data-flight_id="{{ $each->id }}"
                                                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.restore")</button>
                                            <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="cancel-selected" data-flight_id="{{ $each->id }}"
                                                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.cancel")</button>
{{--                                            <a class="btn btn-primary" href="{{ url("flight/restore/{$each->id}") }}">@lang("content.restore")</a>--}}
{{--                                            <a class="btn btn-warning" href="{{ url("flight/cancel/{$each->id}") }}">@lang("content.cancel")</a>--}}
                                        @elseif ($type == CANCELLED)
                                            <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected" data-flight_id="{{ $each->id }}"
                                                    data-toggle="modal" data-target="#confirmation-modal">@lang("content.restore")</button>
                                            <button type="button" class="btn btn-danger confirmation-modal-action-btn" data-action="delete-selected" data-flight_id="{{ $each->id }}"
                                                    data-url="{{ url('flight-view/delete-selected') }}" data-toggle="modal" data-target="#confirmation-modal">@lang("content.remove")</button>
{{--                                            <a class="btn btn-primary" href="{{ url("flight/restore/{$each->id}") }}">@lang("content.restore")</a>--}}
{{--                                            <a class="btn btn-danger" href="{{ url("flight/remove/{$each->id}") }}">@lang("content.remove")</a>--}}
                                        @else
                                            @if ($each->deleted_at)
                                                <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected" data-flight_id="{{ $each->id }}"
                                                        data-toggle="modal" data-target="#confirmation-modal">@lang("content.restore")</button>

                                                <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="cancel-selected" data-flight_id="{{ $each->id }}"
                                                        data-toggle="modal" data-target="#confirmation-modal">@lang("content.cancel")</button>
                                                {{--                                                <a class="btn btn-primary" href="{{ url("flight/restore/{$each->id}") }}">@lang("content.restore")</a>--}}
{{--                                                <a class="btn btn-warning" href="{{ url("flight/cancel/{$each->id}") }}">@lang("content.cancel")</a>--}}
                                            @elseif ($each->cancelled_at)
                                                <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected" data-flight_id="{{ $each->id }}"
                                                        data-toggle="modal" data-target="#confirmation-modal">@lang("content.restore")</button>
                                                <button type="button" class="btn btn-danger confirmation-modal-action-btn" data-action="delete-selected" data-flight_id="{{ $each->id }}"
                                                        data-url="{{ url('flight-view/delete-selected') }}" data-toggle="modal" data-target="#confirmation-modal">@lang("content.remove")</button>
{{--                                                <a class="btn btn-primary" href="{{ url("flight/restore/{$each->id}") }}">@lang("content.restore")</a>--}}
{{--                                                <a class="btn btn-danger" href="{{ url("flight/remove/{$each->id}") }}">@lang("content.remove")</a>--}}
                                            @else
                                                <a target="_blank" href="{{ route("homepage")."#".url("flight/$each->id/edit") }}" class="btn btn-success">@lang("content.edit")</a>
                                                <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="cancel-selected" data-flight_id="{{ $each->id }}"
                                                        data-toggle="modal" data-target="#confirmation-modal">@lang("content.cancel")</button>
                                                <button type="button" class="btn btn-danger confirmation-modal-action-btn" data-action="delete-selected" data-flight_id="{{ $each->id }}"
                                                        data-url="{{ url('flight-view/delete-selected') }}" data-toggle="modal" data-target="#confirmation-modal">@lang("content.remove")</button>
{{--                                                <a class="btn btn-warning" href="{{ url("flight/cancel/{$each->id}") }}">@lang("content.cancel")</a>--}}
{{--                                                <a class="btn btn-danger" href="{{ url("flight/remove/{$each->id}") }}">@lang("content.remove")</a>--}}
                                            @endif
                                        @endif
                                    </div>
                                </td>
{{--                            @endif--}}
                            <td><a target="_blank" href="{{ url("flight-tracker/{$each->id}") }}">{{ getFlightNumberFull($flightNumber) }}</a></td>
                            <td>{{ getFlightNumberType($each->flightNumber)  }}</td>
                            <td>{{ getFlightDepartureAirport($each, false, true) }}</td>
                            <td>{{ getFlightArrivalAirport($each, false, true) }}</td>
                            <td>{{ $acType }}</td>
                            <td>{{ $aircraft ? $aircraft->name : "-" }}</td>
                            <td data-center>{!! $each->staff_exists ? "<i class='fa fa-check color-green'></i>" : "" !!}</td>

                            <td data-center>{!! $each->std && $each->std != EMPTY_DATETIME ? baseUSDateFormat($each->std, true, "-") : "<i class='fa fa-remove color-red'></i>" !!}</td>
                            <td data-center>{!! $each->ptd && $each->ptd != EMPTY_DATETIME ? baseUSDateFormat($each->ptd, true, "-") : "<i class='fa fa-remove color-red'></i>" !!}</td>
                            <td data-center>{!! $each->etd && $each->etd != EMPTY_DATETIME ? baseUSDateFormat($each->etd, true, "-") : "<i class='fa fa-remove color-red'></i>" !!}</td>
                            <td data-center>{!! $each->atd && $each->atd != EMPTY_DATETIME ? baseUSDateFormat($each->atd, true, "-") : "<i class='fa fa-remove color-red'></i>" !!}</td>
                            <td data-center>{!! $each->abn && $each->abn != EMPTY_DATETIME ? baseUSDateFormat($each->abn, true, "-") : "<i class='fa fa-remove color-red'></i>" !!}</td>

                            <td data-center>{!! $each->sta && $each->sta != EMPTY_DATETIME ? baseUSDateFormat($each->sta, true, "-") : "<i class='fa fa-remove color-red'></i>" !!}</td>
                            <td data-center>{!! $each->pta && $each->pta != EMPTY_DATETIME ? baseUSDateFormat($each->pta, true, "-") : "<i class='fa fa-remove color-red'></i>" !!}</td>
                            <td data-center>{!! $each->eta && $each->eta != EMPTY_DATETIME ? baseUSDateFormat($each->eta, true, "-") : "<i class='fa fa-remove color-red'></i>" !!}</td>
                            <td data-center>{!! $each->tdn && $each->tdn != EMPTY_DATETIME ? baseUSDateFormat($each->tdn, true, "-") : "<i class='fa fa-remove color-red'></i>" !!}</td>
                            <td data-center>{!! $each->ata && $each->ata != EMPTY_DATETIME ? baseUSDateFormat($each->ata, true, "-") : "<i class='fa fa-remove color-red'></i>" !!}</td>

                            <td>{{ $each->pax_c_booked }}</td>
                            <td>{{ $each->pax_y_booked }}</td>
                            <td>{{ $each->pax_inf_booked }}</td>

                            <td>{{ $each->pax_c_actual }}</td>
                            <td>{{ $each->pax_y_actual }}</td>
                            <td>{{ $each->pax_inf_actual }}</td>

                            <td>{!! getFlightMessages($each, 2, "") !!}</td>

                            @if ($type == CANCELLED)
                                <td><span class='color-red'>{{ baseUSDateFormat($each->cancelled_at, true, "-") }}</span></td>
                                <td><span class='color-red'>{{ $each->remark }}</span></td>
                            @elseif ($type == REMOVED)
                                <td><span class='color-red'>{{ baseUSDateFormat($each->deleted_at, true, "-") }}</span></td>
                                <td><span class='color-red'>{{ $each->remark }}</span></td>
                            @else
                                <td><span class='color-red'>{{ $notes }}</span></td>
                            @endif

                            <td>{{ $each->user ? $each->user->first_name." ".$each->user->last_name : "-" }}</td>
                            <td>{{ $each->updated_at ? baseUSDateFormat($each->updated_at, true, "-") : "-" }}</td>

                            @if ($each->flightSchedule)
                                <td>{{ $each->flightSchedule->name }}</td>
                                <td>{{ baseUSDateFormat($each->flightSchedule->created_at, true, "-") }}</td>
                            @else
                                <td>-</td>
                                <td>{{ baseUSDateFormat($each->created_at, true, "-") }}</td>
                            @endif
                        </tr>
                    @endforeach
                    </tbody>

                </table>

            </div>
        </div>

    </div>

</div>
@endif