<?php

    //initilize the page
    require_once(public_path("smart/inc/init.php"));

    //require UI configuration (nav, ribbon, etc.)
    require_once(public_path("smart/inc/config.ui.php"));

    include_once(public_path("smart/inc/user_variables.php"));


    /*---------------- PHP Custom Scripts ---------

    YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
    E.G. $page_title = "Custom Title" */

    $page_title = trans("modules.flight_tracker");

    /* ---------------- END PHP Custom Scripts ------------- */

    //include header
    //you can add your custom css in $page_css array.
    //Note: all css files are inside css/ folder
    $page_css[] = "your_style.css";

    $no_main_header = true;

    $page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

    include(public_path("smart/inc/header.php"));

?>


<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->
<header id="header" class="no-padding" >
    <!--<span id="logo"></span>-->

    <div id="logo-group"  style="height: 60px; width: 100%; padding: 0 15px;" class="flightTrackerBackground">
        <h2 class="flightTracker color-white">FlightTracker</h2>
        {{--<span> <img style="max-height: 70px" src="{{ $logo }}"  alt="Aviation-BIS"> </span>--}}
{{--        <h2><strong>{{ $logo_text }}</strong></h2>--}}
        <!-- END AJAX-DROPDOWN -->
    </div>

</header>

<div id="main" role="main">

    <!-- MAIN CONTENT -->
    <div id="content" class="">

        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="col-sm-12" style="padding: 0 0 20px 0; border-bottom: 1px solid #cecece; margin-bottom: 20px;">
                        @include("flight-tracker.form", [ "selectedAirline" => ($airlineObj ? $airlineObj->id : null), "selectedAirport" => $selectedAirport])
                    </div>

                    <div class="clearfix"></div>


                    @php $depDateTime = getFlightDepartureInitialDate($flight) @endphp
                    @php $flownPerc = getFlightProgressBarFlownPercentage($flight) @endphp

                    <div class="col-sm-7 margin-bottom-10" >

                        <div class="col-sm-12" style="padding: 0; margin: 0 0 20px 0;">
                            <div style="float: left; margin-right: 10px;">
                                @if ($airlineObj)
                                    <a target="_blank" href="{{ route("homepage")."#". url("/airline/{$airlineObj->id}") }}" class="">
                                        <img class='flightTracker-airline-logo' src='{{ $picture }}'/>
                                    </a>
                                @endif
                            </div>
                            <div style="float: left;">
                                <h2 class="flightTracker-airline">{{ $fn1 }}</h2>
                                <h3 class="flightTracker-airline">{{ $fn2." / ".$fn3 }}</h3>
                                <h5 class="flightTracker-airline margin-top-5">SVC TYPE: {{ getFlightNumberType($flight->flightNumber) }}</h5>
                            </div>
                        </div>

                        <h1 class="col-sm-6 flightTracker-airline">{{ $departureAirport ? $departureAirport->iata : "-" }}</h1>
                        <h1 class="col-sm-6 flightTracker-airline" data-right>{{ $arrivalAirport ? $arrivalAirport->iata : "-" }}</h1>

                        <h3 class="col-sm-6 flightTracker">{{ $depLocation }}</h3>
                        <h3 class="col-sm-6 flightTracker" data-right>{{ $arrLocation }}</h3>

                        @if ($tracker)
                            <h4 class="col-sm-6 flightTracker"><span class="flightTracker-3">{{ $tracker->forgdate ? "left" : ""}}</span> {{ $tracker->forgdate }}</h4>
                            <h4 class="col-sm-6 flightTracker" data-right><span class="flightTracker-3">{{ $tracker->fdstterminal ? "arriving at" : "" }}</span> {{ $tracker->fdstterminal ? "TERMINAL ".$tracker->fdstterminal : "" }}</h4>
                        @endif

                        <h4 class="col-sm-6 flightTracker">{{ $departureAirport ? $departureAirport->name : "-" }}</h4>
                        <h4 class="col-sm-6 flightTracker" data-right>{{ $arrivalAirport ? $arrivalAirport->name : "-" }}</h4>

                        <h3 class="col-sm-6 flightTracker">{{ getFlightDepartureInitialTimeType($flight, true).": ". baseDateFormat(getFlightDepartureInitialDate($flight), true) }}</h3>
                        <h3 class="col-sm-6 flightTracker" data-right>{{ getFlightArrivalInitialTimeType($flight, true)  .": ". baseDateFormat(getFlightArrivalInitialDate($flight), true) }}</h3>

                        <div class="col-sm-12 no-padding" style="margin: 10px 0;">
                            <div class="progress progress-xs" style="margin: 0;">
                                <div class="progress-bar progress-bar-{{ getFlightStatus($flight, $depDateTime, 2) }}" role="progressbar" aria-valuenow="{{ $flownPerc }}" aria-valuemin="0" aria-valuemax="100" style="width: {{ $flownPerc }}%">
                                </div>
                            </div>
                        </div>

                        @php $depTimeType = getFlightDepartureTimeType($flight) @endphp
                        @php $arrTimeType = getFlightArrivalTimeType($flight) @endphp

                        @if (!(in_array($depTimeType, [STD, PTD]) && in_array($arrTimeType, [STA, PTA])))
                            <h3 class="col-sm-6 flightTracker">{{ strtoupper($depTimeType).": ". baseDateFormat(getFlightDepartureDate($flight), true) }}</h3>
                            <h3 class="col-sm-6 flightTracker" data-right>{{ strtoupper($arrTimeType).": ". baseDateFormat(getFlightArrivalDate($flight), true) }}</h3>
                        @endif

                        @if ($flight->delaysString && count($flight->delaysString))
                            <div class="col-sm-12 no-padding margin-bottom-10">
                                @foreach($flight->delaysString as $each)
                                    <strong style="line-height: 1.5em; width: 95%; padding: 4px; background-color: #FF0500; color: #ffffff;">{{ $each }}</strong>
                                @endforeach
                            </div>
                        @endif
                    </div>

                    @if (count($chartAltGs))
                        <div class="col-sm-5">
                            <h3 class="col-sm-12 flightTracker-airline" style="margin-left: 10px;">Altitude (FL) / Ground Speed (KTS)</h3>

                            <div class="col-sm-12 no-padding">
                                <div class="chart" id="chartAltGs" style="min-width: 100%; height: 250px;" ></div>
                            </div>
                        </div>
                    @endif

                    <div class="clearfix"></div>

                    <ul class="nav nav-tabs bordered">
                        <li class="active"><a href="#flights" data-toggle="tab"><i class="fa fa-plane fa-lg"></i> @lang("content.flights")</a></li>
                        <li class=""><a href="#flight_messages" data-toggle="tab"><i class="fa fa-envelope fa-lg"></i> @lang("content.flight_messages")</a></li>
                        {{--<li class=""><a href="#flt_tab" role="tab"  data-toggle="tab">FLT</a></li>--}}
                        @foreach($messages as $type)
                            @if (in_array($type, [PRL, PNL]))
                                @php $hasMessage = isset($receivedMessages[$type]) && $receivedMessages[$type] && count($receivedMessages[$type]) && count($receivedMessages[$type]["pl_data"]) @endphp
                            @else
                                @php $hasMessage = isset($receivedMessages[$type]) && $receivedMessages[$type] && count($receivedMessages[$type]) @endphp
                            @endif
                            <li class=""><a href="#{{ $type }}_tab" id="{{ $type }}" class="{{ $hasMessage ? "has-message" : ""}}" role="tab" data-toggle="tab">{{ ucwords($type) }}</a></li>
                        @endforeach

                        <li class=""><a href="#sod_tab" class="{{ count($flight->staffList) ? "has-message" : ""}}" role="tab" data-toggle="tab">SOD</a></li>

                        @if (isAdminOrSuperAdmin())
                            <li class="bg-success"><a target="_blank" href="{{ route("homepage")."#system-log/flight-staff/{$flight->id}" }}">SOD History</a></li>
                            <li class="bg-primary"><a target="_blank" class="color-white" href="{{ route("homepage")."#system-log/flight/{$flight->id}" }}">Flight History</a></li>
                        @endif
                    </ul>

                    {{--Tab Content--}}
                    <div class="tab-content">

                        <div class="tab-pane bg-color-white active" id="flights" style="min-height: 550px; padding: 15px !important; width: 100%; overflow: auto;">
                            @if (airlineModule())
                                @include("flight-tracker.layouts.flights-list-airline", ["flightsOPS" => $historicFlights, "selectedFlightId" => $flight->id])
                            @else
                                @include("flight-tracker.layouts.flights-list", ["flightsOPS" => $historicFlights, "selectedFlightId" => $flight->id])
                            @endif
                        </div>

                        <div class="tab-pane bg-color-white" id="flight_messages" style="min-height: 550px; padding: 15px !important; width: 100%; overflow: auto;">
                            @include("flight-tracker.layouts.flight-messages-tab", ["flightsOPS" => $historicFlights, "selectedFlightId" => $flight->id])
                        </div>

                        {{--<div class="tab-pane" id="flt_tab" style="min-height: 300px"></div>--}}

                        @foreach($messages as $type)
                            @if (in_array($type, [PNL, PRL]))
                                <div class="tab-pane" id="{{ $type }}_tab" style="min-height: 300px">
                                    @include("flight-tracker.layouts.pl-tab", ["type" => $type, "hasMessage" => $hasMessage])
                                </div>
                            @else
                                @php $hasMessage = isset($receivedMessages[$type]) && $receivedMessages[$type] && count($receivedMessages) @endphp
                                <div class="tab-pane" id="{{ $type }}_tab" style="min-height: 300px">
                                    @include("flight-tracker.layouts.message-tab", ["type" => $type, "hasMessage" => $hasMessage])
                                </div>
                            @endif
                        @endforeach

                        <div class="tab-pane" id="sod_tab" style="min-height: 500px">
                            @include("flight-tracker.layouts.sod-table", ["minHeight" => "400px"])
                        </div>

{{--                        @if (isAdminOrSuperAdmin())--}}
{{--                            <div class="tab-pane" id="staff_log_tab" style="min-height: 300px">--}}
{{--                                @include("flight-tracker.layouts.flight-staff-log-tab")--}}
{{--                            </div>--}}
{{--                            <div class="tab-pane" id="log_tab" style="min-height: 300px">--}}
{{--                                @include("flight-tracker.layouts.flight-log-tab")--}}
{{--                            </div>--}}
{{--                        @endif--}}
                    </div>

                </article>

            </div>

        </section>

    </div>

</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<script type="text/javascript">
    var baseUrl = "{{ url('/') }}";
    var baseDashboardUrl = "{{ url('home/dashboard') }}";
    var baseHomeUrl = "{{ route("homepage")."#". url('/') }}";
    var AIRLINE = "{{ env("AIRLINE") }}";
    var CARRIER = "{{ env("CARRIER") }}";
    var CURRENT_IATA_CODE = "{{ env("IATA_CODE") }}";
</script>

<?php
    //include required scripts
    include(public_path("smart/inc/scripts.php"));
?>


<!-- PAGE RELATED PLUGIN(S)-->

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#ops-table");

        ApplyTableFilter("#flightLogTable", null, [[ 3, "asc" ]]);

        @if (count($chartAltGs))
            var data = {!! json_encode($chartAltGs) !!};
            Morris.Line({
                element: 'chartAltGs',
                data: data,
                lineWidth : 3,
                pointSize : 1,
                xkey: 'Date',
                lineColors : ["#1b63de", "#45ADF6"],
                pointStrokeColors : ["#1b63de", "#45ADF6"],
                ykeys: ['Speed', 'Altitude'],
                labels: ['Ground Speed(KTS)', 'Altitude(FL)']
            });
        @endif
    };

    loadScript("{{ asset("/assets/js/vendor/raphael-min.js") }}", function () {
        loadScript("{{ asset("/assets/js/vendor/morris.min.js") }}", pagefunction);
    });

</script>

<script type="text/javascript">

    runAllForms();

</script>

