<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 12.09.14

 */
?>

@php $maxHeight = isset($maxHeight) && $maxHeight ? $maxHeight : "500px" @endphp
@php $minHeight = isset($minHeight) && $minHeight ? $minHeight : "200px" @endphp
@php $airlineModule = isset($airlineModule) ? $airlineModule : airlineModule() @endphp
<div class="col-lg-12 staff-container" data-type="" style="min-height: {{ $minHeight }}; max-height:{{ $maxHeight }}; overflow: auto;">

    <table id="staff-table" class="table table-bordered table-striped table-hover" data-opened="0" style="padding: 0;">
        <thead>
        <tr>
            <th>SLA</th>
            <th>Staff</th>
            <th>Start Time</th>
            <th>Release Time</th>
            <th>Duration</th>
        </tr>
        </thead>

        <tbody id="staff-table-body">

            @foreach($serviceData["services"] as $airlineService)
                @php $serviceType = $airlineService->serviceType @endphp

                @if ($airlineService->service_timings == 1)
                    @if ($airlineService->service[$serviceType] != 1)
                        @continue
                    @endif

                    @php $obj = $airlineService->service @endphp
                @else
                    @if ($airlineService[$serviceType] != 1)
                        @continue
                    @endif

                    @php $obj = $airlineService @endphp
                @endif

                @if ($serviceType == ARRIVAL_SERVICE)
                    @php $req = "arr_staff_req" @endphp
                    @php $min = "arr_staff_min" @endphp
                    @php $arr = getFlightArrivalInitialDatePTA($flight); @endphp
                    @php $plannedReport = date("Y-m-d H:i:s", strtotime($arr) - (60 * $obj->arr_report_time)) @endphp
                    @php $plannedRelease = date("Y-m-d H:i:s", strtotime($arr) + (60 * $obj->arr_release_time)) @endphp
                    @php $duration = date("H:i", strtotime($plannedRelease) - strtotime($plannedReport)) @endphp
                    @php $slaClass = "label-success" @endphp
                @elseif ($serviceType == DEPARTURE_SERVICE)
                    @php $req = "dep_staff_req" @endphp
                    @php $min = "dep_staff_min" @endphp
                    @php $dep = getFlightDepartureInitialDatePTD($flight) @endphp
                    @php $plannedReport = date("Y-m-d H:i", strtotime($dep) - (60 * $obj->dep_report_time)) @endphp
                    @php $plannedRelease = date("Y-m-d H:i", strtotime($dep) - (60 * $obj->dep_release_time)) @endphp
                    @php $duration = date("H:i", strtotime($plannedRelease) - strtotime($plannedReport)) @endphp
                    @php $slaClass = "label-primary" @endphp
                @elseif($serviceType == TURNAROUND_SERVICE)
                    @php $req = "turn_staff_req" @endphp
                    @php $min = "turn_staff_min" @endphp
                    @php $arr = getFlightArrivalInitialDatePTA(getParentFlight($flight)) @endphp
                    @php $dep = getFlightDepartureInitialDatePTD($flight) @endphp
                    @php $plannedReport = date("Y-m-d H:i", strtotime($arr) - (60 * $obj->turn_report_time)) @endphp
                    @php $plannedRelease = date("Y-m-d H:i", strtotime($dep) - (60 * $obj->turn_release_time)) @endphp
                    @php $duration = date("H:i", strtotime($plannedRelease) - strtotime($plannedReport)) @endphp
                    @php $slaClass = "label-warning" @endphp
                @endif

                @php $sla = $obj->service ? $obj->service->abbr : $obj->abbr @endphp
                <tr class="sla-header">
                    <td data-center="">
                        <span class="label font-sm {{ $slaClass }}">{{ $sla }}</span>
                    </td>
                    <td><strong>Required: {{ $obj->{$req} }}</strong></td>
                    <td>{{ baseDateFormat($plannedReport, true) }}
                        <span class="label label-warning">SLA</span>
                    </td>
                    <td>{{ baseDateFormat($plannedRelease, true) }} <span class="label label-warning">SLA</span></td>
                    <td>{{ $duration }} <span class="label label-warning">SLA</span></td>
                </tr>

                @if (isset($flight->staffList[$sla]))
                    @foreach($flight->staffList[$sla] as $i => $each)
                        @php $plannedDuration = date("H:i", strtotime($each->planned_release_time) - strtotime($each->planned_report_time)); @endphp
                        <tr>
                            <td style="vertical-align: middle" data-center="">{{ $i + 1 }}</td>
                            <td class="staff-name">{{ getUserLocation($each->user) }} - {{ getUserName($each->user) }}</td>
                            <td>{{ baseDateFormat($each->planned_report_time, true) }} <span class="label label-success">PLN</span>
                                @if ($each->report_time)
                                    <br>
                                    {{ baseDateFormat($each->report_time, true) }} <span class="label label-primary">ACT</span>
                                @endif
                            </td>
                            <td>{{ baseDateFormat($each->planned_release_time, true) }} <span class="label label-success">PLN</span>
                                @if ($each->release_time)
                                    <br>
                                    {{ baseDateFormat($each->release_time, true) }} <span class="label label-primary">ACT</span>
                                @endif
                            </td>
                            <td>{{ $plannedDuration }} <span class="label label-success">PLN</span>
                                @if ($each->report_time && $each->release_time)
                                    @php $duration = date("H:i", strtotime($each->release_time) - strtotime($each->report_time)); @endphp
                                    <br>
                                    {{ $duration }} <span class="label label-primary">ACT</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                @endif
            @endforeach
        </tbody>
    </table>
</div>
