<div class="" style="padding: 15px;">
    @if (isset($receivedMessages[$type]))
        @php $psnNos = count($receivedMessages[$type]["pl"]) @endphp
        @php $psnNos += count($receivedMessages[$type]["plInf"]) @endphp

        <ul id="pl-tab-info" class="nav nav-pills">
            <li class="active">
                <a href="#{{ $type }}_raw_data" data-toggle="tab"><i class="fa fa-fw fa-lg fa-database"></i> @lang("content.message") <span
                            class="badge badge-warning" id="pl-raw-data">{{ count($receivedMessages[$type]["pl_data"]) }}</span></a>
            </li>
            <li class="">
                <a href="#{{ $type }}_list" data-toggle="tab"><i class="fa fa-fw fa-lg fa-user"></i> @lang("content.passengers") <span
                            class="badge badge-warning" id="pl-passenger-no">{{ $psnNos }}</span></a>
            </li>
            <li class="">
                <a href="#{{ $type }}_details" data-toggle="tab"><i class="fa fa-fw fa-lg fa-info-circle"></i> @lang("content.details") <span
                            class="badge badge-success" id="pl-xbag-no">{{ count($receivedMessages[$type]["plDetails"]) }}</span></a>
            </li>
            <li>
                <a href="#{{ $type }}_inbound" data-toggle="tab"><i class="fa fa-fw fa-lg fa-sign-in"></i> @lang("content.inbound") <span
                            class="badge badge-success" id="pl-inbound-no">{{ count($receivedMessages[$type]["plInbound"]) }}</span></a>
            </li>
            <li>
                <a href="#{{ $type }}_outbound" data-toggle="tab"> @lang("content.outbound") <i class="fa fa-fw fa-lg fa-sign-out"></i><span
                            class="badge badge-success" id="pl-outbound-no">{{ count($receivedMessages[$type]["plOutbound"]) }}</span></a>
            </li>
            <li>
                <a href="#{{ $type }}_xbag" data-toggle="tab"><i class="fa fa-fw fa-lg fa-suitcase"></i> @lang("content.XBAG") <span
                            class="badge badge-success" id="pl-xbag-no">{{ count($receivedMessages[$type]["plXBag"]) }}</span></a>
            </li>
            @if ($airlineModule)
                <li>
                    <a href="#{{ $type }}_docs" data-toggle="tab"><i class="fa fa-fw fa-lg fa-file-text-o"></i> @lang("content.DOCS") <span
                                class="badge badge-success" id="pl-docs-no">{{ count($receivedMessages[$type]["plDocs"]) }}</span></a>
                </li>
            @endif
        </ul>

        <div id="pl-tab-content" class="pill-content padding-10">

            <div class="pill-pane active" id="{{ $type }}_raw_data">
                @foreach($receivedMessages[$type]["pl_data"] as $each)
                    <div class='message-item'>
                        <pre>{{ $each }}</pre>
                    </div>
                @endforeach
            </div>

            <div class="pill-pane" id="{{ $type }}_list">
                <div class="col-md-12" style="margin: 10px 0">
                    <h5 class="pnl">
                        <span class="margin-right-13"><span class="color-item inbound"></span>@lang("content.inbound")</span>
                        <span class="margin-right-13"><span class="color-item outbound"></span>@lang("content.outbound")</span>
                        <span class="margin-right-13"><span class="color-item outbound-inbound"></span>@lang("content.inbound")/@lang("content.outbound")</span>
                        <span class="margin-right-13"><span class="color-item inf"></span>@lang("content.infant")</span>
                        <span class="margin-right-13"><i class="fa font-sm fa-suitcase"></i>@lang("content.extra_baggage")</span>
                    </h5>
                </div>

                <div class="clearfix"></div>

                <div id="pl-container">
                    <table id="pl-table" class="table table-bordered table-striped table-hover" data-opened="0" style="">
                        <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th width="5%">SEQ</th>
                            <th><i class="fa fa-md fa-suitcase"></i></th>
                            <th>@lang("content.first_name")</th>
                            <th>@lang("content.last_name")</th>
                            <th>G</th>
                            <th>@lang("content.seat")</th>
                            <th>@lang("content.GRP")</th>
                            <th>@lang("content.ticket_number")</th>
                            <th>CPN</th>
                            <th>PNR</th>
                            <th>FQTV</th>
                            {{--<th>Cabin</th>--}}
                            {{--<th>Bag(pcs)</th>--}}
                            {{--<th>Bag(wt)</th>--}}
                            {{--<th>DOB</th>--}}
                        </tr>
                        </thead>
                        <tbody id="pl-table-body">

                            @php $last_seq_no = 0 @endphp
                            @php $xbag_icon = '<i class="fa fa-sm fa-suitcase"></i>' @endphp

                            @php $i = 0 @endphp
                            @foreach($receivedMessages[$type]["pl"] as $each)

                                @php $icons = "" @endphp

                                @if ($each["seq_no"])
                                    @if ($last_seq_no + 1 == $each["seq_no"])
                                        @php $td_class = "num_conseq" @endphp
                                    @else
                                        @php $td_class = "" @endphp
                                    @endif

                                    @php $last_seq_no = $each["seq_no"] @endphp
                                @else
                                    @php $td_class = "" @endphp
                                @endif

                                @if ($each["outbound"] && $each["inbound"])
                                    @php $tr_class = 'outbound-inbound' @endphp
                                @elseif ($each["outbound"])
                                    @php $tr_class = 'outbound' @endphp
                                @elseif ($each["inbound"])
                                    @php $tr_class = 'inbound' @endphp
                                @else
                                    @php $tr_class = "" @endphp
                                @endif


                                @if ($each["xbag_wt"])
                                    @php $icons .= $xbag_icon @endphp
                                @endif

                                @php $ticket_number = ($each["ticket_number"] ? $each["ticket_number"] : '') @endphp

                                <tr class='text-center {{ $tr_class }}'>
                                    <td class=''>{{ ($i + 1) }}</td>
                                    <td class='{{ $td_class }}'>{{ ($each["seq_no"] ? $each["seq_no"] : "-") }}</td>
                                    <td data-left>
                                        <div class='inline'>{!! $icons !!}</div>
                                    </td>
                                    <td data-left>{{ $each["first_name"] }}</td>
                                    <td data-left>{{ $each["last_name"] }}</td>
                                    <td>{!!  ($each["gender"]            ? getGenderAbbr($each["gender"]) : '') !!}</td>
                                    <td>{{ ($each["seat_number"]       ? $each["seat_number"]    : '') }}</td>
                                    <td>{{ ($each["group_tcp"]         ? $each["group_tcp"]    : '') }}</td>
                                    <td data-left class='{{ (!$ticket_number ? "error" : "") }}'>{{ ($ticket_number ? $ticket_number : "N/A") }}</td>
                                    <td>{{ ($each["coupon"]            ? $each["coupon"]    : '') }}</td>
                                    <td>{{ ($each["pnr"]               ? $each["pnr"]    : '') }}</td>
                                    <td>{{ ($each["ff_airline"]        ? $each["ff_airline"] : "") . ($each["ff_no"] ?  $each["ff_no"] : "") }}</td>
                                </tr>

                                @if (isset($each["inf"]))
                                @foreach($each["inf"] as $j =>$inf)
                                    @php $ticket_number = $inf["ticket_number"] ? $inf["ticket_number"] : '' @endphp
                                    <tr class='text-center inf'>
                                        <td>INF</td>
                                        <td>-</td>
                                        <td><i class='fa fa-chevron-up'></i></td>
                                        <td data-left>{{ $inf["last_name"] }}</td>
                                        <td data-left>{{ $inf["first_name"] }}</td>
                                        <td></td>
                                        <td>{{ ($inf["seat_number"]   ? $inf["seat_number"]    : '') }}</td>
                                        <td>{{ ($inf["group_tcp"]     ? $inf["group_tcp"]    : '') }}</td>
                                        <td data-left
                                            class='{{ (!$ticket_number ? "error" : "") }}'>{{ ($ticket_number ? $ticket_number : "N/A") }}</td>
                                        <td>{{ ($inf["coupon"]        ? $inf["coupon"]    : '') }}</td>
                                        <td>{{ ($inf["pnr"]           ? $inf["pnr"]    : '') }}</td>
                                        <td></td>
                                    </tr>
                                @endforeach
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="pill-pane" id="{{ $type }}_details">
                <div id="pl-bag-container" style="">
                    <table id="pl-bag-table" class="table table-bordered table-striped table-hover" data-opened="0">
                        <thead>
                        <tr>
                            <th rowspan="2" width="5%">No</th>
                            <th rowspan="2">@lang("content.first_name")</th>
                            <th rowspan="2">@lang("content.last_name")</th>
                            <th colspan="2" data-center>@lang("content.resident")</th>
                            <th colspan="3" data-center>@lang("content.baggage")</th>
                        </tr>
                        <tr>
                            <th>@lang("content.country")</th>
                            <th>@lang("content.address")</th>

                            <th>PCS</th>
                            <th>@lang("content.weight")</th>
                            <th>@lang("content.tag_number")</th>
                        </tr>
                        </thead>
                        <tbody id="pl-xbag-table-body">
                        @foreach($receivedMessages[$type]["plDetails"] as $i =>$each)
                            @php $flag = isset($each["resident_country"]) ? "flag flag-" . strtolower($each["resident_country"]) : null @endphp
                            @php $tags = explode(";", $each["tag_number"]) @endphp
                            <tr class='text-center'>
                                <td>{{ ($i + 1) }}</td>
                                <td data-left>{{ $each["first_name"] }}</td>
                                <td data-left>{{ $each["last_name"] }}</td>
                                <td data-left>
                                    @if($flag)
                                        <img style="margin-right:5px;" class="{{ $flag }}" src="{{ asset("/smart/img/blank.gif") }}" alt="" />
                                        {{  $each["resident_country"] ? $each["resident_country"] : ""}}
                                    @endif
                                </td>
                                <td data-left>{{ $each["address"] }}</td>
                                <td data-left>{{ $each["baggage_pcs"] }}</td>
                                <td data-left>{{ $each["baggage_weight"] }}</td>

                                <td data-left>
                                    @if (count($tags))
                                        <select>
                                            @foreach($tags as $tag)
                                                <option>{{ $tag }}</option>
                                            @endforeach
                                        </select>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="pill-pane" id="{{ $type }}_inbound">
                <div id="pl-inbound-container" style="">
                    <table id="pl-inbound-table" class="table table-bordered table-striped table-hover" data-opened="0">
                        <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th>@lang("content.first_name")</th>
                            <th>@lang("content.last_name")</th>
                            <th>@lang("content.flight_number")</th>
                            <th>RBD</th>
                            <th>@lang("content.arrival")</th>
                            <th>@lang("content.origin")</th>
                        </tr>
                        </thead>
                        <tbody id="pl-inbound-table-body">

                        @foreach($receivedMessages[$type]["plInbound"] as $i =>$each)
                            @php $flight_number = $each["inbound"]["airline"] @endphp
                            @php $flight_number .= $each["inbound"]["flight_number"] @endphp

                            <tr class='text-center'>
                                <td>{{ ($i + 1) }}</td>
                                <td data-left>{{ $each["first_name"] }}</td>
                                <td data-left>{{ $each["last_name"] }}</td>
                                <td data-left>{{ $flight_number }}</td>
                                <td>{{ ($each["inbound"]["rbd"]              ? $each["inbound"]["rbd"] : '-') }}</td>
                                <td>{{ ($each["inbound"]["arrival_date"]   ? $each["inbound"]["arrival_date"] : '-') }}</td>
                                <td>{{ ($each["inbound"]['origin']      ? $each["inbound"]["origin"] : '-') }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="pill-pane" id="{{ $type }}_outbound">
                <div id="pl-outbound-container" style="">
                    <table id="pl-outbound-table" class="table table-bordered table-striped table-hover" data-opened="0">
                        <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th colspan="2">@lang("content.passenger")</th>
                            <th colspan="4">@lang("content.flight_details")</th>
                            <th colspan="2">PTM @lang("content.data")</th>
                            <th colspan="2">@lang("content.baggage")</th>
                        </tr>
                        <tr>
                            <th>@lang("content.first_name")</th>
                            <th>@lang("content.last_name")</th>

                            <th rowspan="2">@lang("content.flight_number")</th>
                            <th rowspan="2">RBD</th>
                            <th rowspan="2">@lang("content.departure")</th>
                            <th rowspan="2">@lang("content.destination")</th>

                            <th>@lang("content.other_info")</th>
                            <th>PAX</th>

                            <th>PCS</th>
                            <th>WT</th>
                        </tr>
                        </thead>
                        <tbody id="pl-outbound-table-body">
                        @foreach($receivedMessages[$type]["plOutbound"] as $i =>$each)
                            @php $flight_number = $each["outbound"]["airline"] @endphp
                            @php $flight_number .= $each["outbound"]["flight_number"] @endphp

                            <tr class='text-center'>
                                <td>{{ ($i + 1) }}</td>
                                <td data-left>{{ $each["first_name"] }}</td>
                                <td data-left>{{ $each["last_name"] }}</td>
                                <td data-left>{{ $flight_number }}</td>
                                <td>{{ ($each["outbound"]["rbd"]              ? $each["outbound"]["rbd"] : '-') }}</td>
                                <td>{{ ($each["outbound"]["departure_date"]   ? $each["outbound"]["departure_date"] : '-') }}</td>
                                <td>{{ ($each["outbound"]['destination']      ? $each["outbound"]["destination"] : '-') }}</td>

                                <td data-left>{{ ($each["ptm_name_str"] ? $each["ptm_name_str"] : "") }}</td>
                                <td>{{ ($each["ptm_pax"] ? $each["ptm_pax"] : "") }}</td>
                                <td>{{ ($each["baggage_pcs"] ? $each["baggage_pcs"] : "") }}</td>
                                <td data-right>{{ ($each["baggage_weight"] ? $each["baggage_weight"] : "" ) }}</td>

                           </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="pill-pane" id="{{ $type }}_xbag">
                <div id="pl-xbag-container" style="">
                    <table id="pl-xbag-table" class="table table-bordered table-striped table-hover" data-opened="0">
                        <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th>@lang("content.first_name")</th>
                            <th>@lang("content.last_name")</th>
                            <th>@lang("content.weight")</th>
                        </tr>
                        </thead>
                        <tbody id="pl-xbag-table-body">
                        @foreach($receivedMessages[$type]["plXBag"] as $i =>$each)
                            @php $weight = "" @endphp
                            @if ($each["xbag_info"])
                                @php $weight .= $each["xbag_info"][0] ." " @endphp
                            @endif

                            @if ($each["xbag_wt"])
                                @php $weight .= $each["xbag_wt"] ."KG " @endphp
                            @endif

                            @if ($each["xbag_info"] && count($each["xbag_info"]) >1)
                                @php $weight .= $each["xbag_info"][1] @endphp
                            @endif

                            <tr class='text-center'>
                                <td>{{ ($i + 1) }}</td>
                                <td data-left>{{ $each["first_name"] }}</td>
                                <td data-left>{{ $each["last_name"] }}</td>
                                <td data-left>{{ ($each["xbag_qty"] ? ($each["xbag_qty"] ."BAGS ") : "") . $weight }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            @if ($airlineModule)
                <div class="pill-pane" id="{{ $type }}_docs">
                    <div id="pl-docs-container" style="">
                        <table id="pl-docs-table" class="table table-bordered table-striped table-hover" data-opened="0">
                            <thead>
                            <tr>
                                <th width="5%">No</th>
                                <th>@lang("content.first_name")</th>
                                <th>@lang("content.last_name")</th>
                                <th>@lang("content.gender")</th>
                                <th>@lang("content.dob")</th>
                                <th>@lang("content.passport_no")</th>
                                <th>@lang("content.country_of_issue")</th>
                                <th>@lang("content.dex")</th>
                            </tr>
                            </thead>
                            <tbody id="pl-docs-table-body">
                            @foreach($receivedMessages[$type]["plDocs"] as $i =>$each)
                                @php $flag = isset($each["passport_country"]) ? "flag flag-" . strtolower($each["passport_country"]) : null @endphp

                                <tr class='text-center'>
                                    <td>{{  $i + 1 }}</td>
                                    <td data-left>{{$each["first_name"]}}</td>
                                    <td data-left>{{$each["last_name"]}}</td>
                                    <td>{!! $each["gender"]  ? getGenderAbbr($each["gender"]) : '' !!}</td>
                                    <td data-left>{{$each["dob"]}}</td>
                                    <td data-left>{{$each["passport_num"]}}</td>
                                    <td data-left>
                                        @if($flag)
                                            <img style="margin-right:5px;" class="{{ $flag }}" src="{{ asset("/smart/img/blank.gif") }}" alt="" />
                                            {{  $each["passport_country"] ? $each["passport_country"] : ""}}
                                        @endif
                                    </td>

                                    <td data-left>{{  $each["passport_dex"] ? $each["passport_dex"] : "" }}</td>
                                </tr>
                            @endforeach


                            </tbody>
                        </table>
                    </div>
                </div>
            @endif
        </div>
    @endif
</div>