<table class="table table-bordered table-hover table-striped ops-table" id="{{ isset($tableId) && $tableId ? $tableId : "ops-table" }}">
    <thead>
    <tr class="ops-header">
        @if (env(CARRIER) == HANDLING)
            <th data-center>@lang("content.AIRLINE")</th>
        @endif

        <th data-center>@lang("content.FLT")</th>

        <th data-center>@lang("content.NOTES")</th>
        <th data-center>@lang("content.DEP")</th>

        <th data-center>STD</th>
        <th data-center>PTD</th>
        <th data-center>ETD</th>
        <th data-center>ATD</th>
        <th data-center>ABN</th>

        <th data-center> @lang("content.ARR")</th>

        <th data-center>STA</th>
        <th data-center>PTA</th>
        <th data-center>ETA</th>
        <th data-center>TDN</th>
        <th data-center>ATA</th>

        <th data-center>@lang("content.AC")</th>
        <th data-center>@lang("content.STATUS")</th>
    </tr>

    </thead>

    <tbody>
    @if (isset($flightsOPS) && count($flightsOPS))

        @foreach($flightsOPS as $flight)
            @php $flightUrl = isset($flightDetails) ? url("flight-details/{$flight->id}") : url("flight-tracker/{$flight->id}") @endphp
            @php $aircraft = $flight->aircraft @endphp
            @php $aircraftType = $flight->aircraft && $flight->aircraft->type ? $flight->aircraft->type : $flight->aircraftType @endphp
            @php $flightNumber = $flight->flightNumber @endphp
            @php $airline = $flightNumber->airline @endphp

            @php $divertedFlight = $flight->divertedAirport @endphp
            @php $departureAirport = $flight->departureAirport ? $flight->departureAirport : $flightNumber->departureAirport @endphp
            @php $arrivalAirport = $flight->arrivalAirport ? $flight->arrivalAirport : $flightNumber->arrivalAirport @endphp

            @php $depDateTime = getFlightDepartureInitialDate($flight) @endphp
            @php $depDate = date("Y-m-d", strtotime($depDateTime)) @endphp

            @php $arrDateTime = getFlightArrivalInitialDate($flight) @endphp
            @php $arrDate = date("Y-m-d", strtotime($arrDateTime)) @endphp
            @php $picture = $airline && $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png") @endphp

            <tr class="ops-body {{ isset($selectedFlightId) && $selectedFlightId == $flight->id ? "selected" : "" }}">
                @if (env(CARRIER) == HANDLING)
                    <td data-center style="font-weight: 500">
                        <a target="_blank" href="{{ route("homepage")."#". url("/airline/{$airline->id}") }}" class="">
                            <img class='ops-airline-logo' src='{{ $picture }}'/>
                        </a>
                    </td>
                @endif

                <td>
                    <a target="_blank" href="{{ $flightUrl }}">{{ ($airline ? ($airline->iata ? $airline->iata : $airline->icao) : "")." ".$flightNumber->flight_number }}</a>
                </td>
                <td>
                    <span class="color-red">{{ $divertedFlight ? "DIVERTED" : $flight->remark }}</span>
                </td>

                <td>{{ $departureAirport ? $departureAirport->iata : "-" }}</td>

                <td>{{ baseDateFormat($depDate)." ".getFlightTimeComparedToBase($flight, STD, $depDate) }}</td>
                <td>{{ getFlightTimeComparedToBase($flight, PTD, $depDate) }}</td>
                <td>{{ $etd = getFlightTimeComparedToBase($flight, ETD, $depDate) }}</td>
                <td class="status">
                    <span class="{{ getFlightDepartureStatus($flight, $depDateTime) }}"></span>
                    <span>{{ $atd = getFlightTimeComparedToBase($flight, ATD, $depDate) }}</span>
                </td>

                <td>{{ getFlightTimeComparedToBase($flight, ABN, $depDate) }}</td>

                <td>{{ $arrivalAirport ? $arrivalAirport->iata : "" }}</td>

                <td>{{ baseDateFormat($arrDate)." ".getFlightTimeComparedToBase($flight, STA, $arrDate) }}</td>
                <td>{{ getFlightTimeComparedToBase($flight, PTA, $arrDate) }}</td>
                <td>{{ $eta = getFlightTimeComparedToBase($flight, ETA, $arrDate) }}</td>
                <td>{{ getFlightTimeComparedToBase($flight, TDN, $arrDate) }}</td>
                <td class="status">
                    <span class="{{ getFlightArrivalStatus($flight, $arrDateTime) }}"></span>
                    <span>{{ $ata = getFlightTimeComparedToBase($flight, ATA, $arrDate) }}</span>
                </td>

                <td>{{ ($aircraftType ? $aircraftType->icao : "").($aircraft ? "(".$aircraft->name.")" : "")  }}</td>
                <td>
                    <span>{{ getFlightStatusMessage($flight, $depDateTime, $eta, $ata, $etd, $atd) }}</span>
                </td>
            </tr>
        @endforeach
    @endif
    </tbody>
</table>
