@php $airlineModule = airlineModule() @endphp
<ul class="nav nav-pills">
    <li class="{{ $airlineModule ? "" : "active" }}">
        <a href="#tabDepartures" data-toggle="tab">@lang("content.departures")</a>
    </li>
    <li class="">
        <a href="#tabArrivals" data-toggle="tab">@lang("content.arrivals")</a>
    </li>
    <li class="{{ $airlineModule ? "active" : "" }}">
        <a href="#tabAll" data-toggle="tab">@lang("content.all")</a>
    </li>
</ul>

<div class="tab-content" style="background: #e3e3e3; margin-top: 10px;">
    @if ($airlineModule)
        {{--General Tab--}}
        <div class="tab-pane bg-color-white editable_div" id="tabDepartures" style="">
            @include('flight-tracker.layouts.flights-list-airline', ["flightsOPS" => $flightsOPS[DEPARTURE], "tableId" => "tableFltDepartures"])
        </div>

        <div class="tab-pane bg-color-white editable_div" id="tabArrivals" style="">
            @include('flight-tracker.layouts.flights-list-airline', ["flightsOPS" => $flightsOPS[ARRIVAL], "tableId" => "tableFltArrivals"])
        </div>

        <div class="tab-pane active bg-color-white editable_div" id="tabAll" style="">
            @include('flight-tracker.layouts.flights-list-airline', ["flightsOPS" => $flightsOPS[ALL], "tableId" => "tableFltAll"])
        </div>
    @else
        {{--General Tab--}}
        <div class="tab-pane {{ $airlineModule ? "" : "active" }} bg-color-white editable_div" id="tabDepartures" style="">
            @include('flight-tracker.layouts.flights-list', ["flightsOPS" => $flightsOPS[DEPARTURE], "tableId" => "tableFltDepartures"])
        </div>

        <div class="tab-pane bg-color-white editable_div" id="tabArrivals" style="">
            @include('flight-tracker.layouts.flights-list', ["flightsOPS" => $flightsOPS[ARRIVAL], "tableId" => "tableFltArrivals"])
        </div>

        <div class="tab-pane {{ $airlineModule ? "active" : "" }} bg-color-white editable_div" id="tabAll" style="">
            @include('flight-tracker.layouts.flights-list', ["flightsOPS" => $flightsOPS[ALL], "tableId" => "tableFltAll"])
        </div>
    @endif
</div>
