@php $checkbox = isset($checkbox) && $checkbox @endphp

<table class="table table-bordered table-hover table-striped ops-table" style="width: 100% !important;" id="{{ isset($tableId) && $tableId ? $tableId : "ops-table" }}">
    <thead>
    <tr class="ops-header">
        @if ($checkbox)
            <th rowspan="2" data-center class="checkbox-column">@lang("content.select")</th>
        @else
            <th rowspan="2" data-center class="checkbox-column" style="display: none;">@lang("content.select")</th>
        @endif

        <th rowspan="2" data-center>@lang("content.FLT") No.</th>
{{--        <th rowspan="2" data-center>ATC<br>C/S</th>--}}
        <th rowspan="2" data-center>NOTES</th>
        <th rowspan="2" data-center>AC</th>
        <th rowspan="2" data-center>DEP STN</th>
        <th rowspan="2" data-center style="min-width: 40px;">STD</th>
        <th rowspan="2" data-center style="min-width: 60px;">DEP</th>
{{--        <th data-center>PTD</th>--}}
{{--        <th data-center>ETD</th>--}}
{{--        <th data-center>ATD</th>--}}
        <th rowspan="2" data-center>ABN</th>
        <th rowspan="2" data-center>POS</th>
        <th rowspan="2" data-center>GATE</th>
        <th rowspan="2" data-center>CKIN CTRS</th>

{{--        <th data-center colspan="2">CFG</th>--}}
        <th data-center colspan="3">PAX</th>
        <th data-center colspan="2">DELAY</th>

        <th rowspan="2" data-center>ARR STN</th>
        <th rowspan="2" data-center style="min-width: 40px;">STA</th>

{{--        <th rowspan="2" data-center>TDN</th>--}}

        <th rowspan="2" data-center style="min-width: 60px;">ARR</th>
{{--        <th data-center>PTA</th>--}}
{{--        <th data-center>ETA</th>--}}
{{--        <th data-center>ATA</th>--}}
        <th rowspan="2" data-center>FLT INFO</th>
{{--        <th rowspan="2" data-center>REMARKS</th>--}}
    </tr>

    <tr class="ops-header">
{{--        <th data-center>C</th>--}}
{{--        <th data-center>Y</th>--}}

        <th data-center>C</th>
        <th data-center>Y</th>
        <th data-center>INF</th>

        <th data-center>CODE</th>
        <th data-center>TIME</th>
    </tr>
    </thead>

    <tbody>

    @php $airlineICAO = env("ICAO") @endphp
    @if (isset($flightsOPS) && count($flightsOPS))

        @foreach($flightsOPS as $flight)
            @php $flightUrl = isset($flightDetails) ? url("flight-details/{$flight->id}") : url("flight-tracker/{$flight->id}") @endphp
            @php $aircraft = $flight->aircraft @endphp
            @php $aircraftType = $flight->aircraft && $flight->aircraft->type ? $flight->aircraft->type : $flight->aircraftType @endphp
            @php $flightNumber = $flight->flightNumber @endphp
            @php $airline = $flightNumber->airline @endphp

            @php $divertedFlight = $flight->divertedAirport @endphp
            @php $departureAirport = $flight->departureAirport ? $flight->departureAirport : $flightNumber->departureAirport @endphp
            @php $arrivalAirport = $flight->arrivalAirport ? $flight->arrivalAirport : $flightNumber->arrivalAirport @endphp

            @php $depDateTime = getFlightDepartureInitialDate($flight) @endphp
            @php $depDate = date("Y-m-d", strtotime($depDateTime)) @endphp

            @php $arrDateTime = getFlightArrivalInitialDate($flight) @endphp
            @php $arrDate = date("Y-m-d", strtotime($arrDateTime)) @endphp
            @php $picture = $airline && $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png") @endphp

            @php list($capC, $capY) = getFlightCapacity($flight) @endphp
            @php list($actC, $actY, $actInf) = getFlightActualPaxWithInf($flight) @endphp
            @php list($bkdC, $bkdY, $bkdInf) = getFlightBookedPaxWithInf($flight) @endphp

            @php list($delayCodes, $delayTimes) = getFlightDelays($flight, true) @endphp

            @php $ac = getFwTableAC($aircraft, $aircraftType) @endphp
            @php $acData = getFwTableAC($aircraft, $aircraftType, true) @endphp

            <tr data-id="{{ $flight->id }}" data-ac_id="{{ $aircraft ? $aircraft->id : 0 }}" data-ac_type_id="{{ $aircraftType ? $aircraftType->id : 0 }}" data-ac="{{ $acData }}" data-line="{{ $flight->line }}" class="ops-body {{ isset($selectedFlightId) && $selectedFlightId == $flight->id ? "selected" : "" }}">
                <td class="checkbox-column" style="display: none">
                    <input class="flight-checkbox" type="checkbox" name="" value="" />
                </td>
                <td>
                    <a target="_blank" href="{{ $flightUrl }}">{{ ($airline ? ($airline->iata ? $airline->iata : $airline->icao) : "")." ".$flightNumber->flight_number }}</a>
                </td>
{{--                <td data-center>@if ($flightNumber->cs){{ $airlineICAO.$flightNumber->cs }}@endif</td>--}}
                <td>
                    @if($divertedFlight)
                        <span class="color-red">"DIVERTED"</span><br>
                    @endif
                    @if($flight->remark)
                        <span class="color-red">{{ $flight->remark }}</span>
                    @endif
                </td>

                <td>{!! $ac !!}</td>

                <td data-center>
                    <span class="margin-right-5">{{ $departureAirport ? $departureAirport->iata : "-" }}</span>
                    <span class="color-green">{{ $departureAirport ? $departureAirport->icao : "-" }}</span>
                </td>

                <td data-center>{{ baseDateFormat($depDate, false, " ", true, false, "")." ".getFlightTimeComparedToBase($flight, STD, $depDate) }}</td>

                @php $depBadge = getFlightDepartureStatus($flight, $depDateTime, true) @endphp
                @php $depType = getFlightDepartureTimeType($flight, true) @endphp
                @php $dep = getFlightDepartureDate($flight, false, true) @endphp
                <td class="">
                    <span class='badge {{ $depBadge ? $depBadge : "badge-default" }} margin-right-5'>{{ $depType }}</span>{{ $dep }}
                </td>

{{--                <td>{{ getFlightTimeComparedToBase($flight, PTD, $depDate) }}</td>--}}
{{--                <td>{{ $etd = getFlightTimeComparedToBase($flight, ETD, $depDate) }}</td>--}}
{{--                <td class="status">--}}
{{--                    <span class="{{ getFlightDepartureStatus($flight, $depDateTime) }}"></span>--}}
{{--                    <span>{{ $atd = getFlightTimeComparedToBase($flight, ATD, $depDate) }}</span>--}}
{{--                </td>--}}

                @php $atd = getFlightTimeComparedToBase($flight, ATD, $depDate) @endphp
                @php $etd = getFlightTimeComparedToBase($flight, ETD, $depDate) @endphp


                @php $flightCom = $flight->flightCom @endphp
                <td data-center>{{ getFlightTimeComparedToBase($flight, ABN, $depDate) }}</td>
                <td data-center>{{ $flight->gate_parking }}</td>
                <td data-center>{{ $flight->gate_boarding }}</td>
                <td data-center>{{ $flightCom ? $flightCom->ckin_ctr : "" }}</td>
{{--                <td>{{ $capC }}</td>--}}
{{--                <td>{{ $capY }}</td>--}}

                @if ($actC || $actY)
                    <td class="color-green" data-center>{{ $actC }}</td>
                    <td class="color-green" data-center>{{ $actY }}</td>
                    <td class="color-green" data-center>{{ $actInf }}</td>
                @else
                    <td class="color-red" data-center>{{ $bkdC }}</td>
                    <td class="color-red" data-center>{{ $bkdY }}</td>
                    <td class="color-red" data-center>{{ $bkdInf }}</td>
                @endif

                <td data-center class="color-red">{{ $delayCodes }}</td>
                <td data-center class="color-red">{{ $delayTimes }}</td>

                <td data-center>
                    <span class="margin-right-5">{{ $arrivalAirport ? $arrivalAirport->iata : "-" }}</span>
                    <span class="color-green">{{ $arrivalAirport ? $arrivalAirport->icao : "-" }}</span>
                </td>

                <td data-center>{{ baseDateFormat($arrDate, false, " ", true, false, "")." ".getFlightTimeComparedToBase($flight, STA, $arrDate) }}</td>

{{--                <td data-center>{{ getFlightTimeComparedToBase($flight, TDN, $arrDate) }}</td>--}}

                @php $arrBadge = getFlightArrivalStatus($flight, $arrDateTime, true) @endphp
                @php $arrType = getFlightArrivalTimeType($flight, true) @endphp
                @php $arr =  getFlightArrivalDate($flight, false, true) @endphp
                <td class="">
                    <span class='badge {{ $arrBadge ? $arrBadge : "badge-default" }} margin-right-5'>{{ $arrType }}</span>{{ $arr }}
                </td>
{{--                <td>{{ getFlightTimeComparedToBase($flight, PTA, $arrDate) }}</td>--}}
{{--                <td>{{ $eta = getFlightTimeComparedToBase($flight, ETA, $arrDate) }}</td>--}}
                @php $eta = getFlightTimeComparedToBase($flight, ETA, $arrDate) @endphp
                @php $ata = getFlightTimeComparedToBase($flight, ATA, $arrDate) @endphp

{{--                    <span>{{ $ata = getFlightTimeComparedToBase($flight, ATA, $arrDate) }}</span>--}}

                <td><span>{{ getFlightStatusMessage($flight, $depDateTime, $eta, $ata, $etd, $atd) }}</span></td>
            </tr>
        @endforeach
    @endif
    </tbody>
</table>
