@if ($flightsOPS)
    <table class="table table-bordered table-hover table-striped ops-table" id="flightMessages">
        <thead>
        <tr class="ops-header">
            @if (env(CARRIER) == HANDLING)
                <th style="width: 50px; color: #ffffff; background-color: #1b63de;" data-center>@lang("content.AIRLINE")</th>
            @endif
            <th style="width: 90px !important; color: #ffffff; background-color: #1b63de;" data-center>@lang("content.FLT")</th>
            <th style="width: 90px !important;; color: #ffffff; background-color: #1b63de;" data-center>@lang("content.SECTOR")</th>
            <th style="width: 140px !important;; color: #ffffff; background-color: #1b63de;" data-center>@lang("content.DEP_TIME")</th>
            <th style="width: 140px !important;; color: #ffffff; background-color: #1b63de;" data-center>@lang("content.ARR_TIME")</th>
            <th style="color: #ffffff; background-color: #1b63de; min-width: 500px !important;">@lang("content.MESSAGES")</th>
        </tr>
        </thead>
        <tbody>

        @php $j = 0 @endphp

        @foreach($flightsOPS as $flight)

            @if (!$flight || !count($flight->message))
                @continue
            @endif

            @php $aircraft = $flight->aircraft @endphp
            @php $flightNumber = $flight->flightNumber @endphp
            @php $departureAirport   = $flightNumber ? $flight->flightNumber->departureAirport : null @endphp
            @php $arrivalAirport     = $flightNumber ? $flight->flightNumber->arrivalAirport : null @endphp
            @php $sector  = ($departureAirport    ? $departureAirport->iata  : "")."-" @endphp
            @php $sector .=  $arrivalAirport      ? $arrivalAirport->iata    : "" @endphp

            @php $airline = $flightNumber->airline @endphp
            @php $picture = $airline && $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png") @endphp

            @php $depTime = getFlightDepartureDate($flight) @endphp
            @php $depTimeType = getFlightDepartureTimeType($flight) @endphp

            @php $arrTime = getFlightArrivalDate($flight) @endphp
            @php $arrTimeType = getFlightArrivalTimeType($flight) @endphp

            <tr class="ops-body {{ isset($selectedFlightId) && $selectedFlightId == $flight->id ? "selected" : "" }}">
                @if (env(CARRIER) == HANDLING)
                    <td style="padding: 5px;" data-center>
                        <a target="_blank" href="{{ route("homepage")."#". url("/airline/{$airline->id}") }}" class="">
                            <img class='ops-airline-logo' src='{{ $picture }}'/>
                        </a>
                    </td>
                @endif

                <td style="padding: 5px;" data-center>
                    <a target="_blank" href="{{ url("flight-tracker/{$flight->id}") }}">
                        {{ ($flightNumber && $flightNumber->airline ? ($flightNumber->airline->iata ? $flightNumber->airline->iata : $flightNumber->airline->icao)."-" : "").($flightNumber ? $flightNumber->flight_number : "-") }}
                    </a>
                </td>
                <td style="padding: 5px;" data-center>{{ $sector }}</td>
                <td style="padding: 5px;" data-center>{!! departureArrivalTypeSpan($depTimeType, "left") . baseDateFormat($depTime, true) !!}</td>
                <td style="padding: 5px;" data-center>{!! departureArrivalTypeSpan($arrTimeType, "left") . baseDateFormat($arrTime, true) !!}</td>
                <td style="padding: 5px;" >{!! getFlightMessages($flight, 2, "") !!}</td>
            </tr>
        @endforeach
        </tbody>

    </table>
@endif
