<table class="table table-bordered table-hover table-striped" id="flightLogTable">
    <thead>
    <tr class="">
{{--       <th rowspan="2">No</th>--}}
       <th>Previous values</th>
       <th>New values</th>
       <th>Action from</th>
       <th>Date</th>
    </tr>
    </thead>
    <tbody>

    <tr>
        @if ($flight->created_by_email)
            <td>Auto created</td>
{{--            <td>{{ $flight->email_type ? "Auto created" : "Created from Manual Message Entry" }}</td>--}}
        @elseif ($flight->flight_schedule_id)
            <td>Flight Created by Schedule Upload </td>
        @else
            <td>Flight Created Manually</td>
        @endif

        <td></td>
        <td>{{ $flight->email_type ? $flight->email_type : getUserFullName($flight->created_by) }}</td>
        <td>{{ baseUSDateFormat($flight->created_at, true, "-", false, false, "m") }}</td>
    </tr>

    @php $ignoreData = [] @endphp
    @php $dataExists = false @endphp
    @if (isset($flightsAudit['flight']))
        @foreach($flightsAudit["flight"] as $i => $each)
        <tr>
            <td>
                @foreach($each->old_values as $prop => $val)
                    @if (array_key_exists($prop, $each->new_values) && $val == $each->new_values[$prop])
                        @php $ignoreData[] = $prop @endphp
                        @continue
                    @endif

                    @if ($prop == "aircraft_id")
                        AC: {{ getAircraftById($val) }} <br>
                    @else
                        <span class="">{!! getAuditProp($prop, true) !!}</span><span>{{ getAuditValue($prop, $val) }}</span><br>
                    @endif

                    @php $dataExists = true @endphp
                @endforeach
                {{ !$dataExists ? "-" : "" }}
            </td>

            <td>
                @php $dataExists = false @endphp
                @foreach($each->new_values as $prop => $val)
                    @if (in_array($prop, $ignoreData))
                        @continue
                    @elseif ($prop == "aircraft_id")
                        AC: {{ $val ? getAircraftById($val) : "Removed" }} <br>
                    @else
                        <span class="">{!!  getAuditProp($prop) !!}</span><span>{{ getAuditValue($prop, $val, true) }}</span><br>
                    @endif

                    @php $dataExists = true @endphp
                @endforeach

                {{ !$dataExists ? "-" : "" }}
            </td>
{{--            <td>{{ getUserFullName($each->user_id) }}</td>--}}
            <td>{{ getUserName($each->user) }}</td>

            {{--            <td>{{ isset($usersByID[$each->user_id]) ? getUserName($usersByID[$each->user_id]) : "" }}</td>--}}
            <td>{{ baseUSDateFormat($each->created_at, true, "-", false, false, "m") }}</td>
        </tr>
    @endforeach
    @endif

    @if (isset($flightsAudit['delays']))
        @foreach($flightsAudit["delays"] as $i => $each)
        @php $dlAdded = false @endphp
        <tr>
            <td>
                @if ($each->dl)
                    @php $dlAdded = true @endphp
                    DL {{ $each->dl->code." | ". $each->dl->description }} <br>
                @endif

                @forelse($each->old_values as $prop => $val)
                    @if (!in_array($prop, ["position", "duration"]))
                        @continue
                    @endif
                    <span class="">{!! getAuditProp($prop) !!}</span><span>{{ $val }}</span><br>
                @empty
                    <p>Created</p>
                @endforelse
            </td>
            <td>
                @if (!$dlAdded && $each->dl)
                    DL {{ $each->dl->code." | ". $each->dl->description }}
                @endif
                    <br>
                @forelse($each->new_values as $prop => $val)
                    @if (!in_array($prop, ["position", "duration"]))
                        @continue
                    @endif
                    <span class="">{!! getAuditProp($prop) !!}</span><span>{{ $val }}</span><br>
                @empty
                    <p>Removed</p>
                @endforelse
            </td>
            <td>{{ getUserName($each->user) }}</td>
{{--            <td>{{ isset($usersByID[$each->user_id]) ? getUserName($usersByID[$each->user_id]) : "" }}</td>--}}
            <td>{{ baseUSDateFormat($each->created_at, true, "-", false, false, "m") }}</td>
        </tr>
    @endforeach
    @endif
    </tbody>

</table>
