@php $selectedAirline = isset($selectedAirline) ? $selectedAirline : \request("airline") @endphp
@php $selectedAirport = isset($selectedAirport) ? $selectedAirport : \request("airport") @endphp

{!! Form::open(['class' => 'form-inline', 'method' => 'GET', 'url' => url("flight-tracker"),  'id' => 'formSearch' ]) !!}

    <div class="col-lg-12">
        @if (env(MULTIPLE_AIRLINE))
            <div class="form-group marginBottomRight">
                <label>@lang("content.airline")</label>

                <div class="btn-group">
                    {!! Form::select('airline[]', $airlines, $selectedAirline, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
                </div>
            </div>
        @endif

        <div class="form-group marginBottomRight">
            <label>@lang("content.airport")</label>

            <div class="btn-group">
                {!! Form::select('airport[]', $airports, $selectedAirport, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']) !!}
            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label>@lang("content.flight_number")</label>

            <div class="btn-group">
                @if (is_array($flightNumbers))
                    {!! Form::select('flightNumber[]', $flightNumbers, \request("flightNumber"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'flight_number']) !!}
                @else
                    <select name="flightNumber[]" class="multiselect_search" id="flight_number" multiple>
                        @foreach($flightNumbers as $each)
                            <option value="{{ $each->id }}" {!! \request("flightNumber") && in_array($each->id, \request("flightNumber")) ? "selected" : "" !!} data-airline_id ="{{ $each->airline_id }}">{{ $each->sector }}</option>
                        @endforeach
                    </select>
                @endif
            </div>
        </div>

        <div class="form-group marginLeftRightBottom">
            <label>@lang("content.from")</label>
                {!! Form::text('dateFrom', $dateFrom, ['class'=>'form-control dateFrom myinput', 'placeholder'=>'From Date', 'id'=>'from_date']) !!}
            <label>@lang("content.to")</label>
                {!! Form::text('dateTo', $dateTo, ['class'=>'form-control dateTo myinput', 'placeholder' => 'To Date', 'id'=>'to_date']) !!}
        </div>


        <div class="form-group marginBottomRight">
            <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
        </div>
    </div>

{!! Form::close() !!}
