@php $type = "ALL" @endphp
<div class="col-md-12 margin-bottom-10">
    {!! Form::open(["method" => "GET", "url" => url("flight-staff"), "class" => "form-inline"]) !!}
        <div class="form-group">
            <label>@lang("content.airline")</label>
            <div class="btn-group">
                {!! Form::select('airline[]', $airlines, \request("airline"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
            </div>
        </div>

        <div class="form-group">
            <label>@lang("content.airport")</label>
            <div class="btn-group">
                {!! Form::select('airport[]', $airports, \request("airport"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']) !!}
            </div>
        </div>
{{--        {!! Form::label('from', trans("content.from") ) !!}--}}
{{--        {!! Form::text('from', \request("from") ? \request("from") : date("Y-m-d"), ['class' => 'form-control dateFrom inputDateSmall']) !!}--}}
{{--        {!! Form::label('to', trans("content.to") ) !!}--}}
{{--        {!! Form::text('to', \request("to") ? \request("to") : date("Y-m-d"), ['class' => 'form-control dateTo inputDateSmall']) !!}--}}
        {!! Form::submit("Submit", ["class" => "btn btn-primary btn-sm"]) !!}
    {!! Form::close() !!}
</div>

<div class="clearfix"></div>

@if (!count($flights))
    <div class="alert alert-info">
        @if (\request("type") && \request("type") == $type)
            @lang("content.found") 0 @lang("content.records")
        @else
            @lang("content.please_select_period_and_press_submit")
        @endif
    </div>
@else
    <div class="jarviswidget jarviswidget-color-blueDark" id="{{ $type }}_container" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important; ">

            <div class="table-responsive">

                <table class="table table-bordered table-hover">
                    <thead>
                    <tr>
                        <th rowspan="2">No</th>
                        @if ($sprAdm)
                            <th rowspan="2">@lang("content.actions")</th>
                        @endif

                        <th rowspan="2" style="min-width: 50px;">@lang("content.flight")</th>
                        <th rowspan="2">DEP</th>
                        <th rowspan="2">ARR</th>
                        <th rowspan="2">@lang("content.aircraft")</th>

                        <th colspan="2" data-center>@lang("content.departure_time")</th>
                        <th colspan="2" data-center>@lang("content.arrival_time")</th>
                    </tr>
                    <tr>
{{--                        <th style="min-width: 90px;">STD</th>--}}
                        <th style="min-width: 90px;">PTD</th>
{{--                        <th style="min-width: 90px;">ETD</th>--}}
                        <th style="min-width: 90px;">ATD</th>
{{--                        <th style="min-width: 90px;">ABN</th>--}}

{{--                        <th style="min-width: 90px;">STA</th>--}}
                        <th style="min-width: 90px;">PTA</th>
{{--                        <th style="min-width: 90px;">ETA</th>--}}
{{--                        <th style="min-width: 90px;">TDN</th>--}}
                        <th style="min-width: 90px;">ATA</th>

                    </tr>
                    </thead>
                    <tbody>
                    @foreach($flights as $j => $each)
                        @php $aircraft = $each->aircraft @endphp
                        @php $flightNumber = $each->flightNumber @endphp
                        @php $notes = $each->remark @endphp

                        <tr>
                            <td>{{ $j + 1 }}</td>
                            <td data-center>
                                <div class="btn-group">
                                    <a target="_blank" href="{{ route("homepage")."#".url("flight-staff/$each->id/create?s=".rand(100, 999)) }}" class="btn btn-success">@lang("content.select")</a>
                                </div>
                            </td>
                            <td><a target="_blank" href="{{ url("flight-tracker/{$each->id}") }}">{{ getFlightNumberFull($flightNumber) }}</a></td>
                            <td>{{ getFlightDepartureAirport($each, false, true) }}</td>
                            <td>{{ getFlightArrivalAirport($each, false, true) }}</td>
                            <td>{{ $aircraft ? $aircraft->name : "-" }}</td>

{{--                            <td data-center>{!! $each->std && $each->std != EMPTY_DATETIME ? baseDateFormat($each->std, true, "/") : "<i class='fa fa-remove color-red'></i>" !!}</td>--}}
                            <td data-center>{!! $each->ptd && $each->ptd != EMPTY_DATETIME ? baseDateFormat($each->ptd, true, "/") : "<i class='fa fa-remove color-red'></i>" !!}</td>
{{--                            <td data-center>{!! $each->etd && $each->etd != EMPTY_DATETIME ? baseDateFormat($each->etd, true, "/") : "<i class='fa fa-remove color-red'></i>" !!}</td>--}}
{{--                            <td data-center>{!! $each->atd && $each->atd != EMPTY_DATETIME ? baseDateFormat($each->atd, true, "/") : "<i class='fa fa-remove color-red'></i>" !!}</td>--}}
                            <td data-center>{!! $each->abn && $each->abn != EMPTY_DATETIME ? baseDateFormat($each->abn, true, "/") : "<i class='fa fa-remove color-red'></i>" !!}</td>

{{--                            <td data-center>{!! $each->sta && $each->sta != EMPTY_DATETIME ? baseDateFormat($each->sta, true, "/") : "<i class='fa fa-remove color-red'></i>" !!}</td>--}}
                            <td data-center>{!! $each->pta && $each->pta != EMPTY_DATETIME ? baseDateFormat($each->pta, true, "/") : "<i class='fa fa-remove color-red'></i>" !!}</td>
{{--                            <td data-center>{!! $each->eta && $each->eta != EMPTY_DATETIME ? baseDateFormat($each->eta, true, "/") : "<i class='fa fa-remove color-red'></i>" !!}</td>--}}
{{--                            <td data-center>{!! $each->tdn && $each->tdn != EMPTY_DATETIME ? baseDateFormat($each->tdn, true, "/") : "<i class='fa fa-remove color-red'></i>" !!}</td>--}}
                            <td data-center>{!! $each->ata && $each->ata != EMPTY_DATETIME ? baseDateFormat($each->ata, true, "/") : "<i class='fa fa-remove color-red'></i>" !!}</td>
                        </tr>
                    @endforeach
                    </tbody>

                </table>

            </div>
        </div>

    </div>

</div>
@endif