<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => trans("content.flight")." | ".trans("content.edit")])

            <div class="col-sm-12">
                    @if ($errors->all())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{!! $error !!}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                <div class="col-sm-12">
                    <h2>{{ getFlightNumberFull($flight->flightNumber)." | ". baseDateFormat(getFlightDepartureInitialDate($flight, true)) }}</h2>
                </div>

                <div class="col-sm-12">
                    <div class="col-sm-3">
                        <h5>PTD: {{ $flight->ptd }}</h5>
                    </div>

                    <div class="col-sm-3">
                        <h5>ATD: {{ $flight->atd }}</h5>
                    </div>

                    <div class="col-sm-3">
                        <h5>PTA: {{ $flight->pta }}</h5>
                    </div>

                    <div class="col-sm-3">
                        <h5>ATA: {{ $flight->ata }}</h5>
                    </div>
                </div>


                    {!! Form::open(['method' => 'POST', "url" => url("flight/{$flight->id}"), 'class' => 'form-horizontal']) !!}



                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">@lang("content.save_changes")</button>
                        </div>

                    {!! Form::close() !!}
                </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#aircraft-table");
    };

    $(document).find(".dtpicker").datetimepicker({
        format: "Y-m-d H:i",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        step: 1
    });

    pagefunction();

</script>
