<?php

//initilize the page
require_once(public_path("smart/inc/init.php"));

//require UI configuration (nav, ribbon, etc.)
require_once(public_path("smart/inc/config.ui.php"));


include(public_path("smart/inc/user_modules.php"));
/*---------------- PHP Custom Scripts ---------

YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
E.G. $page_title = "Custom Title" */

$page_title = "Flight Schedule";

/* ---------------- END PHP Custom Scripts ------------- */

//include header
//you can add your custom css in $page_css array.
//Note: all css files are inside css/ folder
$page_css[] = "your_style.css";

$no_main_header = true;

$page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

include(public_path("smart/inc/header.php"));


$weeks = [];
$years = getYearsArray(2017, (int)date('Y') + 1);
$day_of_week = getWeekdaysArray(false, 1);// ['' => 'Select Day', '1' => 'Monday', '2' => 'Thursday', '3' => 'Wednesday', '4' => 'Thursday', '5' => 'Friday', '6' => 'Saturday', '7' => 'Sunday'];
$frequency =  ['weekly' => 'Weekly', 'once_in_2_weeks' => 'Once in 2 weeks', 'once_in_3_weeks' => 'Once in 3 weeks', 'once_in_4_weeks' => 'Once in 4 weeks'];
$starting_week = ['first_week' => 'First week', 'second_week' => 'Second week', 'third_week' => 'Third week', 'fourth_week' => 'Fourth week'];

for ($i = 1; $i <= 53; $i++) {
    $weeks[$i] = $i;
}

$current_week = date("W");
$current_year = date("Y");
if (\request()->get("week")) {
    $current_week = \request()->get("week");
}
if (\request()->get("year")) {
    $current_year = \request()->get("year");
}

$json = [];
if (isset($flights) && count($flights)) {
    $json = $flights;
}
$json = json_encode($json);
debug($json);

?>

<style type="text/css">
    #add-flight .form-group {
        margin-left: 15px
    }

    .form-group label {
        font-weight: bold
    }
</style>

<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->
<header id="header">
    <!--<span id="logo"></span>-->

    <div id="logo-group">
        <span id="logo"> <img  style="width: 200px" src="<?php echo ASSETS_URL; ?>/img/logo.png" alt="Aviation-BIS"> </span>

        <!-- END AJAX-DROPDOWN -->
    </div>

    <!--<span id="extr-page-header-space"> <span class="hidden-mobile hiddex-xs">Need an account?</span> <a href="<?php //	echo APP_URL; ?>/register.php" class="btn btn-danger">Creat account</a> </span>-->

</header>

<div id="main" role="main">

    <!-- MAIN CONTENT -->
    <div id="content" class="">

        @include('general.tab-header')

        <div>

            <span id="loading" style="display: none"><img src="{!!route("homepage")."#". url("/")!!}/assets/img/2.GIF" alt="loading..."></span>

            <div class="row">
                <div class="col-sm-12">
                    @if ($errors->all())
                        <div class="alert alert-danger">
                            <button type="button" class="close" data-dismiss="alert"><span
                                    aria-hidden="true">&times;</span><span
                                    class="sr-only">Close</span></button>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{!! $error !!}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-sm-7">
                            <fieldset>
                                <legend>Load Flights to Timeline</legend>
                            </fieldset>
                            {!! Form::open(['method' => "GET", "class" => "form-inline"]) !!}
                            <div class="form-group">
                                <label for="source">Load From</label>
                                {!! Form::select("source", ["fleetwatch" => "Fleet Watch", "template" => "Template", "SSIM" => "SSIM"], \request()->get("source"), ["id" => "source", "class" => "input-sm form-control"]) !!}
                            </div>
                            <div id="fleet-watch-load-form" class="form-group" style="{!! (\request()->get(" source
                    ") == "template") ? "display:none" : "" !!}">
                                <div class="form-group" style="margin-left: 25px">
                                    <label for="load_type_from_to">
                                        {!! Form::radio("load_date", "from_to", (\request()->get("load_date") == "from_to"), ["id" => "load_type_from_to"]) !!}
                                    </label>
                                    <label for="from">@lang("content.from")</label>
                                    {!! Form::text('from', \request()->get("from"), ['class'=>'form-control input-sm datetimepicker inputDateSmall', 'placeholder'=>'From Date', 'id'=>'from']) !!}
                                </div>
                                <div class="form-group">
                                    <label for="to">@lang("content.to")</label>
                                    {!! Form::text('to', \request()->get("to"), ['class'=>'form-control input-sm datetimepicker inputDateSmall', 'id'=>'to', 'placeholder' => 'To Date']) !!}
                                </div>
                                <div class="form-group" style="margin-left: 25px">
                                    <label for="load_type_week">
                                        {!! Form::radio("load_date", "week", (\request()->get("load_date") == "week"), ["id"=>"load_type_week"]) !!}
                                    </label>
                                    <label for="week">Week</label>
                                    {!! Form::select('week', $weeks, $current_week, ['class'=>'form-control input-sm', 'id'=>'week']) !!}
                                    {!! Form::select('year', $years, getSelectedYear(), ['class'=>'form-control input-sm', 'id'=>'year']) !!}
                                </div>
                            </div>
                            <div class="form-group" id="template-load-form" style="{!! (\request()->get("source") == "template") ? "" : "display:none" !!}">
                                <div class="form-group" style="margin-left: 50px">
                                    <label for="template_id">Select Template</label>
                                    {!! Form::select('template_id', $templates, \request()->get("template_id"), ['class'=>'form-control input-sm', 'id'=>'template_id']) !!}
                                </div>
                            </div>
                            <div id="open-ssim-popup" class="btn-group" style="{!! (\request()->get("source") == "ssim") ? "" : "display:none" !!}">
                                <button id="open-ssim-popup-btn" type="button" class="btn btn-sm btn-primary">Open SSIM</button>
                            </div>
                            <div class="btn-group" id="load-buttons">
                                <button type="submit" class="btn btn-sm btn-primary">Load</button>
                                @if (\request()->has("template_id") && \request()->get("template_id") && \request()->get("source") == "template")
                                    <input type="hidden" name="loaded_template_id" id="loaded_template_id" value="{!! $template_id !!}"/>
                                    <button type="button" id="update-current-template-btn" class="btn btn-sm btn-info">Update Current Template</button>
                                    <button type="button" id="delete-current-template-btn" class="btn btn-sm btn-danger">Remove Template</button>
                                @endif
                            </div>
                            {!! Form::close() !!}
                        </div>
                        @if (isset($flights) && count($flights))
                            <div class="col-sm-5">
                                <fieldset>
                                    <legend>Upload to Fleetwatch</legend>
                                </fieldset>
                                {!! Form::open(['method' => "POST", "class" => "form-inline", "url" => url("/flightschedule/upload-to-fleetwatch"), "id" => "upload-to-fleetwatch-form"]) !!}
                                <div class="form-group">
                                    <label for="upload_week_from">@lang("content.from")</label>
                                    {!! Form::select('upload_week_from', $weeks, $current_week, ['class'=>'form-control input-sm', 'id'=>'upload_week_from']) !!}
                                    {!! Form::select('upload_year_from', $years, $current_year, ['class'=>'form-control input-sm', 'id'=>'upload_year_from']) !!}
                                    <label style="margin-left: 50px" for="upload_week_to">@lang("content.to")</label>
                                    {!! Form::select('upload_week_to', $weeks, $current_week, ['class'=>'form-control input-sm','id'=>'upload_week_to']) !!}
                                    {!! Form::select('upload_year_to', $years, $current_year, ['class'=>'form-control input-sm', 'id'=>'upload_year_to']) !!}
                                </div>
                                <div class="btn-group">
                                    <input type="hidden" name="upload_data" id="upload_data" value="week"/>
                                    <input type="hidden" name="fleetwatch_data" id="fleetwatch_data" value=""/>
                                    <button type="submit" id="upload-data-to-fleetwatch-btn" class="btn btn-sm btn-primary">Upload</button>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        @endif
                    </div>
                    <hr/>
                </div>
            </div>
            <div id="message-block"></div>
            <div id="fleetwatch_message_block">
                @if (isset($flights) && count($flights) == 0)
                    <div class="alert-warning alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                        <h4>Information!</h4>

                        <p>Not found any flights in selected dates</p>
                    </div>
                @endif
            </div>
            <!-- Fleet watch timeline -->
            <div id="mytimeline" style="min-height: 200px"></div>

            <!-- Form template saving -->

            <br/>
            <div class="row">
                @if (isset($flights) && count($flights))
                    <div class="col-sm-3">
                        <fieldset>
                            <legend>Save flights as template</legend>
                            {!! Form::open(['method' => "POST", "class" => "form-inline", "url" => url("/flightschedule/save-as-template"), "id" => "save-template-form"]) !!}
                            <div class="form-group">
                                <label>Save flights as template</label>
                                {!! Form::input("text", "template_name", null, ["class"=>"input-sm form-control", "autocomplete"=>"off", "required" => "required", "id"=>"template_name"]) !!}
                            </div>
                            <input type="hidden" value="" name="template_data" id="template_data"/>
                            <input type="hidden" value="{!! isset($from) ? $from : false !!}" name="from"/>
                            <input type="hidden" value="{!! isset($to) ? $to : false !!}" name="to"/>
                            <button type="button" id="save-as-template-btn" class="btn btn-primary btn-sm">Save</button>
                            {!! Form::close() !!}
                        </fieldset>
                    </div>
                    <div class="col-sm-9">
                        <fieldset>
                            <legend id="add-flight-legend">@lang("content.add") @lang("content.flight")</legend>
                            <div id="add-flight-message"></div>
                            <form method="post" action="" class="form-inline" id="add-flight">
                                <div class="col-sm-12" style="margin-bottom: 15px;">
                                    <div class="form-group">
                                        <label class="control-label" for="aircraft_id">@lang("content.aircraft")</label>
                                        {!! Form::select("aircraft_id", $aircraft, null, ["class"=>"form-control input-sm add-flight-field", "id"=>"aircraft_id"]) !!}
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label" for="flight_number_id">@lang("content.flight_number")</label>
                                        {!! Form::select("flight_number_id", $flightNumbers, null, ["class"=>"form-control input-sm add-flight-field", "id"=>"flight_number_id", 'style' => 'width:120px']) !!}
                                    </div>
                                    <div class="form-group">
                                        {!! Form::label('inbound', "Inbound Flight") !!}
                                        {!! Form::checkbox('inbound',1, null, ['id' => 'inbound']) !!}
                                    </div>
                                    <div class="form-group" style="display: none;">
                                        <label class="control-label">Parent Flight</label>
                                        {!! Form::select("parent_flight_id", ["" => "Select Parent Flight"], null, ["class" => "form-control input-sm", "id" => "parent_flight_id"]) !!}
                                        {!! Form::button('Search', ['class' => 'btn btn-primary', 'id' => 'searchParentFlight']) !!}
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label" for="">STD</label>
                                        {!! Form::input("text", "std", "", ["class"=>"form-control input-sm dateTimeFrom add-flight-field", "id"=>"std"]) !!}
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label" for="">STA</label>
                                        {!! Form::input("text", "sta", "", ["class"=>"form-control input-sm dateTimeTo", "id"=>"sta"]) !!}
                                    </div>

                                </div>
                                <div class="col-sm-12 marginRightBottom">

                                    <div class="form-group">
                                        <label class="control-label" for="frequency">@lang("content.frequency")</label>
                                        {!! Form::select("frequency", $frequency, null, ["class"=>"form-control input-sm", "id"=>"frequency"]) !!}
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label" for="starting_week">Starting</label>
                                        {!! Form::select("starting_week", $starting_week, null, ["class"=>"form-control input-sm", "id"=>"starting_week"]) !!}
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label" for="day_of_week">Day</label>
                                        {!! Form::select("day_of_week", $day_of_week, null, ["class"=>"form-control input-sm add-flight-field", "id"=>"day_of_week", 'disabled' => 'disabled']) !!}
                                    </div>
                                    <input type="hidden" value="" name="selected-flight-id" id="selected-flight-id">
                                    <button type="button" id="add-new-flight-btn" class="btn btn-primary btn-sm">Add Flight</button>
                                    <button type="button" id="update-flight-btn" style="display: none" class="btn btn-primary btn-sm">Update Flight</button>
                                    <button type="button" id="reset-flight-btn" style="display: none" class="btn btn-info btn-sm">Cancel Edit</button>
                                </div>
                            </form>
                        </fieldset>
                    </div>
                @endif
            </div>
            <hr/>

            <div class="modal fade" id="ssim_modal">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span
                                    class="sr-only">Close</span></button>
                            <h4 class="modal-title">Load SSIM</h4>
                        </div>
                        <div class="modal-body">
                            <form class="form-horizontal" style="padding: 0 30px; overflow: auto">
                                <div class="form-group">
                                    <label for="ssim-message">SSIM Message</label>
                                    <textarea class="form-control" name="ssim-message" id="ssim-message" rows="10"
                                              style="font-size: 12px; max-width: 805px"></textarea>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" id="load-ssim-btn" class="btn btn-primary">Load</button>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div><!-- /.modal -->
        </div>


    </div>

</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<?php
//include required scripts
include(public_path("smart/inc/scripts.php"));
?>

    <!-- PAGE RELATED PLUGIN(S)
<script src="..."></script>-->

<script type="text/javascript">
    var from = '{{ isset($from) ? date('D M d Y H:i:s O', strtotime($from)) : false }}',
        to = '{{ isset($to) ? date('D M d Y H:i:s O', strtotime($to)) : false }}',
        json = {!! $json !!},
        aircraft = {!! json_encode($aircraft) !!},
        flightNumbers = {!! json_encode($flightNumbers) !!};
    console.log(json)
</script>

<!-- Styles -->
<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline.css") }}"/>
<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline-theme.css") }}"/>
<!-- Scripts -->
{{--<script src = "{{ asset("/assets/js/vendor//google-jsapi.js") }}" ></script>--}}
<script type="text/javascript" src="http://www.google.com/jsapi"></script>
<script src = "{{ asset("/assets/timeline/timeline.js") }}" ></script>
<script src = "{{ asset("/assets/js/views/flightschedule/timeline.js") }}" ></script>
<script src = "{{ asset("/assets/js/views/flightschedule/index.js") }}" ></script>

<script type="text/javascript">
    runAllForms();
</script>

<?php
//include footer
include(public_path("smart/inc/google-analytics.php"));
?>
