<div class="tab-pane" id="removed" style="padding: 0; margin: 0;">
    @if (count($modelVariableRemoved['pagination']) == 0)
        <div class="alert alert-info">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <p>No Data Found</p>
        </div>
    @else

        <table class="tableFilters tablePagination">
            <thead>
            <tr>
                <th>No</th>
                <th>Flight Type</th>
                <th>Airport From</th>
                <th>Airport To</th>
                <th>@lang("content.duration") (min)</th>
                <th>Distance (km)</th>
                <th>@lang("content.actions")</th>
            </tr>
            <tr>
            </thead>
            <tbody>
            @foreach($modelVariableRemoved['pagination'] as $j => $each)
                @if ($j >= ($currentPage - 1) * $perPage && $j < ($currentPage - 1) * $perPage + $perPage)
                    <tr>
                        <td>{{ $j + 1 }}</td>
                        <td>{{ $each->flightType ? $each->flightType->type : "" }}</td>
                        <td>{{ $each->fromAirport ? $each->fromAirport->iata : "" }}</td>
                        <td>{{ $each->toAirport ? $each->toAirport->iata : "" }}</td>
                        <td>{{ $each->duration }}</td>
                        <td>{{ $each->distance }}</td>
                        <td>
                            {!! Form::open([ 'method' => 'POST', 'class' => 'inline', 'url' => url("/flight-route/restore/".$each->id) ]) !!}
                                {!! Form::submit("Restore", ['class' => 'btn btn-primary btn-sm']) !!}
                            {!! Form::close() !!}
                        </td>
                    </tr>
                @endif
            @endforeach
            </tbody>
        </table>

        <!-- pager -->
        @include('general.pager')

        {!! $modelVariableRemoved['pagination']->appends(request()->all())->render() !!}

    @endif
</div>