<div class="tab-pane active" id="all" style="padding: 0; margin: 0;">
    <div class="col-md-12" style="padding: 0; margin: 10px 0">
        <a href="{{ url("/flight-route/create?s=".rand(100, 999)) }}" class="btn btn-success">@lang("content.add")</a>
    </div>

    <table class="tableFilters tablePagination">
        <thead>
        <tr>
            <th>No</th>
            <th>Flight Type</th>
            <th>Airport From</th>
            <th>Airport To</th>
            <th>@lang("content.duration") (min)</th>
            <th>Distance (km)</th>
            <th>@lang("content.actions")</th>
        </tr>
        <tr>
        </thead>
        <tbody>
        @foreach($modelVariable['pagination'] as $j => $each)
            @if ($j >= ($currentPage - 1) * $perPage && $j < ($currentPage - 1) * $perPage + $perPage)
                <tr>
                    <td>{{ $j + 1 }}</td>
                    <td>{{ $each->flightType ? $each->flightType->type : "" }}</td>
                    <td>{{ $each->fromAirport ? $each->fromAirport->iata : "" }}</td>
                    <td>{{ $each->toAirport ? $each->toAirport->iata : "" }}</td>
                    <td>{{ $each->duration }}</td>
                    <td>{{ $each->distance }}</td>
                    <td>
                        <a target="_blank" href="{{ url("/flight-route/{$each->id}/edit?s=".rand(100, 999)."&page={$currentPage}") }}" class="btn btn-warning btn-sm">@lang("content.edit")</a>
                        {!! Form::open([ 'method' => 'DELETE', 'class' => 'inline', 'url' => url("/flight-route/".$each->id) ]) !!}
                        {!! Form::submit("Remove", ['class' => 'btn btn-danger btn-sm']) !!}
                        {!! Form::close() !!}
                    </td>
                </tr>
            @endif
        @endforeach
        </tbody>
    </table>

    <!-- pager -->
    @include('general.pager')

    {!! $modelVariable['pagination']->appends(request()->all())->render() !!}

</div>