@extends("layout")


@section("content")

    @include('general.tab-header', ['departmentName' => 'Flight Routes', 'moduleName' => 'Edit'])

    <div class="col-lg-12">
        {!! Form::open([ 'method' => 'POST', 'class' => '', 'url' => url("/flight-route/{$modelVariable->id}?page={$currentPage}") ]) !!}
        <table class="table">
            <thead>
            </thead>
            <tbody>
                <tr>
                    <td class="td_header vertical-center">Flight Type<span class="required-info">*</span></td>
                    <td>{!! Form::select('flight_type', $flightTypes, $modelVariable->flight_type_id, ['class' => 'form-control', 'required' => 'required']) !!}</td>
                    <td></td>
                </tr>
                <tr>
                    <td class="td_header vertical-center">Airport From<span class="required-info">*</span></td>
                    <td>{!! Form::select('from_airport', $airports, $modelVariable->from_airport_id, ['class' => 'form-control', 'required' => 'required']) !!}</td>
                    <td></td>
                </tr>
                <tr>
                    <td class="td_header vertical-center">Airport To<span class="required-info">*</span></td>
                    <td>{!! Form::select('to_airport', $airports, $modelVariable->to_airport_id, ['class' => 'form-control', 'required' => 'required']) !!}</td>
                    <td></td>
                </tr>
                <tr>
                    <td class="td_header vertical-center">@lang("content.duration") (mins)</td>
                    <td>{!! Form::text('duration', $modelVariable->duration, ['class' => 'form-control']) !!}</td>
                    <td></td>
                </tr>
                <tr>
                    <td class="td_header vertical-center">Distance (km)</td>
                    <td>{!! Form::text('distance', $modelVariable->distance, ['class' => 'form-control']) !!}</td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="3">{!! Form::submit("Submit", ['class' => 'btn btn-success btn-sm']) !!}</td>
                </tr>
            </tbody>
        </table>
        {!! Form::close() !!}

    </div>
@stop

@section("js_scripts")

@stop