@extends("layout")

@section("content")

    @include('general.tab-header', ['departmentName' => 'Flight Routes', 'moduleName' => trans("content.add")])

    <div class="col-lg-12">
        {!! Form::open([ 'method' => 'POST', 'class' => '', 'url' => url("/flight-route") ]) !!}
        <table class="table">
            <thead>
            </thead>
            <tbody>
                <tr>
                    <td class="td_header vertical-center">Flight Type<span class="required-info">*</span></td>
                    <td>{!! Form::select('flight_type', $flightTypes, null, ['class' => 'form-control', 'required' => 'required']) !!}</td>
                    <td></td>
                </tr>
                <tr>
                    <td class="td_header vertical-center">Airport From<span class="required-info">*</span></td>
                    <td>{!! Form::select('from_airport', $airports, null, ['class' => 'form-control', 'required' => 'required']) !!}</td>
                    <td></td>
                </tr>
                <tr>
                    <td class="td_header vertical-center">Airport To<span class="required-info">*</span></td>
                    <td>{!! Form::select('to_airport', $airports, null, ['class' => 'form-control', 'required' => 'required']) !!}</td>
                    <td></td>
                </tr>
                <tr>
                    <td class="td_header vertical-center">@lang("content.duration") (mins)</td>
                    <td>{!! Form::text('duration', null, ['class' => 'form-control']) !!}</td>
                    <td></td>
                </tr>
                <tr>
                    <td class="td_header vertical-center">Distance (km)</td>
                    <td>{!! Form::text('distance',null, ['class' => 'form-control']) !!}</td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="3">{!! Form::submit("Add", ['class' => 'btn btn-success btn-sm']) !!}</td>
                </tr>
            </tbody>
        </table>
        {!! Form::close() !!}

    </div>
@stop

@section("js_scripts")

@stop