<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

            <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-lg-12">

                <div class="col-md-12 no-padding margin-bottom-10">
                    <a href="{{ route("homepage")."#". url("flight-number/{$flight_number->id}/delete") }}" class="btn btn-primary">@lang("content.delete") @lang("content.flight_number")</a>
                </div>

                <div class="col-md-12 no-padding margin-bottom-10">
                    <h4>@lang("content.found"): {{ count($flights) }}.</h4>
                </div>

                <div class="clearfix"></div>

                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-online" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                        <h2>@lang("content.airlines")</h2>
                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->

                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body no-padding" style="min-height: 50px !important; ">

                            <div class="table-responsive">

                                <table class="table table-bordered table-hover" id="table-flights">
                                    <thead>
                                        <tr>
                                            <th rowspan="2">No</th>
                                            <th rowspan="2">@lang("content.flight")</th>
                                            <th rowspan="2">@lang("content.aircraft")</th>
                                            <th rowspan="2" style="min-width: 130px;">@lang("content.departure")</th>
                                            <th rowspan="2" style="min-width: 130px;">@lang("content.arrival")</th>
                                            <th rowspan="2" style="min-width: 130px;">@lang("content.messages")</th>

                                            <th colspan="3">PAX BKD</th>
                                            <th colspan="3">PAX ACT</th>

                                        </tr>
                                        <tr>
                                            <th>C</th>
                                            <th>Y</th>
                                            <th>INF</th>

                                            <th>C</th>
                                            <th>Y</th>
                                            <th>INF</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($flights as $j => $each)
                                        <tr>
                                            <td>{{ $j + 1 }}</td>
                                            <td><a target="_blank" href="{{ url("flight-tracker/{$each->id}") }}">{{ ($flight_number->airline ? $flight_number->airline->iata."-" : "").$flight_number->flight_number }}</a></td>
                                            <td>{{ $each->aircraft ? $each->aircraft->name : "-" }}</td>
                                            <td>
                                                {!! $each->std && $each->std != EMPTY_DATETIME ? "<p><strong>STD:</strong> ".baseDateFormat($each->std, true, "/")."</p>" : "" !!}
                                                {!! $each->ptd && $each->ptd != EMPTY_DATETIME ? "<p><strong>PTD:</strong> ".baseDateFormat($each->ptd, true, "/")."</p>" : "" !!}
                                                {!! $each->etd && $each->etd != EMPTY_DATETIME ? "<p><strong>ETD:</strong> ".baseDateFormat($each->etd, true, "/")."</p>" : "" !!}
                                                {!! $each->atd && $each->atd != EMPTY_DATETIME ? "<p><strong>ATD:</strong> ".baseDateFormat($each->atd, true, "/")."</p>" : "" !!}
                                                {!! $each->abn && $each->abn != EMPTY_DATETIME ? "<p><strong>ABN:</strong> ".baseDateFormat($each->abn, true, "/")."</p>" : "" !!}
                                            </td>

                                            <td>
                                                {!! $each->sta && $each->sta != EMPTY_DATETIME ? "<p><strong>STA:</strong> ".baseDateFormat($each->sta, true, "/")."</p>" : "" !!}
                                                {!! $each->pta && $each->pta != EMPTY_DATETIME ? "<p><strong>PTA:</strong> ".baseDateFormat($each->pta, true, "/")."</p>" : "" !!}
                                                {!! $each->eta && $each->eta != EMPTY_DATETIME ? "<p><strong>ETA:</strong> ".baseDateFormat($each->eta, true, "/")."</p>" : "" !!}
                                                {!! $each->tdn && $each->tdn != EMPTY_DATETIME ? "<p><strong>TDN:</strong> ".baseDateFormat($each->tdn, true, "/")."</p>" : "" !!}
                                                {!! $each->ata && $each->ata != EMPTY_DATETIME ? "<p><strong>ATA:</strong> ".baseDateFormat($each->ata, true, "/")."</p>" : "" !!}
                                            </td>
                                            <td>{!! getFlightMessages($each) !!}</td>
                                            <td>{{ $each->pax_c_booked }}</td>
                                            <td>{{ $each->pax_y_booked }}</td>
                                            <td>{{ $each->pax_inf_booked }}</td>

                                            <td>{{ $each->pax_c_actual }}</td>
                                            <td>{{ $each->pax_y_actual }}</td>
                                            <td>{{ $each->pax_inf_actual }}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>

                                </table>

                            </div>
                        </div>

                    </div>

                </div>

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table-flights");
    };

    pagefunction();
    {{--loadScript("{{ asset("/assets/js/views/aircraft/edit.js") }}", pagefunction);--}}

</script>