@php $currentAirlineId = isset($currentAirlineId) ? $currentAirlineId : '' @endphp

<div class="col-md-12 no-padding margin-bottom-10">
    <a target="_blank" href="{{ route("homepage")."#". url("flight-number/create?s=".rand(100, 999)."&current_airline_id={$currentAirlineId}") }}" class="btn btn-primary">@lang("content.add_new_flight_number")</a>
</div>

<div class="clearfix"></div>

@if (count($flightNumbers))

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-online" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div class="editable_div">

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover" id="table-flight-numbers" style="min-width: 100% !important;">
                    <thead>
                    <tr>
                        <th>No</th>
                        <th>@lang("content.airline")</th>
                        {{--<th>Flight Type</th>--}}
                        <th>@lang("content.flight_number")</th>
                        <th>SVC TYPE</th>
                        <th>ATC C/S</th>
                        <th>@lang("content.departure_airport")</th>
                        <th>@lang("content.arrival_airport")</th>
                        <th>@lang("content.direction")</th>
                        <th>@lang("content.duration")</th>
                        <th>@lang("content.distance"), km</th>
                        <th style="min-width: 240px;">@lang("content.actions")</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($flightNumbers as $j => $each)
                        @if ($each->deleted_at)
                            @continue
                        @endif

                        @php $departureAirport = $each->departureAirport ? $each->departureAirport->iata : "" @endphp
                        @php $arrivalAirport   = $each->arrivalAirport   ? $each->arrivalAirport->iata   : "" @endphp
                        @if ($each->distance)
                            @php $distance = $each->distance @endphp
                        @elseif($each->departureAirport && $each->arrivalAirport)
                            @php $distance = getDistanceBetweenPoints($each->departureAirport->latitude, $each->departureAirport->longitude, $each->arrivalAirport->latitude, $each->arrivalAirport->longitude, "Km" ) @endphp
                        @else
                            @php $distance = "" @endphp
                        @endif
                        <tr>
                            <td>{{ $j + 1 }}</td>
                            {{--                                            <td>{{ $each->flightType ? $each->flightType->type : "" }}</td>--}}
                            <td>{{ $each->airline ? ($each->airline->iata ." - ".$each->airline->airline) : "" }}</td>
                            <td>{{ $each->flight_number }}</td>
                            <td>
                                <a href="#" data-field='flight_type_id' data-model="FlightNumber" data-type="select" data-id='{{ $each->id }}'
                                   data-placeholder="Required" data-value='{{ $each->flight_type_id }}' class="editable {{  $each->flight_type_id ? 'editable-click' : 'editable-empty'  }}">
                                    {{ $each->flightType ? ($each->flightType->abbr ? $each->flightType->abbr : $each->flightType->type) : 'Empty' }}</a>
                            </td>
                            <td>{{ $each->cs }}</td>
                            <td>{{ $departureAirport }}</td>
                            <td>{{ $arrivalAirport }}</td>
                            <td>{{ $each->bound == 0 || !$each->bound ? "Outbound" : "Inbound" }}</td>
                            <td>{{ $each->duration }}</td>
                            <td>{{ $distance ? round($distance) : "" }}</td>
                            <td>
                                <div class="btn-group">
                                    <a target="_blank" href="{{ route("homepage")."#flight-number/{$each->id}" }}"
                                       class="btn btn-success">@lang("content.show_flights")</a>
                                    <a target="_blank" href="{{ route("homepage")."#flight-number/{$each->id}/edit?s=".rand(100, 999)."&current_airline_id={$currentAirlineId}" }}"
                                       class="btn btn-warning">@lang("content.edit")</a>
                                    <a href="{{ route("homepage")."#flight-number/{$each->id}/delete?current_airline_id={$currentAirlineId}" }}"
                                       class="btn btn-danger">@lang("content.delete")</a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>

@endif