<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => trans("content.flight_numbers"), 'moduleName' => trans("content.edit")])

                <div class="col-lg-12">
                    {!! Form::open([ 'method' => 'POST', 'class' => '', 'url' => url("/flight-number/{$flightNumber->id}?page={$currentPage}") ]) !!}
                    <table class="table">
                        <thead>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.flight_type")</td>
                                <td>{!! Form::select('flight_type', $flightTypes, $flightNumber->flight_type_id, ['class' => 'form-control']) !!}</td>
                                <td style="width: 25%">{!! Form::hidden('current_airline_id', \request("current_airline_id")) !!}</td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.airline")</td>
                                <td>{!! Form::select('airline', $airlines, $flightNumber->airline_id, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.flight_number")</td>
                                <td>{!! Form::text('flight_number', $flightNumber->flight_number, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">ATC C/S</td>
                                <td>{!! Form::text('cs', $flightNumber->cs, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">
                                    @lang("content.departure_airport") <br>
                                    <span class="color-red" style="font-weight: normal !important;">*ICAO, IATA</span>
                                </td>
                                <td>{!! Form::text('departure_airport',  getFlightNumberDepartureAirport($flightNumber), ['class' => 'form-control', 'maxlength' => 4]) !!}</td>
{{--                                <td>{!! Form::select('departure_airport', $airports, $flightNumber->departure_airport_id, ['class' => 'form-control']) !!}</td>--}}
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">
                                    @lang("content.arrival_airport") <br>
                                    <span class="color-red" style="font-weight: normal !important;">*ICAO, IATA</span>
                                </td>
                                <td>{!! Form::text('arrival_airport',  getFlightNumberArrivalAirport($flightNumber), ['class' => 'form-control', 'maxlength' => 4]) !!}</td>
{{--                                <td>{!! Form::select('arrival_airport', $airports, $flightNumber->arrival_airport_id, ['class' => 'form-control']) !!}</td>--}}
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">Direction</td>
                                <td>{!! Form::select('bound', $bound, $flightNumber->bound, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.duration")(@lang("content.mins"))</td>
                                <td>{!! Form::input('number', 'duration', $flightNumber->duration, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.distance")(km)<span class="color-red">*</span></td>
                                <td>{!! Form::input('number', 'distance', $distance, ['class' => 'form-control']) !!}</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td><span class="color-red">{{ !$distanceSet ? "*".trans("content.note_that_the_distance_is_calculated_based_on_latitude_and_longitude_points_of_airports_and_may_not_be_precise") : "" }}</span></td>
                            </tr>
                            <tr>
                                <td colspan="3">{!! Form::submit(trans("content.save_changes"), ['class' => 'btn btn-success btn-sm']) !!}</td>
                            </tr>
                        </tbody>
                    </table>
                    {!! Form::close() !!}

                </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table-flight-numbers");
    };

    pagefunction();
    {{--loadScript("{{ asset("/assets/js/views/aircraft/edit.js") }}", pagefunction);--}}

</script>