<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => trans("content.flight_numbers"), 'moduleName' => trans("content.add")])

                <div class="col-lg-12">
                    {!! Form::open([ 'method' => 'POST', 'class' => '', 'url' => url("flight-number") ]) !!}
                    <table class="table">
                        <thead>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.flight_type")</td>
                                <td>{!! Form::select('flight_type', $flightTypes, null, ['class' => 'form-control']) !!}</td>
                                <td style="width: 25%"></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.airline")</td>
                                <td>{!! Form::select('airline', $airlines, null, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.flight_number")</td>
                                <td>{!! Form::text('flight_number', null, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.departure_airport")</td>
                                <td>{!! Form::select('departure_airport', $airports, null, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.arrival_airport")</td>
                                <td>{!! Form::select('arrival_airport', $airports, null, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.direction")</td>
                                <td>{!! Form::select('bound', $bound, null, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.duration")(@lang("content.mins"))</td>
                                <td>{!! Form::input('number', 'duration', null, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_header vertical-center">@lang("content.distance")(km)<span class="color-red">*</span></td>
                                <td>{!! Form::input('number', 'distance', null, ['class' => 'form-control']) !!}</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td><span class="color-red">*@lang("content.note_that_the_distance_is_calculated_based_on_latitude_and_longitude_points_of_airports_and_may_not_be_precise")</span></td>
                            </tr>
                            <tr>
                                <td colspan="3">{!! Form::submit("Submit", ['class' => 'btn btn-success btn-sm']) !!}</td>
                            </tr>
                        </tbody>
                    </table>
                    {!! Form::close() !!}

                </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table-flight-numbers");
    };

    pagefunction();
    {{--loadScript("{{ asset("/assets/js/views/aircraft/edit.js") }}", pagefunction);--}}

</script>