<div class="table-chart">
    @php $totalPax = []; $totalPax['total'] = 0; $totalRevenue = []; $totalRevenue['total'] = 0; $totalYield = []; @endphp
    <table class="table table-hover table-striped table-bordered">
        <thead>
        <tr>
            <th>No.</th>
            <th>RBD</th>
            <th>PAX</th>
            <th>@lang("content.yield")</th>
            <th>@lang("content.revenue")</th>
        </tr>
        </thead>
        <tbody>
        @foreach($data as $cabin => $array)
            @php $totalPax[$cabin] = 0; $totalRevenue[$cabin] = 0; @endphp
            <tr>
                <td colspan="5"><strong>{{ ucwords($cabin) }} Class</strong></td>
            </tr>
            @foreach($array as $i => $each)
                @php $totalPax['total'] += $each->pax @endphp
                @php $totalRevenue['total'] += $each->revenue @endphp
                @php $totalPax[$cabin] += $each->pax @endphp
                @php $totalRevenue[$cabin] += $each->revenue @endphp

                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td>{{ $each->grouped_field }}</td>
                    <td>{{ $each->pax }}</td>
                    <td>{{ number_format(round($each->revenue/$each->pax)) }}</td>
                    <td>{{ number_format($each->revenue) }}</td>
                </tr>

                @if ($i == count($array) - 1)
                    <tr>
                        <td colspan="2"><strong>@lang("content.total")</strong></td>
                        <td>{{ $totalPax[$cabin] }}</td>
                        <td>{{ number_format(round($totalRevenue[$cabin] / $totalPax[$cabin])) }}</td>
                        <td>{{ number_format($totalRevenue[$cabin]) }}</td>
                    </tr>
                @endif
            @endforeach
        @endforeach
        @if ($totalPax['total'])
            <tr>
                <td colspan="2"><strong>@lang("content.grand_total")</strong></td>
                <td>{{ $totalPax['total']  }}</td>
                <td>{{ number_format(round($totalRevenue['total'] / $totalPax['total'])) }}</td>
                <td>{{ number_format($totalRevenue['total']) }}</td>
            </tr>
        @endif
        </tbody>
    </table>
</div>
