    @if (isset($data['flight']))
        <table class="table table-hover table-striped table-bordered">
            <thead>
            <tr>
                <th>@lang("content.flight_number")</th>
                <th>@lang("content.departure")</th>
                <th>@lang("content.arrival")</th>
                <th>A/C REG.</th>
                <th>A/C TYPE</th>
                <th>A/C CONFIG</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td>{{ $data['flight']->flightNumber->flight_number_iata." (".$data['flight']->flightNumber->flight_sector.")" }}</td>
                <td>
                    @if ($data['flight']->atd)
                        <div>{{ baseDateFormatYear($data['flight']->atd, true) }}</div>
                    @else
                        <div>{{ baseDateFormatYear($data['flight']->std, true) }}</div>
                    @endif
                </td>
                <td>
                    @if ($data['flight']->ata)
                        <div>{{ baseDateFormatYear($data['flight']->ata, true) }}</div>
                    @else
                        <div>{{ baseDateFormatYear($data['flight']->sta, true) }}</div>
                    @endif
                </td>
                <td>{{ $data['flight']->aircraft ? $data['flight']->aircraft->name : "-"}}</td>
                <td>{{ $data['aircraftType']}}</td>
                <td>@if ($data['flight']->aircraft)
                        @if ($data['flight']->aircraft->config_c)
                            {{ $data['flight']->aircraft->config_c."C/" }}
                        @endif
                        {{ $data['flight']->aircraft->config_y."Y" }}
                    @endif
                </td>
            </tr>
            </tbody>
        </table>

    @endif
