<?php require_once(public_path("smart/inc/init.php")); ?>

<link rel="stylesheet" type="text/css" href="{{ asset("/assets/css/jquery.seat-charts.css") }}">

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Flight Info', 'moduleName' => $moduleName])

            <div>
                <div class="board-inner">
                    <ul class="nav nav-tabs" id="myTab">
                        <li class="active">
                            <a href="#home" data-toggle="tab" title="home">
                                <i class="glyphicon glyphicon-home"></i><span class="tabText">@lang("content.home")</span>
                            </a>
                        </li>
                        <li>
                            <a href="#revenue" data-toggle="tab" title="revenue">
                                <i class="glyphicon glyphicon-download"></i><span class="tabText">@lang("content.revenue")</span>
                            </a>
                        </li>
                        <li>
                            <a href="#pl" data-toggle="tab" title="passengers">
                                <i class="glyphicon glyphicon-download"></i><span class="tabText">Passengers List</span>
                            </a>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade in active" id="home" style="padding: 10px">
                        @include('flight-info/layouts/index-home-tab')
                    </div>

                    <div class="tab-pane fade" id="revenue">
                        @include('flight-info/layouts/index-revenue-tab')
                    </div>

                    <div class="tab-pane fade" id="pl" style="padding: 10px">
                        @include('flight-info/layouts/index-pl-tab')
                    </div>

                    <div class="clearfix"></div>
                </div>

            </div>

        </article>

    </div>

</section>


<link rel="stylesheet" type="text/css" href="{{ asset("/assets/css/c3.css") }}">

<script type="text/javascript">

    pageSetUp();

    var aircraftType = "{{ isset($data['aircraftType']) ? $data['aircraftType'] : null }}";
    // Set Aircraft Background
    if (aircraftType == "A320-200"){
        aircraftType = "B737-800";
    }
    else if (aircraftType == "Embraer 190"){
        aircraftType = "B737-300";
    }

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#fi-pl_table");

        $('.seatCharts-container').css('background', 'url("assets/img/aircraft/' + aircraftType + '.jpg") #cdf0ff no-repeat 0 -23px');


//        google.load('visualization', '1', {packages: ['corechart']});

        var firstSeatLabel = 1,
            passengers = {!! json_encode($passengers) !!};

        MapPassengersBySeat(passengers);

        C3Charts({!! json_encode([[ 'Economy' , $data['seat_factors']['Economy'] ]])  !!}, '#chart_sf_economy', 'gauge', {height: 106, colors: ['#c3eb00']});
        C3Charts({!! json_encode([[ 'Business' , $data['seat_factors']['Business'] ]])  !!}, '#chart_sf_business', 'gauge', {height: 106, colors: ['#00d2ff']});
        C3Charts({!! json_encode([[ 'Total' , $data['seat_factors']['Total'] ]])  !!}, '#chart_sf_total', 'gauge', {height: 106, colors: ['#ff7200']});


        C3Charts({!! json_encode($data['revenue']['total'])  !!}, '#chart_revenue_total', 'bar', {height: 120, rotation: true, xLabel: 'Revenue, USD', xCategoryType: 'category', xCategoryArray : [''] });
        C3Charts({!! json_encode($data['revenue']['total'])  !!}, '#chart_revenue_share', 'donut', {height: 250,  donutTitle : "Revenue, Cabin" });

        C3Charts({!! json_encode($data['pax'])  !!}, '#chart_pax_total', 'bar', {height: 120, rotation: true, xLabel: 'PAX', xCategoryType: 'category', xCategoryArray : [''] });
        C3Charts({!! json_encode($data['pax'])  !!}, '#chart_pax_share', 'donut', {height: 250, donutTitle : "PAX, Cabin" });

        C3Charts({!! json_encode($data['revenue']['rbd'])  !!}, '#chart_revenue_rbd_share', 'donut', {height: 250, donutTitle : "Revenue, RBD" });


        /* Revenue Tab */
        C3Charts({!! json_encode($data['revenue']['salesChannels'])  !!}, '#chart_revenue_sales_channels', 'bar', {height: 375, rotation: true, xLabel: 'Revenue, USD', xCategoryType: 'category', xCategoryArray : [''] });
        C3Charts({!! json_encode($data['revenue']['country'])  !!}, '#chart_revenue_country', 'donut', {height: 250, donutTitle : "Revenue, Country"});


        var lineOptions = GetChartJsLineOptions();

        var revenueSalesDateData = {
            labels: {!! json_encode($data['revenue']['salesDate']['Date']) !!},
            datasets: [
                {
                    label: "Capacity",
                    backgroundColor: "rgba(68,148,210,0.2)",
                    borderColor: "rgba(68,148,210,0.8)",
                    pointBackgroundColor: "rgba(68,148,210,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(68,148,210,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius : 3,
                    data: {!! json_encode($data['revenue']['salesDate']['Revenue']) !!}
                }
            ]
        };

        // render chart
        var ctx = document.getElementById("chart_revenue_by_sales_date").getContext("2d");
        myNewChart_1 = new Chart(ctx, {
            type: 'line',
            data: revenueSalesDateData,
            options: lineOptions
        });
        // END CAPACITY CHART


        function updateWindow(container){
            var svg = $(container).find('svg'), parent;
            svg.each(function () {
                parent = $(this).parent();
                $(this).attr("width", parent.width()).attr("height", parent.height());
            });
        }

        $('a[data-toggle="tab"]').on("shown.bs.tab", function (e) {
            var _current_tab = $(e.target), current_tab_name = _current_tab.attr("href").replace("#", ""),
                    tabContainer = $("#" + current_tab_name);

            updateWindow(tabContainer);
        });


    };

    loadScript("{{ asset("/assets/js/vendor/d3.min.js") }}", function () {
        loadScript("{{ asset("/assets/js/vendor/c3.min.js") }}", function () {
            loadScript("{{ asset("/assets/js/vendor/jquery.seat-charts.js") }}", function () {
                loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", function () {
                    loadScript("{{ asset("/assets/js/views/flight-info/index.js?3") }}", pagefunction);
                });
            });
        });
    });



</script>







