<div>

    @if (!count($passengers[PNL]))
        <div class="alert alert-info">Not found any records.</div>
    @else
        <!-- Widget ID (each widget will need unique ID)-->
        <div class="jarviswidget jarviswidget-color-blueDark" id="PNL-container" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
        <!-- widget options:
        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        data-widget-colorbutton="false"
        data-widget-editbutton="false"
        data-widget-togglebutton="false"
        data-widget-deletebutton="false"
        data-widget-fullscreenbutton="false"
        data-widget-custombutton="false"
        data-widget-collapsed="true"
        data-widget-sortable="false"

        -->
        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

            <h2>@lang("content.list")</h2>

        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="width: 100%; overflow: auto;">

                <table id="PNL_table" class="table table-striped table-bordered table-hover" style="min-width: 100%;">

                    <thead>
                    <tr>
                        <th>No</th>
                        <th>@lang("content.first_name")</th>
                        <th>@lang("content.last_name")</th>
                        <th>@lang("content.gender")</th>
                        <th>@lang("content.ticket_number")</th>
                        <th>@lang("content.coupon")</th>

                        <th>@lang("content.fare")(USD)</th>
                        <th>@lang("content.fare_basis")</th>

                        <th>@lang("content.seat_number")</th>
                        <th>@lang("content.group")</th>
                        <th>PNR</th>
                        <th>FQTV</th>
                        <th>SPML</th>
                        <th>@lang("content.prepaid_bag")</th>

                    </tr>
                    </thead>
                    <tbody>
                    @php $totalFare = 0 @endphp

                    @foreach($passengerFlights as $i => $each)
                        @php $passenger = $each->passenger @endphp

                        @php $FQTV = "" @endphp
                        @if ($each->passengerFrequentFlyer)
                            @php $FQTV = $each->passengerFrequentFlyer->airline ? $each->passengerFrequentFlyer->airline->iata."-" : "" @endphp
                            @php $FQTV .= $each->passengerFrequentFlyer->ff_no @endphp
                        @endif

                        @php $XBag = "" @endphp
                        @if ($each->xbag_info)
                            @php $info = unserialize($each->xbag_info) @endphp
                            @php $XBag .= $each->xbag_qty ? ($each->xbag_qty . " BAGS ") : "" @endphp
                            @php $XBag .= $info[0] . " " @endphp

                            @if ($each->xbag_wt)
                                @php $XBag .= $each->xbag_wt . " KG" . " " @endphp
                            @endif

                            @if ($info && count($info) > 1)
                                @php $XBag .= $info[1] @endphp
                            @endif
                        @elseif ($each->xbag_wt)
                            @php $XBag .= $each->xbag_qty ? ($each->xbag_qty . " BAGS ") : "" @endphp
                            @if ($each->xbag_wt)
                                @php $XBag .= $each->xbag_wt . " KG" . " " @endphp
                            @endif
                        @endif

                        <tr>
                            <td>{{ $i + 1 }}</td>
                            @php $passengerLink = getPassengerLink($each->passenger_id) @endphp
                            @if ($ghaModule)
                                <td data-left>{{ $passenger ? $passenger->first_name : "" }}</td>
                                <td data-left>{{ $passenger ? $passenger->last_name : "" }}</td>
                            @else
                                <td data-left><a target="_blank" href="{{ $passengerLink }}">{{ $passenger ? $passenger->first_name : "" }}</a></td>
                                <td data-left><a target="_blank" href="{{ $passengerLink }}">{{ $passenger ? $passenger->last_name : "" }}</a></td>
                            @endif
                                <td>{{ $each->is_inf ? INF_USE : getGenderAbbr($passenger->gender) }}</td>
                            <td>{{ $each->passengerOrder ? $each->passengerOrder->ticket_number : "" }}</td>
                            <td>{{ $each->coupon }}</td>

                            @php $totalFare += ($each->fare ? $each->fare : 0) @endphp
                            <td>{{ $each->fare ? round($each->fare) : "" }}</td>
                            <td>{{ $each->flightFareBasis ? $each->flightFareBasis->fare_basis : "" }}</td>


                            <td>{{ $each->seat_number && strlen($each->seat_number) == 2 ? "0".$each->seat_number : $each->seat_number }}</td>

                            <td>{{ $each->group_tcp }}</td>
                            <td>{{ $each->passengerOrder ? $each->passengerOrder->pnr : "" }}</td>
                            <td>{{ $FQTV }}</td>
                            <td>{{ $each->spml }}</td>

                            <td class="nowrap">{{ $XBag }}</td>
                        </tr>
                    @endforeach

                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td><strong>@lang("content.total")</strong></td>
                        <td><strong>{{ round($totalFare) }}</strong></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>

                    </tr>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif
</div>