@include("flight-info.handling-layouts.uld-modal")

@include("flight-info.handling-layouts.uld-chart")

@if ($flightContainerInfo)
    <div class="col-sm-12" style="padding: 20px 0 10px 20px;">
        <span class="color_item"><span class="flight_color uld-b"></span> - @lang("content.baggage")</span>
        <span class="color_item"><span class="flight_color uld-t"></span> - @lang("content.transfer")</span>
        <span class="color_item"><span class="flight_color uld-c"></span> - @lang("content.cargo")</span>
        <span class="color_item"><span class="flight_color uld-cr"></span> - @lang("content.courier")</span>
        <span class="color_item"><span class="flight_color uld-m"></span> - @lang("content.mail")</span>
        <span class="color_item"><span class="flight_color uld-e"></span> - EIC</span>
        <span class="color_item"><span class="flight_color uld-mx"></span> - @lang("content.mixed")</span>

        <span class="color_item"><span class="flight_color vr"></span> - VR</span>
        <span class="color_item"><span class="flight_color vr-n"></span> - @lang("content.no_fit")</span>
    </div>

    <div class="clearfix"></div>
@endif

<div class="col-sm-12" style="padding: 20px; border-top: 1px solid">
    <p style="font-weight: bold; font-size: 14px;">CPM @lang("content.total_weight"): {{ $totalWeight ? $totalWeight." KGs" : "-" }}</p>
    <p style="font-weight: bold; font-size: 14px;">
        LDM @lang("content.total_weight"): {{ $flight->cmp_total_wt ? $flight->cmp_total_wt." KGs" : "-" }}
        ( @lang("content.baggage"): {{ $flight->baggage ? $flight->baggage." KGs" : "-" }}
        | @lang("content.cargo"): {{ $flight->cargo ? $flight->cargo." KGs" : "-" }}
        | @lang("content.mail"): {{ $flight->mail ? $flight->mail." KGs" : "-" }}
        | EIC: {{ $flight->eic ? $flight->eic." KGs" : "-" }} )
    </p>
</div>

@if ($flightContainerInfo && $flightContainerInfo->si)
    <div class="col-sm-12" style="padding: 0 20px 20px;">
        <p style="color: red; font-size: 14px;"><strong>SI:</strong> {{ $flightContainerInfo->si }}</p>
    </div>
@endif

<div class="clearfix"></div>

<ul class="nav nav-tabs" id="uldTab" style="padding: 0 10px;">
    <li class="active">
        <a href="#uld-table-tab" data-toggle="tab" title="home">
            <i class="glyphicon glyphicon-list"></i><span class="tabText">@lang("content.list")</span>
        </a>
    </li>
    <li class="">
        <a href="#uld-cpm-tab" data-toggle="tab" title="home">
            <i class="glyphicon glyphicon-envelope"></i><span class="tabText">CPM</span>
        </a>
    </li>
    <li class="">
        <a href="#uld-ldm-tab" data-toggle="tab" title="home">
            <i class="glyphicon glyphicon-envelope"></i><span class="tabText">LDM</span>
        </a>
    </li>
    <li class="">
        <a href="#uld-ucm-tab" data-toggle="tab" title="home">
            <i class="glyphicon glyphicon-envelope"></i><span class="tabText">UCM</span>
        </a>
    </li>
</ul>

<div class="tab-content">
    <div class="tab-pane active" id="uld-table-tab" style="padding: 10px">
        @include("flight-info.handling-layouts.uld-table")
    </div>

    <div class="tab-pane" id="uld-cpm-tab" style="padding: 10px">
        @include("flight-info.handling-layouts.uld-message", ['type' => CPM])
    </div>

    <div class="tab-pane" id="uld-ldm-tab" style="padding: 10px">
        @include("flight-info.handling-layouts.uld-message", ['type' => LDM])
    </div>

    <div class="tab-pane" id="uld-ucm-tab" style="padding: 10px">
        @include("flight-info.handling-layouts.uld-message", ['type' => UCM])
    </div>
</div>
