    @if (isset($data['flight']))
        <table class="table table-hover table-striped table-bordered">
            <thead>
            <tr>
                <th>@lang("content.flight_number")</th>
                <th>SVC TYPE</th>
                <th>@lang("content.departure")</th>
                <th>@lang("content.arrival")</th>
                <th>@lang("content.ac_reg")</th>
                <th>@lang("content.ac_type")</th>
                <th>@lang("content.ac_config")</th>
                <th>PAX ACT</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td>{{ $data['flight_number'] }}</td>
                <td class="text-center">{{ getFlightNumberType($flight->flightNumber) }}</td>
                <td>
                    @if ($data['flight']->atd && $data['flight']->atd != EMPTY_DATETIME)
                        <div>{{ baseDateFormatYear($data['flight']->atd, true) }}</div>
                    @elseif ($data['flight']->etd && $data['flight']->etd != EMPTY_DATETIME)
                        <div>{{ baseDateFormatYear($data['flight']->etd, true) }}</div>
                    @elseif ($data['flight']->ptd && $data['flight']->ptd != EMPTY_DATETIME)
                        <div>{{ baseDateFormatYear($data['flight']->ptd, true) }}</div>
                    @elseif ($data['flight']->std && $data['flight']->std != EMPTY_DATETIME)
                        <div>{{ baseDateFormatYear($data['flight']->std, true) }}</div>
                    @else
                        <div>-</div>
                    @endif
                </td>
                <td>
                    @if ($data['flight']->ata && $data['flight']->ata != EMPTY_DATETIME)
                        <div>{{ baseDateFormatYear($data['flight']->ata, true) }}</div>
                    @elseif($data['flight']->eta && $data['flight']->eta != EMPTY_DATETIME)
                        <div>{{ baseDateFormatYear($data['flight']->eta, true) }}</div>
                    @elseif ($data['flight']->pta && $data['flight']->pta != EMPTY_DATETIME)
                        <div>{{ baseDateFormatYear($data['flight']->pta, true) }}</div>
                    @elseif ($data['flight']->sta && $data['flight']->sta != EMPTY_DATETIME)
                        <div>{{ baseDateFormatYear($data['flight']->sta, true) }}</div>
                    @else
                        <div>-</div>
                    @endif
                </td>

                @php $aircraft ="-" @endphp
                @if ($data['flight']->aircraft)
                    @php $aircraft = $data['flight']->aircraft->name ? $data['flight']->aircraft->name : $data['flight']->aircraft->mvt_name @endphp
                @endif
                <td>{{ $aircraft }}</td>

                @php $aircraftType = null @endphp
                @if ($data['aircraftType'])
                    @php $aircraftType = $data['aircraftType'] @endphp
                @else
                    @if ($data['flight'] && $data['flight']->aircraftType)
                        @php $aircraftType = $data['flight']->aircraftType @endphp
                    @endif
                @endif
                <td>{{ $aircraftType ? ($aircraftType->name ? $aircraftType->name : $aircraftType->iata_name) : "-" }}</td>
                <td>
                    @if ($data['flight'])
                        {{ ($data['cabin']['config']['Business'] ? $data['cabin']['config']['First']."F/" : "")
                        .($data['cabin']['config']['Business'] ? $data['cabin']['config']['Business']."C/" : "")
                        .($data['cabin']['config']['EconomyPremium'] ? $data['cabin']['config']['EconomyPremium']."W/" : "")
                        . $data['cabin']['config']['Economy']."Y" }}
                    @endif
                </td>
                <td>
                    @if ($data['flight']->pax_y_actual)
                        {{ ($data['flight']->pax_a_actual ? $data['flight']->pax_a_actual."/" : "") }}
                        {{ ($data['flight']->pax_c_actual ? $data['flight']->pax_c_actual."/" : "") }}
                        {{ ($data['flight']->pax_w_actual ? $data['flight']->pax_w_actual."/" : "") }}
                        {{ $data['flight']->pax_y_actual }} {{ $data['flight']->pax_inf_actual ? "+". $data['flight']->pax_inf_actual : "" }}
                    @else
                        {{ $data['flight']->pax_mvt_total }} {{ $data['flight']->pax_mvt_inf ? "+". $data['flight']->pax_mvt_inf : "" }}
                    @endif
                </td>
            </tr>
            </tbody>
        </table>

    @endif
