<?php

    //initilize the page
    require_once(public_path("smart/inc/init.php"));

    //require UI configuration (nav, ribbon, etc.)
    require_once(public_path("smart/inc/config.ui.php"));

    include_once(public_path("smart/inc/user_variables.php"));

    /*---------------- PHP Custom Scripts ---------

    YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
    E.G. $page_title = "Custom Title" */

    $page_title = trans("content.flight_info");

    /* ---------------- END PHP Custom Scripts ------------- */

    //include header
    //you can add your custom css in $page_css array.
    //Note: all css files are inside css/ folder
    $page_css[] = "your_style.css";

    $no_main_header = true;

    $page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

    include(public_path("smart/inc/header.php"));

?>
<style>
    span.item {
        display: inline-block;
        margin-top: 8px;
    }
    div.fleetwatch_form .form-control{
        font-size: 14px !important;
    }
    div.fleetwatch_form select.crew{
        max-width: 200px !important;
    }
    div.fleetwatch_form label{
        font-size: 14px !important;
    }
    body{
        background-color: #FFFFff;
    }
    .form-inline input[type="text"],
    .form-inline input[type="email"],
    .form-inline select {
        margin-right: 10px;
        max-width: 160px;
    }
    #mytimeline .ui-widget-content {
        background: #FFF;
    }
</style>


<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->
<header id="header" style="background: #ffffff !important;">
    <!--<span id="logo"></span>-->

    <div id="logo-group" style="{{ $div_external_page }}">
        <span> <img style="{{ $logo_external_page }}" src="{{ $logo }}"  alt=""> </span>
        <h2 style="{{ $logo_text_external_page }}">{{ $logo_text }}</h2>
        <!-- END AJAX-DROPDOWN -->
    </div>
    <!--<span id="extr-page-header-space"> <span class="hidden-mobile hiddex-xs">Need an account?</span> <a href="<?php //	echo APP_URL; ?>/register.php" class="btn btn-danger">Creat account</a> </span>-->

</header>

<div id="main" role="main">

    <!-- MAIN CONTENT -->
    <div id="content" class="">

        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    @include('general.tab-header', ['departmentName' => trans("content.flight_info"), 'moduleName' => (isset($data['flight_number']) ? $data['flight_number'] : "")." | ".baseDateFormatYear(getFlightDepartureDate($data['flight'], true))])

                    <div>
                        <div class="board-inner">
                            <ul class="nav nav-tabs" id="myTab">
                                <li class="active">
                                    <a href="#home" data-toggle="tab" title="home">
                                        <i class="glyphicon glyphicon-home"></i><span class="tabText">@lang("content.home")</span>
                                    </a>
                                </li>

                                <li class="">
                                    <a href="#prl" data-toggle="tab" title="prl">
                                        <i class="glyphicon glyphicon-download"></i><span class="tabText">PRL</span>
                                    </a>
                                </li>

                                <li class="">
                                    <a href="#pnl" data-toggle="tab" title="pnl">
                                        <i class="glyphicon glyphicon-download"></i><span class="tabText">PNL</span>
                                    </a>
                                </li>

                                @if (airlineModule())
                                    <li class="">
                                        <a href="#hbg" data-toggle="tab" title="hbg">
                                            <i class="glyphicon glyphicon-download"></i><span class="tabText">HBG</span>
                                        </a>
                                    </li>
                                @endif

                                <li class="">
                                    <a href="#lir" data-toggle="tab" title="lir">
                                        <i class="glyphicon glyphicon-list"></i><span class="tabText">LIR</span>
                                    </a>
                                </li>
{{--                                <li class="">--}}
{{--                                    <a href="#docs" data-toggle="tab" title="docs">--}}
{{--                                        <i class="glyphicon glyphicon-download"></i><span class="tabText">DOCS</span>--}}
{{--                                    </a>--}}
{{--                                </li>--}}
                            </ul>
                        </div>

                        <div class="tab-content">
                            <div class="tab-pane active" id="home" style="padding: 10px">
                                @include('flight-info/handling-layouts/index-home-tab')
                            </div>

                            <div class="tab-pane " id="prl" style="padding: 10px">
                                @include('flight-info/handling-layouts/index-prl-tab')
                            </div>

                            <div class="tab-pane " id="pnl" style="padding: 10px">
                                @include('flight-info/handling-layouts/index-pnl-tab')
                            </div>

                            @if (airlineModule())
                                <div class="tab-pane" id="hbg" style="padding: 10px">
                                    @include('flight-info/handling-layouts/index-hbg-tab')
                                </div>
                            @endif

                            <div class="tab-pane " id="lir" style="padding: 10px">
                                @include('flight-info.handling-layouts.index-lir-tab')
                            </div>

{{--                            <div class="tab-pane" id="docs" style="padding: 10px">--}}
{{--                                @include('flight-info/handling-layouts/index-docs-tab')--}}
{{--                            </div>--}}
                        </div>

                    </div>

                </article>

            </div>

        </section>

    </div>

</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->


<link rel="stylesheet" type="text/css" href="{{ asset("/assets/css/c3.css") }}">
<link rel="stylesheet" type="text/css" href="{{ asset("/assets/css/jquery.seat-charts.css?7") }}">

<script type="text/javascript">
    var baseUrl = "{{ url('/') }}";
    var baseDashboardUrl = "{{ url('home/dashboard') }}";
    var baseHomeUrl = "{{ route("homepage")."#". url('/') }}";
    var AIRLINE = "{{ env("AIRLINE") }}";
    var CARRIER = "{{ env("CARRIER") }}";
    var CURRENT_IATA_CODE = "{{ env("IATA_CODE") }}";
</script>

<?php
    //include required scripts
    include(public_path("smart/inc/scripts.php"));
?>

<!-- PAGE RELATED PLUGIN(S)-->

<script type="text/javascript">

    pageSetUp();

    var acConfig = {!! json_encode($aircraft["config"]) !!};

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#PRL_table");

        ApplyTableFilter("#PNL_table");

        ApplyTableFilter("#HBG_table");

        ApplyTableFilter("#ULD_table");

        // NOT USER
//        $('.seatCharts-container').css('background', 'url("' + baseUrl + '/assets/img/aircraft/' + aircraftType + '.jpg") #cdf0ff no-repeat 0 -23px');

        $('.seatCharts-container').css('height', "{{ $aircraft["wide_board"] ? "300px" : "220px" }}");

        MapPassengersBySeat({!! json_encode($chartPassengers) !!});

        C3Charts({!! json_encode([[ 'Economy' , $data['seat_factors']['Economy'] ]])  !!}, '#chart_sf_economy', 'gauge', {height: 106, colors: ['#c3eb00']});
        C3Charts({!! json_encode([[ 'Business' , $data['seat_factors']['Business'] ]])  !!}, '#chart_sf_business', 'gauge', {height: 106, colors: ['#00d2ff']});
        C3Charts({!! json_encode([[ 'Total' , $data['seat_factors']['Total'] ]])  !!}, '#chart_sf_total', 'gauge', {height: 106, colors: ['#ff7200']});


        C3Charts({!! json_encode($data['pax'])  !!}, '#chart_pax_total', 'bar', {height: 120, rotation: true, xLabel: 'PAX', xCategoryType: 'category', xCategoryArray : [''] });
        C3Charts({!! json_encode($data['pax'])  !!}, '#chart_pax_share', 'donut', {height: 250, donutTitle : "PAX, Cabin" });

        /*
        {{--C3Charts({!! json_encode($data['revenue']['total'])  !!}, '#chart_revenue_total', 'bar', {height: 120, rotation: true, xLabel: 'Revenue, USD', xCategoryType: 'category', xCategoryArray : [''] });--}}
        {{--C3Charts({!! json_encode($data['revenue']['total'])  !!}, '#chart_revenue_share', 'donut', {height: 250,  donutTitle : "Revenue, Cabin" });--}}

        {{--C3Charts({!! json_encode($data['revenue']['rbd'])  !!}, '#chart_revenue_rbd_share', 'donut', {height: 250, donutTitle : "Revenue, RBD" });--}}
        {{--C3Charts({!! json_encode($data['revenue']['salesChannels'])  !!}, '#chart_revenue_sales_channels', 'bar', {height: 375, rotation: true, xLabel: 'Revenue, USD', xCategoryType: 'category', xCategoryArray : [''] });--}}
        {{--C3Charts({!! json_encode($data['revenue']['country'])  !!}, '#chart_revenue_country', 'donut', {height: 250, donutTitle : "Revenue, Country"});--}}

        var lineOptions = GetChartJsLineOptions();

        var revenueSalesDateData = {
            {{--labels: {!! json_encode($data['revenue']['salesDate']['Date']) !!},--}}
            datasets: [
                {
                    label: "Capacity",
                    backgroundColor: "rgba(68,148,210,0.2)",
                    borderColor: "rgba(68,148,210,0.8)",
                    pointBackgroundColor: "rgba(68,148,210,1)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(68,148,210,1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius : 3,
                    {{--data: {!! json_encode($data['revenue']['salesDate']['Revenue']) !!}--}}
                }
            ]
        };

         // render chart
         var ctx = document.getElementById("chart_revenue_by_sales_date").getContext("2d");
         myNewChart_1 = new Chart(ctx, {
         type: 'line',
         data: revenueSalesDateData,
         options: lineOptions
         });
         // END CAPACITY CHART
         */

        function updateWindow(container){
            var svg = $(container).find('svg'), parent;
            svg.each(function () {
                parent = $(this).parent();
                $(this).attr("width", parent.width()).attr("height", parent.height());
            });
        }

        $('a[data-toggle="tab"]').on("shown.bs.tab", function (e) {
            var _current_tab = $(e.target), current_tab_name = _current_tab.attr("href").replace("#", ""),
                    tabContainer = $("#" + current_tab_name);

            updateWindow(tabContainer);
        });

        $(document).on("click", ".uld", function () {
            var _this = $(this),
                uld_modal = $("#uld_modal"),
                id = _this.data('id'),
                position = _this.data('position'),
                container = _this.data('container'),
                weight = _this.data('weight'),
                loaded_type = _this.data('loaded_type');

            uld_modal.find("#uld_title").html("<span style='font-weight: bold;'>" + position + "</span><span style='margin-left: 130px !important;font-weight: bold;'>" + container + "</span>");
//            uld_modal.find("#uld_container_label").text(position >= 50 ? "Bulk:" : "Container:");
//            uld_modal.find("#uld_container").text(container);
            uld_modal.find("#uld_weight").text(weight);
            uld_modal.find("#uld_loaded_type").text(loaded_type);
        });
    };

    loadScript("{{ asset("/assets/js/vendor/d3.min.js") }}", function () {
        loadScript("{{ asset("/assets/js/vendor/c3.min.js") }}", function () {
            loadScript("{{ asset("/assets/js/vendor/jquery.seat-charts.js") }}", function () {
                loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", function () {
                    loadScript("{{ asset("/assets/js/views/flight-info/index.js?21") }}", pagefunction);
                });
            });
        });
    });

</script>


<link rel="stylesheet" type="text/css" href="{{ asset("/assets/css/c3.css") }}">
<link rel="stylesheet" type="text/css" href="{{ asset("/assets/css/jquery.seat-charts.css?8") }}">

<script type="text/javascript">

    runAllForms();

</script>

