@php $signature = isset($signature) && $signature ? true : false @endphp
<html>

<link href="{{ asset("/assets/css/bootstrap.min.css") }}" rel="stylesheet"/>
<link href="{{ asset("/assets/css/export.css?3") }}" rel="stylesheet"/>

<page size="A4">

    <div class="width-100p font_gen_doc">

        <div class="width-100p margin-bottom-10">

            <div style="width: 140px; float: left;" class="text-center">
                {{--<img style="max-width: 160px;" src="{{ asset("assets/img/logos/tajikair.png") }}" />--}}
                <img style="max-width: 130px;" src="{{ getAirlineLogo(null) }}" />
            </div>

            <div class="width-70p">
                <h5 class="font_gen_doc" align="center">
                    <strong>GENERAL DECLARATION</strong></h5>

                <h6 class="font_gen_doc" align="center">
                    {{ getAirlineOfficialWords(OFFICIAL_AIRLINE_NAME) }}<br/>
                    {{ getAirlineOfficialWords(OFFICIAL_AILINE_OF_COUNTRY) }}
                </h6>
            </div>
        </div>
        <br/>

        <div class="width-100p margin-bottom-10">
            <div class="width-30p">Owner or operator <span style="margin-left: 10px;"><strong>{{ getAirlineOfficialWords(OFFICIAL_AIRLINE_NAME_SHORT) }}</strong></span></div>
            <div class="width-50p text-center">(OUTWARD / INWARD) <span style="margin-left: 20px;">ICAO ANNEX 9</span></div>
            <div class="width-20p text-right">APPENDIX 1</div>
        </div>


        @php $airline = $flight->flightNumber ? $flight->flightNumber->airline : null @endphp
        @php $airlineModule = airlineModule() @endphp
        @php $airlineICAO = $airlineModule ? env("ICAO") : ($airline ? $airline->icao : "") @endphp

        <div class="width-100p margin-bottom-10">
            <div class="width-50p">Marks of Nationality and Registration
                <span class="underline">
                <strong>{{ str_repeat("&nbsp;",10).getAircraft($flight->aircraft).str_repeat("&nbsp;",10) }}</strong>
                </span>
            </div>
            <div class="width-30p">Flight NO. <span
                        class="underline"><strong>{{ str_repeat("&nbsp;",10).$airlineICAO.getFlightNumber($flight, false, false).str_repeat("&nbsp;",10) }}</strong></span></div>
            <div class="width-20p">Date
                <span class="underline">
                    <strong>
                        {{ str_repeat("&nbsp;",10). ukDateFormat(getFlightDepartureInitialDate($flight, true), false, ".").str_repeat("&nbsp;",10) }}
                    </strong>
                </span>
            </div>
        </div>


        @php $depAP      = getFlightDepartureAirport($flight) @endphp
        @php $depCity    = $depAP && $depAP->city    ? $depAP->city->city        : $depAP->iata @endphp
        @php $depCountry = $depAP && $depAP->country ? $depAP->country->country  : null @endphp

        @php $arrAP      = getFlightArrivalAirport($flight) @endphp
        @php $arrCity    = $arrAP && $arrAP->city    ? $arrAP->city->city        : $arrAP->iata @endphp
        @php $arrCountry = $arrAP && $arrAP->country ? $arrAP->country->country  : null @endphp

        <div class="width-100p">
            <div class="width-50p">Departure from
                <span class="underline"><strong>{{ str_repeat("&nbsp;",10).$depCity.($depCountry ? ", {$depCountry}" : "").str_repeat("&nbsp;",20) }}</strong></span>
            </div>
            <div class="width-50p">Arrival at
                <span class="underline"><strong>{{ str_repeat("&nbsp;",10).$arrCity.($arrCountry ? ", {$arrCountry}" : "").str_repeat("&nbsp;",20) }}</strong></span>
            </div>
        </div>
        <div class="width-100p">
            <div class="width-30p" style="margin-left: 120px;">(Place and country)</div>
            <div class="width-30p" style="margin-left: 120px;">(Place and country)</div>
        </div>

        <div class="width-100p text-center">
            FLIGHT ROUTING<br/>
            (“Place” Column always to list origin, every en-route stop and destination)
        </div>

        <table class="table-bordered">
            <tbody>
            <tr>
                <td class="text-center">PLACE</td>

                <td colspan="3" class="text-center">
                    (1) TOTAL NUMBER OF CREW
                </td>

                <td class="text-center" style="min-width: 190px;">
                    (2)NUMBER OF PASSENGERS<br/>
                     ON THIS STAGE
                </td>

                <td class="text-center">CARGO</td>
            </tr>

            <tr>
                <td class="text-center"><strong>{{ $depCity }}</strong></td>
                <td><strong>PIC</strong></td>
                <td><strong>{{ $crew["capt"] && isset($crew["capt"][0]) ? $crew["capt"][0]->last_name." ".$crew["capt"][0]->first_name : "" }}</strong></td>
                <td>{{ $crew["capt"] && isset($crew["capt"][0]) && $crew["capt"][0]->passport_num ? $crew["capt"][0]->passport_num : "&mdash;" }}</td>

                <td rowspan="{{ $rowSpan }}">
                    <p class="text-center"><span class="underline">Departure Place:</span> <strong>{{ $depAP->iata }}</strong><br/>

                    <p class="text-center">
                        Embarking_________________
                        Through on Same
                    </p><br/>

                    <p>Flight____________________</p>

                    <p class="text-center"><span class="underline">Arrival Place:</span> <strong>{{ $arrAP->iata }}</strong><br/><br/><br/>

                    <p class="text-center">
                        Disembarking______________<br/>
                        Through on Same
                    </p><br/>

                    <p>Flight____________________</p>

                </td>

                <td rowspan="{{ $rowSpan }}">
                    <br/><br/><br/><br/><br/>

                    <p class="text-center margin-top-10">
                       _______Cargo<br/>
                        Manifest<br/>
                        Attached
                    </p><br/><br/>

                    <p>_______Mail</p><br/><br/>

                    <p>_______Bagg</p>

                </td>
            </tr>

            @php $icaoInserted = false @endphp
            @foreach($crew["capt"] as $i => $cc)
                @if ($i == 0)
                    @continue
                @endif

                @php $icaoInserted = true @endphp
                <tr>
                    <td class="text-center"><strong>({{ $depAP->icao }})</strong></td>
                    <td><strong>Captain</strong></td>
                    <td><strong>{{ $cc ? $cc->last_name." ".$cc->first_name : "" }}</strong></td>
                    <td>{{ $cc && $cc->passport_num ? $cc->passport_num : "&mdash;" }}</td>
                </tr>
            @endforeach

            @foreach($crew["fo"] as $i => $cc)
                <tr>
                    <td class="text-center"><strong>{{ !$icaoInserted ? "({$depAP->icao})" : "" }}</strong></td>
                    <td><strong>First Officer</strong></td>
                    <td><strong>{{ $cc ? $cc->last_name." ".$cc->first_name : "" }}</strong></td>
                    <td>{{ $cc && $cc->passport_num  ? $cc->passport_num : "&mdash;" }}</td>
                </tr>
            @endforeach

            <tr class="height-16">
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr class="height-16">
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            @if (isset($crew["cc"][0]))
            <tr>
                <td></td>
                <td><strong>FA</strong></td>
                <td><strong>{{ $crew["cc"][0]->last_name." ".$crew["cc"][0]->first_name }}</strong></td>
                <td>{{ $crew["cc"][0]->passport_num  ? $crew["cc"][0]->passport_num : "&mdash;" }}</td>
            </tr>
            @endif

            @php $ccCounter = count($crew["cc"]) @endphp
            @php $maxCC = 8 @endphp
            @foreach($crew["cc"] as $i => $cc)
                @if ($i == 0)
                    @continue
                @endif
                <tr>
                    <td></td>
                    <td><strong>FA</strong></td>
                    <td>{{ $cc ? $cc->last_name." ".$cc->first_name : "" }}</td>
                    <td>{{ $cc && $cc->passport_num  ? $cc->passport_num : "&mdash;" }}</td>
                </tr>
            @endforeach

            @for($i = $ccCounter; $i < $maxCC; $i++)
                <tr class="height-16">
                    <td></td>
                    <td><strong>FA</strong></td>
                    <td></td>
                    <td></td>
                </tr>
            @endfor

            <tr class="height-16">
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            @php $supCounter = count($crew["sup"]) @endphp
            @php $maxSUP = 2 @endphp
            @foreach($crew["sup"] as $i => $cc)
                <tr>
                    <td></td>
                    <td><strong>GE</strong></td>
                    <td>{{ $cc ? $cc->last_name." ".$cc->first_name : "" }}</td>
                    <td>{{ $cc && $cc->passport_num  ? $cc->passport_num : "&mdash;" }}</td>
                </tr>
            @endforeach

            @for($i = $supCounter; $i < $maxSUP; $i++)
                <tr>
                    <td></td>
                    <td><strong>GE</strong></td>
                    <td></td>
                    <td></td>
                </tr>
            @endfor

            <tr class="height-16">
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

             <tr>
                <td></td>
                <td><strong>Crew member</strong></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td class="text-center"><strong>{{ $arrCity }}</strong></td>
                <td><strong>Service Passenger</strong></td>
                <td></td>
                <td></td>
                <td rowspan="2" colspan="2" class="text-center">
                    FOR OFFICIAL USE<br/>
                    ONLY
                </td>
            </tr>

            <tr>
                <td class="text-center"><strong>({{ $arrAP->icao }})</strong></td>
                <td><strong>Service Passenger</strong></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td colspan="4">
                    <p class="text-center">DECLARATION OF HEALTH</p>
                    <p>Persons on Board known to be suffering from illness other than airsickness or the EFFECTS of accident, as well as those cases of illness disembarked during the flight</p>
                </td>
                <td rowspan="8" colspan="2"></td>
            </tr>

            <tr>
                <td colspan="4" class="text-center"><strong>NIL</strong></td>
            </tr>

            <tr>
                <td colspan="4"><br/>
                    <p>Any other conditions on board which may lead to the spread of disease</p>
                </td>
            </tr>

            <tr>
                <td colspan="4" class="text-center"><strong>NIL</strong></td>
            </tr>

            <tr>
                <td colspan="4"><p>Details of each disinfecting of sanitary treatment ( place, date, time, method ) during the flight. If no disinfecting has been carried out during the flight give details of most recent disinfecting.</p></td>
            </tr>

            <tr>
                <td colspan="4" class="text-center"><strong>NIL</strong></td>
            </tr>

            <tr>
                <td colspan="4" class="height-16"></td>
            </tr>

            <tr>
                <td colspan="4" class="text-center" style="padding-top: 15px;">
                    Signed if required______________________________<br/>
                    <span style="margin-left:80px;">(crew member concerned)</span>
                </td>
            </tr>

            <tr>
                <td colspan="6">
                    <p class="text-center">
                        I declare that all statements and particulars contained in this General Declaration, and in the supplementary forms required to be<br/>
                        Presented with General Declaration are complete, exact and true to the best of my knowledge and that all through passengers<br/>
                        Will continue / have continued on the flight.
                    </p><br/>

                    <p class="text-center">
                        Signature__________________________________________<br/>
                        ( Authorized agent or pilot-in command )
                    </p>
                </td>
            </tr>

            </tbody>
        </table>

    </div>

</page>


</html>
