@php $signature = isset($signature) && $signature ? true : false @endphp
<html>

<link href="{{ asset("/assets/css/bootstrap.min.css") }}" rel="stylesheet"/>
<link href="{{ asset("/css/general.css?3") }}" rel="stylesheet"/>
<link href="{{ asset("/assets/css/export.css?3") }}" rel="stylesheet"/>

<page size="A4-album">

    <div class="width-100p font_flight_order">

        @php $depAP      = getFlightDepartureAirport($flight) @endphp
        @php $depCity    = $depAP && $depAP->city    ? $depAP->city->city        : $depAP->iata @endphp
        @php $depCountry = $depAP && $depAP->country ? $depAP->country->country  : null @endphp

        @php $arrAP      = getFlightArrivalAirport($flight) @endphp
        @php $arrCity    = $arrAP && $arrAP->city    ? $arrAP->city->city        : $arrAP->iata @endphp
        @php $arrCountry = $arrAP && $arrAP->country ? $arrAP->country->country  : null @endphp

        <div class="row">

            <div class="col-sm-6">

                <table cellpadding="0" cellspacing="0" class="padding-0" style="width: 100%">
                    <tbody>
                    <tr class="height-18">
                        <td colspan="4" class="no-border text-center"><strong>Отметка в аэропортах (REMARKS)</strong></td>
                    </tr>

                    <tr class="height-18">
                        <td>Аэропорт
                            (Airport)
                        </td>
                        <td>Медосмотр
                            (Med/control)
                        </td>
                        <td>Метеоконсультации
                            (Weather obs.)
                        </td>
                        <td>Взлеты и заходы
                            (Minimums)
                        </td>
                    </tr>

                    @php $j = 0 @endphp
                    @php $minRows = 12 @endphp
                    @for($i = $j; $i < $minRows; $i++)
                        <tr class="height-18">
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endfor

                    </tbody>
                </table>

                <table cellpadding="0" cellspacing="0" class="padding-0 margin-top-10" style="width: 100%">
                    <tr class="height-18">
                        <td class="no-border"><strong>Результаты послеполетного разбора <br>
                                (After flight briefing)
                            </strong>
                        </td>
                    </tr>
                    <tbody>
                    @php $j = 0 @endphp
                    @php $minRows = 5 @endphp
                    @for($i = $j; $i < $minRows; $i++)
                        <tr class="height-18">
                            <td></td>
                        </tr>
                    @endfor

                    </tbody>
                </table>

                <table cellpadding="0" cellspacing="0" class="padding-0" style="width: 100%; margin-top: 10px;">
                    <tbody>
                    <tr class="height-18">
                        <td class="no-border"><strong>Особые отметки (Special remarks)</strong></td>
                    </tr>
                    <tr class="height-18 no-border-left-right">
                        <td></td>
                    </tr>
                    <tr class="height-18 no-border-left-right">
                        <td></td>
                    </tr>
                    <tr class="height-18 no-border-left-right">
                        <td></td>
                    </tr>
                    <tr class="height-18 no-border-left-right">
                        <td></td>
                    </tr>
                    <tr class="height-18 no-border-left-right">
                        <td></td>
                    </tr>
                    <tr class="height-18 no-border-left-right">
                        <td><strong>Нач. штаба  ЛК</strong></td>
                    </tr>
                    </tbody>
                </table>

                <div class="clearfix"></div>

                <p class="margin-top-10">
                    <span>Заключение командира АЭ</span>
                    <span style="margin-right: 10px">________________</span>
                    <span>Заключение директора ЛК</span>
                    <span>_________________</span>
                </p>

                <div class="clearfix"></div>

                <p class="margin-top-10">
                    <span style="float: left; margin-right: 20px;">
                        ______________________________________________________________
                    </span>


                    <span class="bordered" style="height: 20px; display: inline-block; width: 30px;"></span>
                    <span class="bordered" style="height: 20px; display: inline-block; width: 30px;"></span>
                    <span class="bordered" style="height: 20px; display: inline-block; width: 30px;"></span>
                </p>

                <div class="clearfix"></div>

                <p class="margin-top-10">
                    <strong>Комадир АЭ</strong>
                    <span style="margin-right: 20px">________________________</span>

                    <span><strong>Летный  директор</strong></span>
                    <span style="margin-right: 20px">________________________</span>
                    <br>
                    <span style="margin-left: 100px">(подпись) (ФИО)</span>
                    <span style="margin-left: 180px">(подпись) (ФИО)</span>
                </p>

                <div class="clearfix"></div>

                <p class="margin-top-10">
                    <span style="margin-left: 20px">«_______» __________________ 20_____г.</span>
                    <span style="margin-left: 40px">«_______» __________________ 20_____г.</span>
                </p>

            </div>

            <div class="col-sm-6">

                <p class="text-center">
                    <span>
                        <strong>ЗАДАНИЕ НА ПОЛЕТ №</strong>
                    </span>

                    <span class="bordered" style="height: 20px; display: inline-block; width: 30px;"></span>
                    <span class="bordered" style="height: 20px; display: inline-block; width: 30px;"></span>
                    <span class="bordered" style="height: 20px; display: inline-block; width: 30px;"></span>

                    <br>
                    <span style="margin-right: 50px;">
                        <strong>FLIGHT ORDER №</strong>
                    </span>
                </p>

                <div class="clearfix"></div>

                @php $capt = $crew["capt"] && isset($crew["capt"][0]) ? $crew["capt"][0]->last_name." ".$crew["capt"][0]->first_name : "" @endphp
                <p class="">
                    <strong>Командир ВС</strong>
                    <span style="font-size: 16px; margin-left: 20px; text-decoration: underline;"><strong>{{ str_repeat("&nbsp;",20). $capt .str_repeat("&nbsp;",20)}}</strong></span>

                    <span class="bordered text-center" style="min-width: 100px; display: inline-block; height: 25px;"><strong></strong></span><br>
                    <span style="margin-left: 0">(CAPTAIN)</span>
                    <span style="margin-left: 60px">(фамилия, имя, отчество) (Last name/First name)</span>
                </p>

                <p class="margin-top-5">
                    <strong>{{ getAirlineOfficialWords(OFFICIAL_AIRLINE_COMPANY) }} </strong>
                    <span style="margin-left: 20px;"><strong>Дата вылета</strong></span>

                    @php $dep = getFlightDepartureInitialDate($flight) @endphp
                    @php $day = date("d", strtotime($dep)) @endphp
                    @php $mo = date("m", strtotime($dep)) @endphp
                    @php $year = date("Y", strtotime($dep)) @endphp

                    @php $hr = date("H", strtotime($dep)) @endphp
                    @php $min = date("i", strtotime($dep)) @endphp

                    <span class="bordered"><strong>{{ $day }}</strong></span>
                    <span class="bordered"><strong>{{ $mo }}</strong></span>
                    <span class="bordered"><strong>{{ $year }}г</strong></span>

                    <span style="margin-left: 20px;"><strong>Время</strong></span>
                    <span class="bordered"><strong>{{ $hr }}</strong></span>
                    <span class="bordered"><strong>{{ $min }}</strong></span> <br>

                    <span style="margin-left: 150px">(Date)</span>
                    <span style="margin-left: 160px">(Time)</span>
                </p>

                <p class="">
                    <span style="margin-right: 20px;"> <strong>Тип ВС</strong></span>
                    <span class="bordered text-center" style="min-width: 100px; display: inline-block"><strong>{{ getFlightAircraftType($flight) }}</strong></span>

                    <span style="margin:0 10px 0 20px;"> <strong>№</strong></span>
                    <span class="bordered text-center" style="min-width: 100px; display: inline-block"><strong>{{ getFlightAircraft($flight) }}</strong></span>

                    <span style="margin:0 10px 0 20px;"> <strong>Число кресел</strong></span>
                    <span class="bordered text-center" style="min-width: 80px; display: inline-block"><strong>{{ getFlightCapacity($flight, true) }}</strong></span>
                    <br>
                    <span style="margin-left: 0">(Type of AC)</span>
                    <span style="margin-left: 280px">(Seats)</span>
                </p>

                <div class="clearfix"></div>

                <table cellpadding="0" cellspacing="0" class="padding-0" style="width: 100%">
                    <tbody>
                    <tr>
                        <td colspan="4" class="no-border text-center"><strong>СОСТАВ ЭКИПАЖА (Flight Crew)</strong></td>
                    </tr>

                    <tr>
                        <td><strong>Должность <br>(Position)</strong></td>
                        <td><strong>Фамилия, И., О. <br>(Last name/First name)</strong></td>
                        <td><strong>Табельный <br> номер</strong></td>
                        <td><strong>Примечание <br>(Remarks)</strong></td>
                    </tr>

                    @foreach($crew["capt"] as $i => $cc)
                        @if ($i == 0)
                            @continue
                        @endif

                        <tr>
                            <td>Проверяющий  (Chief)</td>
                            <td>{{ $cc ? $cc->last_name." ".$cc->first_name : "" }}</td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endforeach

                    @if (count($crew["capt"]) == 1)
                        <tr>
                            <td>Проверяющий  (Chief)</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endif


                    @foreach($crew["fo"] as $i => $cc)
                        <tr>
                            <td>Второй пилот ( F/О)</td>
                            <td>{{ $cc ? $cc->last_name." ".$cc->first_name : "" }}</td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endforeach

                    <tr class="height-20">
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>

                    @if (isset($crew["cc"][0]))
                        <tr>
                            <td>Ст. Бортпроводник (SCC)</td>
                            <td>{{ $crew["cc"][0]->last_name." ".$crew["cc"][0]->first_name }}</td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endif

                    @php $ccCounter = count($crew["cc"]) @endphp
                    @php $maxCC = 6 @endphp
                    @foreach($crew["cc"] as $i => $cc)
                        @if ($i == 0)
                            @continue
                        @endif
                        <tr>
                            <td>Бортпроводник. (CC)</td>
                            <td>{{ $cc ? $cc->last_name." ".$cc->first_name : "" }}</td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endforeach

                    <tr class="height-20">
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>

                    @php $supCounter = count($crew["sup"]) @endphp
                    @php $maxSUP = 1 @endphp
                    @foreach($crew["sup"] as $i => $cc)
                        <tr>
                            <td>Инженер АТК ОАО</td>
                            <td>{{ $cc ? $cc->last_name." ".$cc->first_name : "" }}</td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endforeach

                    @for($i = $supCounter; $i < $maxSUP; $i++)
                        <tr class="height-20">
                            <td>Инженер АТК ОАО</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endfor

                    </tbody>
                </table>

                <div class="clearfix"></div>

                <p class="margin-top-10">
                    <span>Цель полета:</span>
                    <span class="bordered">P</span>
                    <span style="margin-left: 10px">___________________________________________________________________</span><br>
                    <span style="">____________________________________________________________________________________</span>
                </p>

                <p>
                    <span>Маршрут</span>
                    <span class="underline" style="margin: 0 10px;">(Route)</span>
                    <span class="underline margin-left-10">{{ str_repeat("&nbsp;",10) }}<strong>{{ strtoupper($depCity) ." - ".strtoupper($arrCity)." - ".strtoupper($depCity) }}</strong>{{ str_repeat("&nbsp;",20) }}</span>
                </p>

                <p>
                    <span>Экипаж допущен к полетам по минимуму</span>
                    <span style="margin-left: 10px">_____________________________________________</span><br>
                    <span>(Allowed crew minima)</span>
                </p>

                <p>
                    <span>Масса конструкции ВС</span>
                    <span style="margin-left: 10px">________________ кг, центровка пустого ВС ________________ % САХ</span><br>
                    <span>(AC weight)</span>
                    <span style="margin-left: 170px;">(empty AC balance)</span>
                </p>

                <p>
                    <span><strong>Экипаж к полету подготовлен</strong></span>
                </p>

                <div class="clearfix"></div>

                <p class="">
                    <strong>Шеф-пилот ЛК</strong>
                    <span style="margin-right: 20px">___________________</span>
                    <span style="margin-right: 20px">___________________</span>
                    <span style="margin-right: 20px">___________________</span>
                    <br>
                    <span style="margin-left: 120px">(подпись)</span>
                    <span style="margin-left: 70px">(фамилия, и., о.)</span>
                    <span style="margin-left: 70px">(дата)</span>
                </p>

                <div class="clearfix"></div>
                <p class="">
                    <strong>Лет. директор ОАО </strong>
                    <span style="margin-right: 20px">________________</span>
                    <span style="margin-right: 20px">___________________</span>
                    <span style="margin-right: 20px">___________________</span>
                    <br>
                    <span style="margin-left: 120px">(подпись)</span>
                    <span style="margin-left: 70px">(фамилия, и., о.)</span>
                    <span style="margin-left: 70px">(дата)</span>
                </p>

            </div>

        </div>

    </div>

    <script src="{{ asset("assets/js/jquery-2.1.3.min.js")  }}"></script>
    <script type="text/javascript">
        $(document).ready(function() {
//            var rotate = $('.rotate'), parent = rotate.parent();
//            rotate.css('width', parent.height() - 20);
//            parent.css('width', "40px");
        });
    </script>

</page>

</html>
