<table id="{{ $headFltType }}_table" class="flightsTable table table-bordered table-hover" style="width: 100%; height: 100%;">
    <thead>
        <tr class="table-title">
            <th style="padding: 0 !important;" ></th>
            <th style="">Flight Details</th>
        </tr>
        </thead>

        <tbody>

        @php $logoWidth = $airlineModule ? 32 : 64 @endphp

        @foreach($data as $i => $flight)

            @php $fltType = $flight->type @endphp

            @php $flightNumber = $flight->flightNumber @endphp
            @php $airline = $flightNumber ? $flightNumber->airline : null @endphp
            @php list($fn1, $fn2, $fn3) = getFlightNumberStrings($flight) @endphp

            @php $childDiff = false @endphp
            @if ($flight->flightChild)
                @php $childDiff = strtotime(getFlightDepartureDate($flight->flightChild)) > strtotime(getFlightDepartureDate($flight)) @endphp
            @endif

            @php $depAP = getFlightDepartureAirport($flight) @endphp
            @php $dep = $depAP ? $depAP->iata : "" @endphp

            @php $arrAP = getFlightArrivalAirport($flight) @endphp
            @php $arr = $arrAP ? $arrAP->iata : "" @endphp

            @php $depType = getFlightDepartureTimeType($flight, true) @endphp
            @php $depInitialType = getFlightDepartureInitialTimeType($flight, true) @endphp

            @php $arrType = getFlightArrivalTimeType($flight, true) @endphp
            @php $arrInitialType = getFlightArrivalInitialTimeType($flight, true) @endphp

            @php $fnReady = $fn3 ? $fn3 : $fn2 @endphp
            @php $sectorReady = " | ".$dep."-".$arr."" @endphp

            {{--DETAILS--}}
            @php $ac = getFlightAircraft($flight) @endphp
            @php $acType = getFlightAircraftType($flight) @endphp

            @php $cap =  getFlightCapacity($flight) @endphp
            @php $bookedPax = getFlightBookedPax($flight) @endphp
            @php $actualPax = getFlightActualPax($flight) @endphp

            @php $capReady = "CFG ".($cap[0] ? $cap[0]."C " : "").$cap[1]."Y" @endphp
            @php $bookedPaxReady = ($bookedPax[0] || $bookedPax[1]) ? "BKD ".($bookedPax[0] ? $bookedPax[0]."C " : "").$bookedPax[1]."Y" : "" @endphp
            @php $actualPaxReady = ($actualPax[0] || $actualPax[1]) ? "ACT ".($actualPax[0] ? $actualPax[0]."C " : "").$actualPax[1]."Y" : "" @endphp

            @php $aircraftDetails = $acType.($ac ? " | ".$ac : "") @endphp

            @php $fltDepDetails = $aircraftDetails." | ".$capReady.($bookedPaxReady ? " | ".$bookedPaxReady : "").($actualPaxReady ? " | ".$actualPaxReady : "") @endphp
            @php $fltArrDetails = $aircraftDetails." | ".$capReady.($actualPaxReady ? " | ".$actualPaxReady : "") @endphp

            {{--END--}}

            @php $flightRadarLink = ($airline ? $airline->iata ? $airline->iata : ($airline->icao ? $airline->icao : "") : "") .ltrim($flightNumber->flight_number, "0") @endphp
            @php $flightStatus = getFlightClassNameStrict($flight, $fltType) @endphp

            @php list($delayCodes, $delayTimes) = getFlightDelays($flight, true) @endphp

            @if (isset($isMobile) && $isMobile)

                @php $depSpan = departureArrivalTypeSpan($depType, null, "inline-block", "22px !important") @endphp
                @php $depInitialSpan = departureArrivalTypeSpan($depInitialType, null, "inline-block", "22px !important") @endphp

                @php $arrSpan = departureArrivalTypeSpan($arrType, null, "inline-block", "22px !important") @endphp
                @php $arrInitialSpan = departureArrivalTypeSpan($arrInitialType, null, "inline-block", "22px !important") @endphp

                @php $depInitialTxt = $depInitialSpan . "<span class='dep-time-initial'>" . baseDateFormat(getFlightDepartureInitialDate($flight), true, " ", true, false, "") . "</span>" @endphp
                @php $depTxt = $depSpan . "<span id='flt_dep_arr_time' class='dep-time'>" . baseDateFormat(getFlightDepartureDate($flight), true, " ", true, false, "") . "</span>" @endphp

                @php $arrInitialTxt = $arrInitialSpan . "<span class='arr-time-initial'>" . baseDateFormat(getFlightArrivalInitialDate($flight), true, " ", true, false, "") . "</span>" @endphp
                @php $arrTxt = $arrSpan . "<span id='flt_dep_arr_time' class='arr-time'>" . baseDateFormat(getFlightArrivalDate($flight), true, " ", true, false, ""). "</span>" @endphp

                {{ debug($fnReady." ".$fltType) }}
                @if ($fltType == DEPARTURE)
                    <tr class="flight_row" data-child_id="{{ $flight->flightChild && $childDiff ? $flight->flightChild->id : '' }}" data-flight_id="{{ $flight->id }}" data-parent_id="{{ $flight->parent_id }}" data-fn="{{ $fnReady }}" data-sector="{{ $sectorReady }}" data-remark="{{ $flight->remark }}"
                        data-dep="{{ $depTxt }}" data-arr="{{ $arrTxt }}" data-flight_radar="{{ $flightRadarLink }}"
                        data-flt_ac_type="{{ $acType }}" data-flt_ac="{{ $ac }}" data-flt_cfg="{{ $capReady }}"
                        data-flt_bkd="{{ $bookedPaxReady }}" data-flt_act="{{ $actualPaxReady }}"
                        data-flt_dep_details="{{ $fltDepDetails }}" data-flt_type="{{ $fltType }}">
                @else
                    <tr class="flight_row" data-child_id="{{ $flight->flightChild && $childDiff ? $flight->flightChild->id : '' }}" data-flight_id="{{ $flight->id }}" data-parent_id="{{ $flight->parent_id }}" data-fn="{{ $fnReady }}" data-sector="{{ $sectorReady }}" data-remark="{{ $flight->remark }}"
                        data-dep="{{ $depTxt }}" data-arr="{{ $arrTxt }}" data-flight_radar="{{ $flightRadarLink }}"
                        data-flt_ac_type="{{ $acType }}" data-flt_ac="{{ $ac }}" data-flt_cfg="{{ $capReady }}"
                        data-flt_bkd="" data-flt_act="{{ $actualPaxReady }}"
                        data-flt_arr_details="{{ $fltArrDetails }}" data-flt_type="{{ $fltType }}">
                @endif

                    <td class="flight-status {{ $flightStatus }}"></td>

                    <td class="flight-box" style="padding: 10px 5px !important; width: 98% !important;">
                        @if ($headFltType == CANCELLED || $flight->cancelled_at)
                            <div style="float: none; clear: both;">
                                <span id="" style="display:inline-block; font-size: 18px"
                                      class="label label-danger departureArrivalType">FLIGHT CANCELLED</span>
                            </div>
                        @endif

                        @if (!$airlineModule)
                            <div style="float: left; padding: 20px 10px;">
                                @php $icon = strtolower($fltType)."64.png" @endphp
                                <img class="dep-arr-icon" style="max-height: 64px; max-width: 48px;" src="{{ asset("assets/img/icons/others/{$icon}") }}" />
                            </div>
                        @endif

                        <div style="float: left; margin-left: 5px; height: 100%; width: calc(100% - 160px);">
                            {{--<h4 class="flightTracker-airline">{{ $fn1 }}</h4>--}}
                            <div style="float: left; margin: 15px 5px; width: {{ $logoWidth * 2 }}px; ">
                                <img class='flightTracker-airline-logo' style="max-height: 40px; max-width: 100%;" src='{{ getAirlineLogo($airline, true) }}'/>
                            </div>

                            <div style="float: left; margin: 5px; width: 150px">
                                @php $addStyles = strlen($fnReady) >= 7 ? "font-size:30px; padding: 2px 0;" : "" @endphp
                                <h1 class="flightTracker-airline" style="margin: 5px 0 !important; {{ $addStyles }}">{{ $fnReady }}</h1>
                            </div>
                            <div style="float: left; margin: 5px 10px; margin-left: 0; width: 210px;">
                                <h1 class="flightTracker-airline" style="margin: 5px 0 !important;">{{ $sectorReady }}</h1>
                            </div>

                            <div style="float: left; margin: 15px 0; ">
                                <h3 class="ac-details" style="line-height: 30px; margin: 0;">| {{ $aircraftDetails }}</h3>
                            </div>

                            <div style="float: left; margin-left: 5px;">
                                @if ($airlineModule)
                                    <h3 class="flight-timings" style="margin: 5px 0;">{!! $depInitialTxt." ".$depTxt ." ". $arrTxt !!}
{{--                                        <span class="color-red"><strong>{{ $delayCodes ? "*DL ".$delayCodes : ""}}</strong></span>--}}
                                    </h3>
                                @else
                                    @if ($fltType == DEPARTURE)
                                        <h3 class="flight-timings" style="margin: 5px 0;">{!! ($depType == $depInitialType ? "" :  $depInitialTxt) ." ". $depTxt !!}</h3>
                                    @else
                                        <h3 class="flight-timings" style="margin: 5px 0;">{!! ($arrType == $arrInitialTxt ? "" :  $arrInitialTxt) ." ". $arrTxt !!}</h3>
                                    @endif
                                @endif
                            </div>
                        </div>

                        <div class="flight_msg_count" style="float: right; padding: 10px;">
                            <span class="font-lg badge badge-warning" style="background-color: #00bd00; font-size: 24px;"></span>
                        </div>
                    </td>

                </tr>
            @else
                @php $depSpan = departureArrivalTypeSpan($depType, null) @endphp
                @php $depInitialSpan = departureArrivalTypeSpan($depInitialType, null) @endphp

                @php $arrSpan = departureArrivalTypeSpan($arrType, null) @endphp
                @php $arrInitialSpan = departureArrivalTypeSpan($arrInitialType, null) @endphp

                @php $depInitialTxt = $depInitialSpan . "<span class='dep-time-initial'>" . baseDateFormat(getFlightDepartureInitialDate($flight), true, " ", true, false, "") . "</span>" @endphp
                @php $depTxt = $depSpan . "<span id='flt_dep_arr_time' class='dep-time'>" . baseDateFormat(getFlightDepartureDate($flight), true, " ", true, false, "") . "</span>" @endphp

                @php $arrInitialTxt = $arrInitialSpan . "<span class='arr-time-initial'>" . baseDateFormat(getFlightArrivalInitialDate($flight), true, " ", true, false, "") . "</span>" @endphp
                @php $arrTxt = $arrSpan . "<span id='flt_dep_arr_time' class='arr-time'>" . baseDateFormat(getFlightArrivalDate($flight), true, " ", true, false, ""). "</span>" @endphp

                <tr class="flight_row" data-child_id="{{ $flight->flightChild && $childDiff ? $flight->flightChild->id : '' }}" data-parent_id="{{ $flight->parent_id }}" data-flight_id="{{ $flight->id }}" data-fn="{{ $fnReady }}" data-sector="{{ $sectorReady }}" data-remark="{{ $flight->remark }}"
                    data-dep="{{ $depTxt }}" data-arr="{{ $arrTxt }}" data-flight_radar="{{ $flightRadarLink }}"
                    data-flt_ac_type="{{ $acType }}" data-flt_ac="{{ $ac }}" data-flt_cfg="{{ $capReady }}"
                    data-flt_bkd="{{ $bookedPaxReady }}" data-flt_act="{{ $actualPaxReady }}"
                    data-flt_dep_details="{{ $fltDepDetails }}" data-flt_arr_details="{{ $fltArrDetails }}" data-flt_type="{{ $fltType }}">

                    <td style="width: 10px !important;" class="flight-status {{ $flightStatus }}"></td>

                    <td class="flight-box" style="padding: 0 5px !important; width: 98% !important;">
                        @if ($headFltType == CANCELLED || $flight->cancelled_at)
                            <div style="float: none;">
                            <span id="" style="display:inline-block; font-size: 18px"
                                  class="label label-danger departureArrivalType">FLIGHT CANCELLED</span>
                            </div>
                        @endif

                        @if (!$airlineModule)
                            <div style="float: left; padding: 10px 7px 10px 3px;">
                                @php $icon = strtolower($fltType)."32.png" @endphp
                                <img class="dep-arr-icon" style="max-height: 32px; max-width: 24px" src="{{ asset("assets/img/icons/others/{$icon}") }}" />
                            </div>
                        @endif

                        <div style="float:left;">
                            <div style="float: left; margin: 5px; width: {{ $logoWidth }}px; ">
                                <img class='flightTracker-airline-logo' style="max-height: 30px; max-width: 100%;" src='{{ getAirlineLogo($airline, true) }}'/>
                            </div>
                            <div style="float: left; margin: 0 5px; width: 65px;">
                                @php $addStyles = strlen($fnReady) >= 7 ? "font-size:15px; padding: 2px 0;" : "" @endphp
                                <h4 class="flightTracker-airline" style="margin: 5px 0 !important; {{ $addStyles }}">
                                    {{  $fnReady }}
                                </h4>
                            </div>
                            <div style="float: left; margin: 0 5px; width: 105px;">
                                <h4 class="flightTracker-airline" style="margin: 5px 0 !important;">
                                    {{ $sectorReady }}
                                </h4>
                            </div>
                            <div style="float: left; margin: 5px 0; height: 100%; vertical-align: middle">
                                <h6 class="ac-details" style="line-height: 20px;">| {{ $aircraftDetails }}</h6>
                            </div>
                            <div class="clearfix"></div>
                            <div>
                                @if ($airlineModule)
                                    <h6 class="flight-timings">{!! $depInitialTxt." ".$depTxt." ". $arrTxt !!} <span class="color-red"><strong>{{ $delayCodes ? "*DL ".$delayCodes : ""}}</strong></span></h6>
                                @else
                                    @if ($fltType == DEPARTURE)
                                        <h6 class="flight-timings">{!! ($depType == $depInitialType ? "" :  $depInitialTxt) ." ". $depTxt !!}</h6>
                                    @else
                                        <h6 class="flight-timings">{!! ($arrType == $arrInitialType ? "" :  $arrInitialTxt) ." ". $arrTxt !!}</h6>
                                    @endif
                                @endif
                            </div>
                        </div>

                        <div class="flight_msg_count" style="float: right;line-height: 50px; height: 100%;">
                            <span class="badge badge-warning" style="background-color: #00bd00"></span>
                        </div>
                    </td>

                </tr>
            @endif

        @endforeach
        </tbody>

    </table>
