@extends("layout-fleetwatch")

@section("content")

    <style>
        span.item {
            display: inline-block;
            margin-top: 8px;
        }
        div.fleetwatch_form .form-control{
            font-size: 14px !important;
        }
        div.fleetwatch_form select.crew{
            max-width: 200px !important;
        }
        div.fleetwatch_form label{
            font-size: 14px !important;
        }
        body{
            background-color: #FFFFff;
        }
        .form-inline input[type="text"],
        .form-inline input[type="email"],
        .form-inline select {
            margin-right: 10px;
            max-width: 160px;
        }
        #mytimeline .ui-widget-content {
            background: #FFF;
        }
    </style>

    @include('general.tab-header')

    {{--@if (Session::get("message"))--}}
    {{--<p class="alert alert-info">{!! Session::get("message") !!}</p>--}}
    {{--@endif--}}


    <div class="marginBottomRight" style="margin-bottom:20px; min-width: 950px; width: 100%; display: inline-block">

        <div class="floatOnly" style="min-width: 200px; width: 25%; margin: 0">
            {!! Form::open(["method"=>"get", "id"=>"go_to_date_form", 'class' => 'form-inline form-horizontal']) !!}
            {!! Form::input("text", "go_to_date", \request("go_to_date"), ["class"=>"form-control floatOnly datepicker inputDateSmall", "placeholder"=>"Date", "id"=>"go_to_date"]) !!}
            <div class="btn-group floatOnly">
                <button type="submit" id="btn-go-to-date" class="btn btn-primary btn-sm">Go</button>
                <button type="submit" id="btn-clear-go-to-date" class="btn btn-default btn-sm">Reset</button>
            </div>
            {!! Form::close() !!}

            <span style="font-size: 11px; color: #5f5f5f; display: none; margin-left: 20px;" id="loading-fleetwatch-data">
            <img width="24" src="{{ asset("/assets/img/2.GIF") }}" alt="Loading..."/> Loading...
        </span>
        </div>

        <div class="floatOnly text-center" style="min-width: 220px; width: 25%; margin: 0;">
            <span class="timeNow">Today: {!! gmdate('D, d M Y') !!}</span><br/>
            <span class="timeNow" style="color: #ff0400">Time Now:</span><span class="timeNow" id="timeNow" style="color: #ff0400"></span>
        </div>

        @if ( isset($userModules) && isset($module) && $userModules && in_array(41, $userModules[$module->id]))
            <div class="floatOnly" style="min-width:430px; width: 50%; margin: 0">
                <div class="floatRight">
                    @php $opsDateFrom = \request("go_to_date") ? \request("go_to_date") : (\request("start_time") ? date('Y-m-d', strtotime(\request("start_time"))) : date('Y-m-d')) @endphp
                    @php $opsDateTo   = \request("go_to_date") ? \request("go_to_date") : (\request("start_time") ? date('Y-m-d', strtotime(\request("start_time"))) : date('Y-m-d')) @endphp

                    {!! Form::open(['method' => 'GET', 'url' => URL::to('export/fleetwatch-report'), 'target' => "_blank", 'class' => 'form-inline']) !!}
                    {!! Form::label('reportType', 'Reports', ['class'=>'floatOnly center text-right']) !!}
                    {!! Form::select('reportType', ['ops' => 'OPS', 'crew' => 'Crew'], null, ['class' => 'form-control floatOnly']) !!}
                    {!! Form::label('fromDate', trans("content.from"), ['class'=>'floatOnly center']) !!}
                    {!! Form::text('fromDate', $opsDateFrom, [ 'id' => 'from_date', 'class' => 'form-control inputDateSmall floatOnly', "required" => "required"]) !!}
                    {!! Form::label('toDate', trans("content.to"), ['class'=>'floatOnly center']) !!}
                    {!! Form::text('toDate', $opsDateTo, [ 'id' => 'to_date', 'class' => 'form-control inputDateSmall floatOnly', "required" => "required"]) !!}
                    <div class="btn-group floatOnly">
                        {!! Form::submit('Export', ['type' => 'submit', 'class' => 'btn btn-primary btn-sm floatOnly']) !!}
                        <a target="_blank" href="{{ url("/report/ops?dateSearch=fromTo&dateFrom={$opsDateFrom}&dateTo={$opsDateTo}") }}" class="btn btn-success btn-sm">View</a>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        @endif
    </div>



    <div id="fleetwatch_message_block" style="clear: both"></div>
    <!-- Fleet watch timeline -->
    <div id="mytimeline" style="min-height: 200px;  min-width: 950px; width: 100%; "></div>

    <div class="col-sm-12" style="margin: 20px 0">
        <span class="color_item"><span class="flight_color available"></span> - No Delays</span>
        <span class="color_item"><span class="flight_color delayed"></span> - Delayed</span>
        <span class="color_item"><span class="flight_color diversion"></span> - Diversion</span>
        <span class="color_item"><span class="flight_color maintenance"></span> - Maintenance</span>
    </div>

    <hr/>

    <!--------Crew Hours Info Modal------------>
    @include('template/crew-change-process')

            <!-------- Include Flight Form ---------------->
    @include("flight/form")

            <!-- Include Flight modal information window -->
    @include("flight/modal_info")

            <!-- Include Flight maintenance modal window -->
    @include("flight/modal_maintenance_info")

@stop

@section("js_scripts")
    <link rel="stylesheet" href="{{ asset("/assets/timeline/timeline.css") }}" />
    <link rel="stylesheet" href="{{ asset("/assets/timeline/timeline-theme.css") }}" />
    <link rel="stylesheet" href="{{ asset("/packages/ionicons/css/ionicons.min.css") }}" />

    <script src="{{ asset("/assets/js/vendor/bootstrap-tooltip.js") }}"></script>
    <script type="text/javascript">

        var editable = {{ isset($userModules) && isset($module) && isset($userModules[$module->id]) && in_array(10,$userModules[$module->id]) ? 1 : 0 }};
        var json = {!! $json !!};
        var goToDate = '{{ (\request("go_to_date")) ? date('D M d Y H:i:s O', strtotime(\request("go_to_date"))) : false }}';
        var startVisibleDate = '{!! (\request("start_time")) ? \request("start_time") : false !!}',
                endVisibleDate = '{!! (\request("end_time")) ? \request("end_time") : false !!}';

        // Tooltip
        $("[data-toggle='tooltip']").popover({ trigger: "hover" });
    </script>

    <script src="{{ asset("/assets/js/vendor/bootbox.min.js") }}"></script>
    <script src="{{ asset("/assets/js/vendor/google-jsapi.js") }}"></script>
    <script src="{{ asset("/assets/timeline/timeline.js") }}"></script>
    <script src="{{ asset("/assets/js/views/fleetwatch/timeline.js") }}"></script>
    <script src="{{ asset("/assets/js/vendor/jquery.bpopup.min.js") }}"></script>
    <script src="{{ asset("/assets/js/vendor/jquery.datetimepicker.js") }}"></script>
    <script src="{{ asset("/assets/js/vendor/select-sync-mine.js") }}"></script>
    <script src="{{ asset("/assets/js/views/fleetwatch/form.js") }}"></script>

@stop