<?php

	//initilize the page
	require_once(public_path("smart/inc/init.php"));

	//require UI configuration (nav, ribbon, etc.)
	require_once(public_path("smart/inc/config.ui.php"));


	/*---------------- PHP Custom Scripts ---------

	YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
	E.G. $page_title = "Custom Title" */

	$page_title = "Fleetwatch";

	/* ---------------- END PHP Custom Scripts ------------- */

	//include header
	//you can add your custom css in $page_css array.
	//Note: all css files are inside css/ folder
	$page_css[] = "your_style.css";

	$no_main_header = true;

	$page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

	include(public_path("smart/inc/header.php"));

?>
<style>
	span.item {
		display: inline-block;
		margin-top: 8px;
	}
	div.fleetwatch_form .form-control{
		font-size: 14px !important;
	}
	div.fleetwatch_form select.crew{
		max-width: 200px !important;
	}
	div.fleetwatch_form label{
		font-size: 14px !important;
	}
	body{
		background-color: #FFFFff;
	}
	.form-inline input[type="text"],
	.form-inline input[type="email"],
	.form-inline select {
		margin-right: 10px;
		max-width: 160px;
	}
	#mytimeline .ui-widget-content {
		background: #FFF;
	}
</style>


<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->
<header id="header">
	<!--<span id="logo"></span>-->

	<div id="logo-group">
		<span id="logo"> <img  style="width: 200px" src="<?php echo ASSETS_URL; ?>/img/logo.png" alt="Aviation-BIS"> </span>

		<!-- END AJAX-DROPDOWN -->
	</div>

	<!--<span id="extr-page-header-space"> <span class="hidden-mobile hiddex-xs">Need an account?</span> <a href="<?php //	echo APP_URL; ?>/register.php" class="btn btn-danger">Creat account</a> </span>-->

</header>

<div id="main" role="main">

	<!-- MAIN CONTENT -->
	<div id="content" class="">

		@include('general.tab-header')

		<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-4" style="margin-bottom: 15px;">
				{!! Form::open(["method"=>"get", "id"=>"go_to_date_form", 'class' => 'form-inline form-horizontal']) !!}
				{!! Form::input("text", "go_to_date", \request("go_to_date"), ["class"=>"form-control input-sm floatOnly date fleetwatch-input-date", "placeholder"=>"Date", "id"=>"go_to_date"]) !!}
				{!! Form::submit("Submit", [ "id" => "btn-go-to-date", "class" => "btn btn-primary"]) !!}
				<span style="font-size: 11px; color: #5f5f5f; display: none; margin-left: 20px;" id="loading-fleetwatch-data">
                        <img width="24" src="{{ asset("/assets/img/2.GIF") }}" alt="Loading..."/>
                    </span>
				{!! Form::close() !!}

			</div>

			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-3 text-center" style="margin-bottom: 15px;">
				<span class="timeNow">Today: {!! gmdate('D, d M Y') !!}</span><br/>
				<span class="timeNow" style="color: #ff0400">Time Now:</span><span class="timeNow" id="timeNow" style="color: #ff0400"></span>
			</div>

			@if ( isset($userModules) && isset($module) && $userModules && in_array(41, $userModules[$module->id]))
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-5" style="margin-bottom: 15px;">
					@php $opsDateFrom = \request("go_to_date") ? \request("go_to_date") : (\request("start_time") ? date('Y-m-d', strtotime(\request("start_time"))) : date('Y-m-d')) @endphp
					@php $opsDateTo   = \request("go_to_date") ? \request("go_to_date") : (\request("start_time") ? date('Y-m-d', strtotime(\request("start_time"))) : date('Y-m-d')) @endphp

					{!! Form::open(['method' => 'GET', 'url' => URL::to('export/fleetwatch-report'), 'target' => "_blank", 'class' => 'form-inline']) !!}
					{!! Form::label('reportType', 'Reports', ['class'=>'floatOnly center text-right']) !!}
					{!! Form::select('reportType', ['ops' => 'OPS', 'crew' => 'Crew'], null, ['class' => 'form-control input-sm floatOnly']) !!}
					{!! Form::label('fromDate', trans("content.from"), ['class'=>'floatOnly center']) !!}
					{!! Form::text('fromDate', $opsDateFrom, [ 'id' => 'from_date', 'class' => 'form-control input-sm fleetwatch-input-date floatOnly', "required" => "required"]) !!}
					{!! Form::label('toDate', trans("content.to"), ['class'=>'floatOnly center']) !!}
					{!! Form::text('toDate', $opsDateTo, [ 'id' => 'to_date', 'class' => 'form-control input-sm fleetwatch-input-date floatOnly', "required" => "required"]) !!}
					<div class="btn-group">
						{!! Form::submit('Export', ['type' => 'submit', 'class' => 'btn btn-primary floatOnly']) !!}
						<a target="_blank" href="{{ url("/report/ops?dateSearch=fromTo&dateFrom={$opsDateFrom}&dateTo={$opsDateTo}") }}" class="btn btn-success btn-sm">View</a>
					</div>
					{!! Form::close() !!}
				</div>
			@endif

		</div>

		<div id="fleetwatch_message_block" style="clear: both"></div>

		<!-- Fleet watch timeline -->
		<div id="mytimeline" style="min-height: 50px;  min-width: 950px; width: 100%; margin-bottom: 20px; "></div>

		<div class="col-sm-12">
			<span class="color_item"><span class="flight_color available"></span> - No Delays</span>
			<span class="color_item"><span class="flight_color delayed"></span> - Delayed</span>
			<span class="color_item"><span class="flight_color diversion"></span> - Diversion</span>
			<span class="color_item"><span class="flight_color maintenance"></span> - Maintenance</span>

			<span style="display: none; margin-left: 20px;" id="loading-fleetwatch-form">
                <img width="24" src="{{ asset("/assets/img/2.GIF") }}" alt="Loading..."/> Loading, please wait...
            </span>

		</div>

		<div class="clearfix"></div>
		<hr/>

		<!--------Crew Hours Info Modal------------>
		@include('template/crew-change-process')

				<!-------- Include Flight Form ---------------->
		@include("flight/form")

				<!-- Include Flight modal information window -->
		@include("flight/modal_info")

				<!-- Include Flight maintenance modal window -->
		@include("flight/modal_maintenance_info")

	</div>

</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<?php
	//include required scripts
include(public_path("smart/inc/scripts.php"));
?>

<!-- PAGE RELATED PLUGIN(S)
<script src="..."></script>-->
<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline.css") }}" />
<link rel="stylesheet" href="{{ asset("/assets/timeline/timeline-theme.css") }}" />
<link rel="stylesheet" href="{{ asset("/packages/ionicons/css/ionicons.min.css") }}" />

<script src="<?php echo asset("/assets/js/vendor/underscore-min.js"); ?>"></script>

<script src="{{ asset("/assets/js/vendor/bootstrap-tooltip.js") }}"></script>
<script type="text/javascript">

	pageSetUp();

	var baseUrl = "{{ url('/') }}";
	var baseHomeUrl = "{{ route("homepage")."#".url('/') }}";

	var editable = {{ isset($userModules) && isset($module) && isset($userModules[$module->id]) && in_array(10,$userModules[$module->id]) ? 1 : 0 }};
	var json = {!! $json !!};
	var goToDate = '{{ (\request("go_to_date")) ? date('D M d Y H:i:s O', strtotime(\request("go_to_date"))) : false }}';
	var startVisibleDate = '{!! (\request("start_time")) ? \request("start_time") : false !!}',
			endVisibleDate = '{!! (\request("end_time")) ? \request("end_time") : false !!}';

	// Tooltip
	$("[data-toggle='tooltip']").popover({ trigger: "hover" });
</script>

<script src="{{ asset("/assets/js/vendor/bootbox.min.js") }}"></script>
<script src="{{ asset("/assets/js/vendor/google-jsapi.js") }}"></script>
<script src="{{ asset("/assets/timeline/timeline.js") }}"></script>
<script src="{{ asset("/assets/js/views/fleetwatch/timeline.js?2") }}"></script>
<script src="{{ asset("/assets/js/vendor/jquery.bpopup.min.js") }}"></script>
<script src="{{ asset("/assets/js/vendor/jquery.datetimepicker.js") }}"></script>
<script src="{{ asset("/assets/js/vendor/select-sync-mine.js") }}"></script>
<script src="{{ asset("/assets/js/views/fleetwatch/form.js?2") }}"></script>

<script type="text/javascript">
	runAllForms();
</script>

<?php
	//include footer
	//include(public_path("smart/inc/google-analytics.php"));
?>