<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: aviation.dev
 */
//_debug($aircraft);

if ($aircraft->first_flight) {
    $first_flight = new DateTime($aircraft->first_flight);
    $now = new DateTime();
    $interval = $now->diff($first_flight);
    $diff = (($interval->y > 0) ? $interval->y . " years" : "") . (($interval->m > 0) ? ", " . $interval->m . " months" : "");
}

//_debug($aircraftParts);
?>



<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    @include('general.tab-header', ['departmentName' => "Admin", 'moduleName' => 'Detailed information '.$aircraft->name])

            <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="panel panel-primary">
              <div class="panel-heading">
                <h3 class="panel-title">@lang("content.aircraft") General Information</h3>
              </div>
              <div class="panel-body">
                <table class="table table-condensed">
                    <tr>
                        <th rowspan="2">@lang("content.name")</th>
                        <th rowspan="2">@lang("content.type")</th>
                        <th rowspan="2">Construction Number (MSN)</th>
                        <th rowspan="2">Line Number</th>
                        <th rowspan="2">First Flight</th>
                        <th rowspan="2">Age</th>
                        <th rowspan="2">Airframe Status</th>
                        <th rowspan="2">@lang("content.config")</th>
                        <th colspan="2">Flight Crew</th>
                        <th colspan="2">Cabin Crew</th>
                    </tr>
                    <tr>
                        <th>Min</th>
                        <th>@lang("content.policy")</th>

                        <th>Min</th>
                        <th>@lang("content.policy")</th>
                    </tr>
                    <tr>
                        <td><?php echo $aircraft->name?></td>
                        <td><?php echo getAircraftType($aircraft->type) ?></td>
                        <td><?php echo ($aircraft->msn) ? $aircraft->msn : "&mdash;"?></td>
                        <td><?php echo ($aircraft->line_number) ? $aircraft->line_number : "&mdash;"?></td>
                        <td><?php echo ($aircraft->first_flight) ? $aircraft->first_flight : "&mdash;"?></td>
                        <td><?php echo (isset($diff)) ? $diff : "&mdash;"?></td>
                        <td><?php echo ($aircraft->airframe_status) ? "Active" : "Inactive"?></td>
                        <td><?php echo $aircraft->config_c . "C " . $aircraft->config_y . "Y"?></td>
                        <td><?php echo ($aircraft->type->min_fcm) ? $aircraft->type->min_fcm : "&mdash;"?></td>
                        <td><?php echo ($aircraft->type->policy_fcm) ? $aircraft->type->policy_fcm : "&mdash;"?></td>
                        <td><?php echo ($aircraft->type->min_ccm) ? $aircraft->type->min_ccm : "&mdash;"?></td>
                        <td><?php echo ($aircraft->type->policy_ccm) ? $aircraft->type->policy_ccm : "&mdash;"?></td>
                    </tr>
                </table>

                <!-- Aircraft parts -->
                @if (isset($aircraftParts) and count($aircraftParts))
                @foreach($aircraftParts as $groupName => $groupOfParts)
                <h4>{!! $groupName !!}</h4>
                @if (count($groupOfParts) == 1)
                @php $part = $groupOfParts[0]; @endphp
                <table class="table table-condensed">
                <tr>
                    @if ($part->part_number)
                    <th>Part Number</th>
                    @endif
                    @if ($part->serial_number)
                    <th>Serial Number</th>
                    @endif
                    @if ($part->type_model)
                    <th>@lang("content.type") Model</th>
                    @endif
                    @if ($part->position)
                    <th>@lang("content.position")</th>
                    @endif
                    @if ($part->tsn)
                    <th>TSN</th>
                    @endif
                    @if ($part->csn)
                    <th>CSN</th>
                    @endif
                    @if ($part->installation_date)
                    <th>Installation Date</th>
                    @endif
                    @if ($part->tslsv)
                    <th>TSLSV</th>
                    @endif
                    @if ($part->cslsv)
                    <th>CSLSV</th>
                    @endif
                    @if ($part->thrust_category)
                    <th>Thrust Category</th>
                    @endif
                    @if ($part->first_llp_remaining_fc)
                    <th>First LLP remaining FC</th>
                    @endif
                    @if ($part->last_overhaul_date)
                    <th>Last Overhaul Date</th>
                    @endif
                    @if ($part->next_overhaul_date)
                    <th>Next Overhaul Date</th>
                    @endif
                </tr>
                <tr>
                    @if ($part->part_number)
                    <td>{!! $part->part_number !!}</td>
                    @endif
                    @if ($part->serial_number)
                    <td>{!! $part->serial_number !!}</td>
                    @endif
                    @if ($part->type_model)
                    <td>{!! $part->type_model !!}</td>
                    @endif
                    @if ($part->position)
                    <td>{!! $part->position !!}</td>
                    @endif
                    @if ($part->tsn)
                    <td>{!! $part->tsn !!}</td>
                    @endif
                    @if ($part->csn)
                    <td>{!! $part->csn !!}</td>
                    @endif
                    @if ($part->installation_date)
                    <td>{!! $part->installation_date !!}</td>
                    @endif
                    @if ($part->tslsv)
                    <td>{!! $part->tslsv !!}</td>
                    @endif
                    @if ($part->cslsv)
                    <td>{!! $part->cslsv !!}</td>
                    @endif
                    @if ($part->thrust_category)
                    <td>{!! $part->thrust_category !!}</td>
                    @endif
                    @if ($part->first_llp_remaining_fc)
                    <td>{!! $part->first_llp_remaining_fc !!}</td>
                    @endif
                    @if ($part->last_overhaul_date)
                    <td>{!! $part->last_overhaul_date !!}</td>
                    @endif
                    @if ($part->next_overhaul_date)
                    <td>{!! $part->next_overhaul_date !!}</td>
                    @endif
                </tr>
                </table>
                @else

                <table class="table table-condensed">
                    <tr>
                        <th>Part Number</th>
                        <th>Serial Number</th>
                        <th>@lang("content.type") Model</th>
                        <th>@lang("content.position")</th>
                        <th>TSN</th>
                        <th>CSN</th>
                        <th>Installation Date</th>
                        <th>TSLSV</th>
                        <th>CSLSV</th>
                        <th>Thrust Category</th>
                        <th>First LLP Remaining FC</th>
                        <th>Last Overhaul Date</th>
                        <th>Next Overhaul Date</th>
                    </tr>
                    @foreach($groupOfParts as $part)
                    <tr>
                        <td>{!! ($part->part_number) ? $part->part_number : "N/A" !!}</td>
                        <td>{!! ($part->serial_number) ? $part->serial_number : "N/A" !!}</td>
                        <td>{!! ($part->type_model) ? $part->type_model : "N/A" !!}</td>
                        <td>{!! ($part->position) ? $part->position : "N/A" !!}</td>
                        <td>{!! ($part->tsn) ? $part->tsn : "N/A" !!}</td>
                        <td>{!! ($part->csn) ? $part->csn : "N/A" !!}</td>
                        <td>{!! ($part->installation_date) ? $part->installation_date : "N/A" !!}</td>
                        <td>{!! ($part->tslsv) ? $part->tslsv : "N/A" !!}</td>
                        <td>{!! ($part->cslsv) ? $part->cslsv : "N/A" !!}</td>
                        <td>{!! ($part->thrust_category) ? $part->thrust_category : "N/A" !!}</td>
                        <td>{!! ($part->first_llp_remaining_fc) ? $part->first_llp_remaining_fc : "N/A" !!}</td>
                        <td>{!! ($part->last_overhaul_date) ? $part->last_overhaul_date : "N/A" !!}</td>
                        <td>{!! ($part->next_overhaul_date) ? $part->next_overhaul_date : "N/A" !!}</td>
                    </tr>
                    @endforeach
                </table>
                @endif
                @endforeach
                @endif
              </div>
            </div>

            <div class="row">
                <div class="col-sm-7">
                    <div class="panel panel-primary">
                      <div class="panel-heading">
                        <h3 class="panel-title">@lang("content.aircraft") Certificates</h3>
                      </div>
                      <div class="panel-body">
                        <div id="message-certificate"></div>
                        <table class="table table-condensed">
                            <tr>
                                <th>Certificate Name</th>
                                <th>@lang("content.from")</th>
                                <th>@lang("content.to")</th>
                                <th style="min-width: 180px">@lang("content.actions")</th>
                            </tr>
                            @foreach ($certificates as $certificate)
                                @if (isset($aircraftCurrentCertificates[$certificate->id]) && is_object($aircraftCurrentCertificates[$certificate->id]))
                                    @php $from = $aircraftCurrentCertificates[$certificate->id]->valid_from @endphp
                                    @php $to = $aircraftCurrentCertificates[$certificate->id]->valid_to @endphp
                                @else
                                    @php $from = "" @endphp
                                    @php $to = "" @endphp
                                @endif
                                <tr>
                                    <td><h5>{!! $certificate->certificate_name !!}</h5></td>
                                    <td class="from" style="padding-top: 5px">
                                        {!! ($from) ? $from : "&mdash;" !!}
                                    </td>
                                    <td class="to" style="padding-top: 5px">
                                        {!! ($to) ? $to : "&mdash;" !!}
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button data-from="{!! $from !!}" data-to="{!! $to !!}" data-certificate-id="{!! $certificate->id !!}" class="edit-certificate btn btn-primary btn-sm">@lang("content.edit")</button>
                                            <button style="display: none" data-from="{!! $from !!}" data-to="{!! $to !!}" data-certificate-id="{!! $certificate->id !!}" class="save-certificate btn btn-danger btn-sm">Save Changes</button>
                                            <button style="display: none" data-from="{!! $from !!}" data-to="{!! $to !!}" data-certificate-id="{!! $certificate->id !!}" class="cancel-certificate btn btn-info btn-sm">Cancel</button>
                                            {{--<button data-certificate-id="{!! $certificate->id !!}" class="show-certificate-image btn btn-info btn-sm">Certificate</button>--}}
                                            <a target="_blank" href="{!!route("homepage")."#". url('fleet-management/certificates')!!}?aircraft_id={!!$aircraft->id!!}&certificate_id={!!$certificate->id!!}" data-certificate-id="{!! $certificate->id !!}" class="show-certificate-image btn btn-info btn-sm">Certificate</a>
                                            <button data-certificate-id="{!! $certificate->id !!}" class="show-history-certificates btn btn-default btn-sm">Show History</button>
                                        </div>
                                    </td>
                                </tr>
                                <tr class="history" style="display: none">
                                    <td colspan="4"></td>
                                </tr>
                            @endforeach
                        </table>
                      </div>
                    </div>
                </div>
                <div class="col-sm-5">
                    <div class="panel panel-primary">
                      <div class="panel-heading">
                        <h3 class="panel-title">@lang("content.aircraft") Weights/Index</h3>
                      </div>
                      <div id="message-parameters"></div>
                      <div class="panel-body">
                          <table class="table table-bordered table-hover" data-aircraft_id="{{ $aircraft->id }}">
                              <thead>
                              <tr>
                                  <th>@lang("content.name")</th>
                                  <th>@lang("content.value")</th>
                                  <th>@lang("content.actions")</th>
                              </tr>
                              </thead>

                              <tbody>
                              @foreach ($aircraftParameters as $key => $parameter)
                                  @if ($parameter == "Max Take-Off")
                                      <tr>
                                          <td colspan="3" class="bg-color-gray"><strong>@lang("content.weights"), @lang("content.tons")</strong></td>
                                      </tr>
                                  @elseif($parameter == "Usable Fuel")
                                      <tr>
                                          <td colspan="3" class="bg-color-gray"><strong>@lang("content.fuel_capacity"), @lang("content.tons")</strong></td>
                                      </tr>
                                  @endif
                                  <tr>
                                      <td>{!! $parameter !!}</td>
                                      <td>
                                          @php $currentValue = (isset($aircraftCurrentParameters[$key]) && ($aircraftCurrentParameters[$key] || $aircraftCurrentParameters[$key] === "0")) ? $aircraftCurrentParameters[$key] : "" @endphp
                                          {!! ($currentValue || $currentValue === "0") ? $currentValue : "&mdash;" !!}
                                      </td>
                                      <td>
                                          <div class="btn-group">
                                              <button data-value="{!! $currentValue !!}" data-param="{!! $key !!}" class="edit-param btn btn-primary btn-sm">@lang("content.edit")</button>
                                              <button data-value="{!! $currentValue !!}" style="display: none" data-param="{!! $key !!}" class="save-param btn btn-danger btn-sm">@lang("content.save")</button>
                                              <button data-value="{!! $currentValue !!}" style="display: none" data-param="{!! $key !!}" class="cancel-param btn btn-info btn-sm">@lang("content.cancel")</button>
                                              <!--<button class="btn btn-info btn-sm">Certificate</button>-->
                                              {{--<button class="btn btn-default btn-sm">Show History</button>--}}
                                          </div>
                                      </td>
                                  </tr>
                              @endforeach

                              </tbody>

                          </table>
                      </div>
                    </div>
                </div>
                <input type="hidden" id="aircraft_id" value="{!! $aircraft->id !!}" name="aircraft_id">
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("{{ asset("/assets/js/views/fleetmanagement/details.js?6") }}", function(){
        loadScript("{{ asset("/assets/js/views/aircraft/edit.js?6") }}", pagefunction);
    });


</script>

