<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <div class="col-sm-12">


            <h2 style="margin-top: 0">{{ \App\Models\Aircraft::find(\request("aircraft_id"))->name}}</h2>
            <h4 style="margin-top: 0">{{ \App\Models\AircraftCertificate::find(\request("certificate_id"))->certificate_name}}</h4>
        <!-- Message -->
        @if ($errors->all())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        @if ( Session::has('message'))
            <div class="alert alert-success">
                {{ Session::get('message')}}
            </div>
        @endif

        <div class="btn-group" style="margin-bottom: 10px">
            <a target="_blank" {{$certificateExists ? '' : 'disabled' }} href="{{ url('fleet-management/certificates')}}?aircraft_id={{$aircraft->id}}&certificate_id={{$certificate->id }}&view=1" class="btn btn-warning">View</a>
            <a target="_blank" {{$certificateExists ? '' : 'disabled' }} href="{{ url('fleet-management/certificates')}}?aircraft_id={{$aircraft->id}}&certificate_id={{$certificate->id }}&download=1" class="btn btn-primary">Download</a>
            <a class="btn btn-danger edit">{{$certificateExists ? 'Edit' : 'Upload' }}</a>
        </div>

        @if ($certificateExists)
            {!! Form::open(['files'=>true, "id" => 'deleteForm', "class" => "form-group", 'method' => 'POST' ,'url' => URL::full()]) !!}
                {!! Form::hidden('certificateDelete', 1) !!}
                {!! Form::submit('Delete', ["class" => "btn btn-danger"]) !!}
            {!! Form::close() !!}
        @else
            <div class="alert alert-dismissable alert-warning"><button type="button" class="close" data-dismiss="alert">×</button>
                Sorry Certificate Not found. Please Check if It's Uploaded
            </div>
        @endif

        <div id="uploadCertificate" style="width: 30%; background-color: #f4fbf6; max-width: 300px; padding: 15px; display: none" >
            <div class="btn-group">
            </div>
            {!! Form::open(['files'=>true, "id" => 'uploadForm', "class" => "form-inline", 'method' => 'POST' ,'url' => URL::full()]) !!}
              {!! Form::file('certificateFile') !!}
              <br/>
              <!-- submit buttons -->
                {!! Form::hidden('certificateUpload', 1) !!}
              {!! Form::submit('Upload') !!}
            {!! Form::close() !!}
        </div>
        </div>

    </div>
</section>

{{--
<script src="{{ route("homepage")."#". url("/") }}/assets/js/vendor/pdfobject.js"></script>
<script type="text/javascript">
var myParams = {
  url: "{{$certificateUrl}}",
  pdfOpenParams: { view: "FitV" }
};

var myPDF = new PDFObject(myParams).embed("mydiv");
</script>
--}}
<script type="text/javascript">

    pageSetUp();

    $('a.edit').click(function () {
        $("#uploadCertificate").toggle(400, function () {
            var $this = $(this);
            $("#uploadCertificate").val(($this.is(":visible")) ? "1" : "0");
        });
    });

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();
    }

    pagefunction();

</script>

