@extends($ajaxCall)

@section("content")

@include('general.tab-header')

<div class="tabbable"> <!-- Only required for left/right tabs -->
  <ul class="nav nav-tabs">
    <li class="active"><a href="#tab1" data-toggle="tab">Analysis</a></li>
    <li><a href="#tab2" data-toggle="tab" id="graphs">Graphs</a></li>
  </ul>
  <div class="tab-content" style="background-color: white; display: inline-block">
    <div class="tab-pane active" id="tab1" style="padding-top: 10px;">
      <div class="col-lg-12" id="message_div"></div>

      {!! Form::open(["method" => "POST", "class" => "form-inline", ]) !!}
           <div class="col-lg-12">
               <div class="float">
                   <label><input type="radio" name="mode[]" checked value="standard" />Report</label>
                   <div class="form-group marginBottomRight">
                       {!! Form::select('report[]', $reports, null, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'report']) !!}
                        <button type="button" class="btn btn-primary multiselect_finance-toggle">Select All</button>
                   </div>

                   <div class="form-group marginBottomRight">
                       <label for="category" class="control-label">Category</label>
                       {!! Form::select('category[]', [], null, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'category']) !!}
                        <button type="button" class="btn btn-primary multiselect_finance-toggle">Select All</button>
                   </div>

                   <div class="form-group marginBottomRight">
                       <label for="variable" class="control-label">Variables</label>
                       {!! Form::select('variable[]', [], null, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'variable']) !!}
                        <button type="button" class="btn btn-primary multiselect_finance-toggle">Select All</button>
                   </div>

               <div class="form-group marginBottomRight">
                   <label for="month" class="control-label">@lang("content.month")</label>
                   {!! Form::select('month', $month_names, $month, ['multiple' => 'multiple', 'class'=>'multiselect_search', 'id'=>'month']) !!}
                   <button type="button" class="btn btn-primary multiselect-toggle">Select All</button>
               </div>

               <div class="form-group marginBottomRight">
                   <label for="year" class="control-label">@lang("content.year")</label>
                   {!! Form::select('year[]', $years, $year, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'year']) !!}
                    <button type="button" class="btn btn-primary multiselect-toggle">Select All</button>
               </div>

             <div class="form-group" style="margin-right: 20px">
                 <label class="control-label">@lang("content.period")</label>
                 {!! Form::select('period', $period_labels, \request("period"), ['class'=>'singleselect', 'id'=>'period']) !!}
             </div>


               <div class="form-group">
                   <button type="button" class="btn btn-primary" id="submit_form">@lang("content.submit")</button>
               </div>

                <span style="font-size: 11px; color: #5f5f5f; display: none" id="loading">
                    <img width="24" src="{{ url("/assets/img/2.GIF") }}" alt="Loading..."/> loading...
                </span>
                  {{-- <div class="form-group marginBottomRight">
                       <label class="control-label">Route</label>
                       <div class="btn-group">
                           {!! Form::select('route[]', $flight_types['All'], null, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'route']) !!}
                       <button class="btn btn-primary multiselect-toggle">Select All</button>
                       </div>
                   </div>--}}

               </div>
            </div>

            <div class="col-lg-12" style="margin-top: 10px">

           </div>
       {!! Form::close() !!}

      <div id="table_div" style="margin-bottom: 50px; overflow: auto; width: 1900px"></div>
    </div>

    <div class="tab-pane" id="tab2" style="padding-top: 10px;">
        <div class="col-md-12 table-bordered" id="chart" style="height: 450px; display: none"></div>
    </div>

  </div>
</div>
@stop


@section("js_scripts")
<script type="text/javascript" src="https://www.google.com/jsapi"></script>

<script type="text/javascript">
   google.load("visualization", "1", {packages:["corechart"]});
</script>

<script src="{{ url("/assets/js/vendor/jquery.number.min.js") }}"></script>
<script src="{{ url("/assets/js/views/finance/report.js") }}"></script>


@stop