@extends($ajaxCall)

@section("content")


@include('general.tab-header')


<div class="tabbable">
  <ul class="nav nav-tabs">
    @php $j = 1 @endphp
    @foreach($reports as $i => $item)
        <li @if ($i == 10) class="active" @endif><a href="#tab{{ $j++ }}" data-toggle="tab">{{ $item }}</a></li>
    @endforeach
  </ul>



  <div class="tab-content" style="background-color: white">
    @php $j = 1 @endphp
    @foreach($report_data as $i => $report)
        <div class="tab-pane {{ ($j == 1) ? "active" : "" }}" id="tab{{ $j++ }}" style="padding-top: 10px;">

            <div class="form-group">
                <label for="month" class="control-label">@lang("content.month")</label>
                {!! Form::select('month', $month_names, $month, ['class'=>'form-control singleselect']) !!}

                <label for="year" class="control-label">@lang("content.year")</label>
                {!! Form::select('year', $years, getSelectedYear(), ['class'=>'form-control singleselect']) !!}

                <button type="button" class="btn btn-primary select_date">Select Date</button>

                <button type="button" class="btn btn-primary save_all">Save All</button>

                <span style="font-size: 11px; color: #5f5f5f; display: none" id="loading">
                    <img width="24" src="{!!route("homepage")."#". url('/')!!}/assets/img/2.GIF" alt="Loading..."/> loading...
                </span>

            </div>


            @foreach($report->reportCategory as $category)
                <div class="panel panel-primary">
                    <div class="panel-heading"><span style="width: 250px">{!!$category->name!!}
                        @if (isset($category->multiply)) {!!"(x".$category->multiply.")"!!} @endif
                        @if (isset($category->measure)) {!!$category->measure!!} @endif
                        </span>

                    </div>
                    <div class="panel-body">
                        @php $category->reportVariable @endphp

                        <table class="table table-striped" @if (isset($sub_categories[$report->id])) data-columns = "{!!2*count($sub_categories[$report->id])!!} @endif">
                            @if ($report->sub_columns == '1')
                                <tr>
                                    <th><span class="hidden category_month_number"></span></th>
                                    @foreach($sub_categories[$report->id] as $sub_columns)
                                        <th colspan="2"><span class="hidden category_month_number"></span>{!!str_replace("_", " ", $sub_columns);!!}</th>
                                    @endforeach
                                    <th></th>
                                </tr>
                                <tr>
                                    <th style="width:250px"><span class="hidden category_month_number"></span>@lang("content.route")</th>
                                    @foreach($sub_categories[$report->id] as $sub_columns)
                                        <th><span class="category_month"></span>-<span class="category_year1"></span></th>
                                        <th><span class="category_month"></span>-<span class="category_year2"></span></th>
                                    @endforeach
                                    <th></th>
                                </tr>
                            @else
                                <tr>
                                    <th style="width: 250px"><span class="hidden category_month_number"></span>Specification</th>
                                    <th style="width: 200px"><span class="category_month"></span>-<span class="category_year1"></span></th>
                                    <th style="width: 200px"><span class="category_month"></span>-<span class="category_year2"></span></th>
                                    <th></th>
                                </tr>
                            @endif



                        @if ($report->by_type == 0)
                            @if(isset($category->reportVariable))
                                @forelse($category->reportVariable as $variable)
                                    <tr>
                                        <td>{!!Form::label($variable->name)!!}
                                        @if (isset($variable->multiply)) {!!"(x".$variable->multiply.")"!!} @endif
                                        @if (isset($variable->measure)) {!!$variable->measure!!} @endif
                                        </td>
                                        <td>{!!Form::input('text','default_value', null,['data-variable_id'=>$variable->id, 'data-report_id'=>$report->id, 'data-category_id'=>$category->id, 'data-category_multiply'=>$category->multiply, 'data-variable_multiply'=>$variable->multiply, 'class'=>'variable'])!!}</td>
                                        <td>{!!Form::input('text','default_value', null,['data-variable_id'=>$variable->id, 'data-report_id'=>$report->id, 'data-category_id'=>$category->id, 'data-category_multiply'=>$category->multiply, 'data-variable_multiply'=>$variable->multiply, 'class'=>'variable'])!!}</td>
                                        <td></td>
                                    </tr>
                                @empty
                                @endforelse
                                <tr>
                                    <td colspan="11"><button type="button" class="btn btn-primary save">Save</button></td>
                                </tr>
                            @endif

                        @elseif($report->by_type == '1')
                            @if (isset($flight_types[$category->name]))
                                @foreach($flight_types[$category->name] as $flt_no=>$route)
                                    <tr>
                                        <td>
                                        @if ($flt_no == '001') {!!$flt_no. "| Liter"!!}
                                        @else {!!$flt_no." | ".$route!!}
                                        @endif
                                        </td>
                                        @if ($report->sub_columns == '1')
                                            @foreach($sub_categories[$report->id] as $y => $sub_columns)
                                                <td>{!!Form::input('text',$sub_columns, null,['data-flight_number' => $flt_no, 'data-report_id'=>$report->id, 'data-category_id'=>$category->id, 'data-category_multiply'=> ($y % 2 == 0 ? $category->multiply : null), 'data-variable_multiply'=>$variable->multiply, 'class'=>'variable'])!!}</td>
                                                <td>{!!Form::input('text',$sub_columns, null,['data-flight_number' => $flt_no, 'data-report_id'=>$report->id, 'data-category_id'=>$category->id, 'data-category_multiply'=> ($y % 2 == 0 ? $category->multiply : null), 'data-variable_multiply'=>$variable->multiply, 'class'=>'variable'])!!}</td>
                                            @endforeach
                                        @endif
                                    </tr>
                                @endforeach
                                <tr>
                                    <td colspan="11"><button type="button" class="btn btn-primary save">Save</button></td>
                                </tr>
                            @endif

                        @elseif($report->by_type == '2')
                            @if ($report->sub_columns == '1')
                                <tr class="route_template hidden">
                                    <td class="route_label">Select Route</td>
                                    @foreach($sub_categories[$report->id] as $sub_columns)
                                        <td>{!!Form::input('text',$sub_columns, null,['data-flight_number' => $flt_no, 'data-report_id'=>$report->id, 'data-category_id'=>$category->id, 'data-category_multiply'=>$category->multiply, 'data-variable_multiply'=>$variable->multiply, 'class'=>'variable'])!!}</td>
                                        <td>{!!Form::input('text',$sub_columns, null,['data-flight_number' => $flt_no, 'data-report_id'=>$report->id, 'data-category_id'=>$category->id, 'data-category_multiply'=>$category->multiply, 'data-variable_multiply'=>$variable->multiply, 'class'=>'variable'])!!}</td>
                                    @endforeach

                                </tr>
                            @endif
                            <tr>
                                <td colspan="10">
                                    <label for="route" class="control-label">Add Route </label>
                                    {!! Form::select('route[]', $flight_types['All'],null, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'sector']) !!}
                                    <button type="button" class="btn btn-primary add_route">@lang("content.add")</button>
                                    <button type="button" class="btn btn-primary save">Save</button>
                                </td>
                            </tr>
                        @endif


                        </table>
                    </div>
                </div>
            @endforeach
        </div>
    @endforeach
  </div>


</div>


@stop


@section("js_scripts")

<script src="{{ url("/assets/js/views/finance/index.js") }}"></script>

@stop