@extends($ajaxCall)

@section('content')

    @include('general.tab-header', ['departmentName' => 'Error Handling', 'moduleName' => "Reports List"])

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12" style="margin-bottom: 15px">
                <table class="table table-bordered table-striped table-hover">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>@lang("content.type")</th>
                            <th>Summary</th>
                            <th>Notes</th>
                            <th>Screenshot</th>
                            <th>Resolved</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($data as $i => $each)
                            <tr>
                                <td>{{ $i + 1 }}</td>
                                <td>{{ $each->type }}</td>
                                <td>{{ $each->summary }}</td>
                                <td>{{ $each->notes }}</td>
                                @if ($each->is_video)
                                @else
                                    <td><a href="{{ url("error/get-image/{$each->id}") }}" target="_blank">
                                             <img height="50px" src="{{ url("error/get-image/{$each->id}") }}" />
                                        </a>
                                    </td>
                                @endif
                                <td><i class="fa-check"></i></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

{{-- JS scripts section --}}
@section("js_scripts")

@stop
