@extends($ajaxCall)

@section('content')

    @include('general.tab-header', ['departmentName' => 'Error Handling', 'moduleName' => "Report an Error"])

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12" style="margin-bottom: 15px">

                {!! Form::open(['method' => 'POST', 'files'=>true, 'url' => url('error/user-report'), 'class' => 'form-horizontal']) !!}
                    <div class="col-lg-12">
                        <div class="col-md-12">
                            <h5 class="col-md-1">Error Type</h5>
                            <div class="col-md-11">
                                {!! Form::select('type', $types, \request("type"), ['class'=>'multiselect_search', 'id'=>'type']) !!}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <h5 class="col-md-1">Summary</h5>
                            <div class="col-md-11">
                                {!! Form::text('summary', \request("summary"), ['class'=>'form-control', 'rows' => 10, 'id' => 'summary']) !!}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <h5 class="col-md-1">Notes</h5>
                            <div class="col-md-11">
                                {!! Form::textarea('notes', \request("notes"), ['class'=>'form-control', 'rows' => 10, 'id' => 'notes']) !!}
                            </div>
                        </div>

                        <div class="col-md-12" style="margin: 10px 0 0 0">
                            <h5 class="col-md-1">Screenshot</h5>
                            <div class="col-md-11">
                                {!! Form::file("file", ['name' => "file"]) !!}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="col-md-11 col-md-offset-1">
                                {!! Form::submit("Submit", ['name' => "submit", 'class' => "btn btn-primary"]) !!}
                            </div>
                        </div>

                    </div>
                {!! Form::close() !!}

            </div>
        </div>
    </div>
@endsection

{{-- JS scripts section --}}
@section("js_scripts")

@stop
