<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
?>
<h2 style="margin-bottom: 5px;">Staff License Expiry Notification ({{ $reminderTitle }})</h2>

<p style="text-align: left;">
@if (isset($user) && $user)
    This email is to remind that staff: <strong>{{ getUserName($user) }}</strong> licenses has expired/due to expire as per below details:
@else
    The following staff License/Approval has expired/due to expire as per below details:
@endif
</p>

<table class="bordered" style="width: 100%;">
    <thead>
        <tr>
            <th>No</th>
            @if (isset($director) && $director)
                <th>First Name</th>
                <th>Last Name</th>
                <th>Station</th>
            @endif
            <th>License</th>
            <th>Expiry Date</th>
        </tr>
    </thead>
    <tbody>
        @php $j = 0 @endphp
        @foreach($staffLicenses as $i => $item)
            @if (!$item || !$item->user || !$item->license)
                @continue
            @endif

            @php $user = $item->user @endphp
            @php $license = $item->license @endphp
            @php $expired = strtotime($item->expiry_date) < strtotime($today) @endphp

            <tr>
                <td>{{ ++$j }}</td>
                @if (isset($director) && $director)
                    <td>{{ $user->first_name }}</td>
                    <td>{{ $user->last_name }}</td>
                    <td>{{ getUserLocation($user) }}</td>
                @endif
                <td>{{ $license->name }} ({{ $license->abbr }})</td>
                <td class="{{ $expired ? "expired" : "" }}" style="text-align: center;">{{ $item->expiry_date }}</td>
            </tr>
        @endforeach

    </tbody>
</table>


<p style="text-align: left">
    @if (isset($user) && $user)
        ﻿Please take appropriate action/s to renew the same.
    @else
        ﻿Please take appropriate action/s to renew the same and update the records.
    @endif
    <br/><br/>

    Please do not reply to this auto-generated email.<br/><br/>
    Thank You.<br/><br/>
    Admin.
</p>
