<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
?>

@if (isset($startDate) && isset($endDate))
    From: {{ $startDate }} To: {{ $endDate  }}
@endif
<table class="bordered" cellpadding="0" cellspacing="0">
    <thead>
    <tr>
        <th>@lang("content.date")</th>
        <th>@lang("content.flight_no")</th>
        <th>@lang("content.sector")</th>
        <th>@lang("content.report_datetime")</th>
        <th>@lang("content.departure")</th>
        <th>@lang("content.arrival")</th>
        <th>@lang("content.position")</th>
        <th>@lang("content.sector_time")</th>
    </tr>
    </thead>
    <tbody>
    @foreach ($crewAndFlights as $each)
        @php $flight = $each['flight'] @endphp
        @php $crew = $each['crew'] @endphp

        @if ($flight->etd)
            @php $departure = $flight->etd @endphp
        @elseif($flight->ptd)
            @php $departure = $flight->ptd @endphp
        @else
            @php $departure = $flight->std @endphp
        @endif

        @if ($flight->eta)
            @php $arrival = $flight->eta @endphp
        @elseif($flight->pta)
            @php $arrival = $flight->pta @endphp
        @else
            @php $arrival = $flight->sta @endphp
        @endif

        <tr>
            <td>{{ date("D, d M Y", strtotime($departure)) }}</td>
            <td>{{ getFlightNumber($flight) }}</td>
            <td>{{ getSector($flight->flightNumber) }}</td>
            <td>{{ date("d M, H:i", strtotime("-75 minutes", strtotime($departure))) }}</td>
            <td>{{ date("d M, H:i", strtotime($departure)) }}</td>
            <td>{{ date("d M, H:i", strtotime($arrival)) }}</td>
            <td>{{ getCrewPosition($crew)}}</td>
            <td>{{ getFlightTime($flight) }}</td>
        </tr>
        @if (isset($flight->child) && !$crew->is_standby && !$crew->is_dhc)
            @php $childFlight = $flight->child @endphp

            @if ($childFlight->etd)
                @php $childDeparture = $childFlight->etd @endphp
            @elseif($childFlight->ptd)
                @php $childDeparture = $childFlight->ptd @endphp
            @else
                @php $childDeparture = $childFlight->std @endphp
            @endif

            @if ($childFlight->eta)
                @php $childArrival = $childFlight->eta @endphp
            @elseif($childFlight->pta)
                @php $childArrival = $childFlight->pta @endphp
            @else
                @php $childArrival = $childFlight->sta @endphp
            @endif

            <tr>
                <td>{{ date("D, d M, Y", strtotime($childDeparture)) }}</td>
                <td>{{ getFlightNumber($childFlight) }}</td>
                <td>{{ getSector($childFlight->flightNumber) }}</td>
                <td></td>
                <td>{{ date("d M, H:i", strtotime($childDeparture)) }}</td>
                <td>{{ date("d M, H:i", strtotime($childArrival)) }}</td>
                <td>{{ getCrewPosition($crew)}}</td>
                <td>{{ getFlightTime($childFlight) }}</td>
            </tr>
        @endif
    @endforeach
    </tbody>
</table>

<p style="margin-top: 30px">
@if (in_array($crew->position_id, [USER_CAPTAIN_POSITION_ID, USER_CHIEF_PILOT_POSITION_ID, USER_PILOT_INSTRUCTOR_POSITION_ID, USER_FIRST_OFFICER_POSITION_ID, USER_COPILOT_JUNIOR_POSITION_ID,]))
    For any further information please contact:<br/>
    Admin 1: (+992) 77-777-7777<br/>
    Admin 2: (+992) 77-777-7777<br/>
@else
    In-Flight Services Department: (+992) 77-777-7777<br/>
@endif
    For Emergencies please call operations control: (+992) 77-777-7777, (+992) 77-777-7777
</p>

