<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @if (in_array(\Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]))
                <div class="col-md-12 no-padding margin-bottom-10">
                    <a class="btn btn-primary" href="{{ route("homepage")."#department/add" }}">@lang("content.add_new_department")</a>
                    <a class="btn btn-success" href="{{ route("homepage")."#department/organization" }}" target="_blank">@lang("content.organisation")</a>
                </div>
            @endif

            <div class="clearfix"></div>

            <div>
                @if (count($departments))
                    <div class="jarviswidget jarviswidget-color-blueDark margin-bottom-10" id="wid-id-online"
                         data-widget-editbutton="false" data-widget-colorbutton="false"
                         data-widget-deletebutton="false">

                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                            <h2>@lang("content.list")</h2>
                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->

                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body no-padding" style="min-height: 50px !important;">

                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped table-hover">
                                        <thead>
                                        <tr>
                                            <th>@lang("content.name")</th>
                                            <th>@lang("content.staff_no")</th>
                                            <th>@lang("content.subdepartment")</th>
                                            <th>@lang("content.library")</th>
                                            <th>@lang("content.last_update")</th>
                                            <th style="width: 340px">@lang("content.actions")</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($departments as $department)
                                            <tr>
                                                <td data-left>{{ $department->name }}</td>
                                                <td>{{ isset($staffByDepartment[$department->id]) ? $staffByDepartment[$department->id]["counter"] : "" }}</td>
                                                <td>{!! $department->has_subdepartment ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>" !!}</td>
                                                <td>{!! $department->has_library ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>" !!}</td>
                                                <td>{{ $department->updated_at }}</td>
                                                <td>
                                                    <div class="btn-group">
                                                        <a class="btn btn-sm btn-primary" target="_blank"
                                                           href="{{ route("homepage")."#department/organization/{$department->id}" }}">@lang("content.organisation")</a>
                                                        <a target="_blank" class="btn btn-sm btn-warning"
                                                           href="{{ route("homepage")."#department/edit?s=".rand(100, 999)."&id={$department->id}" }}">@lang("content.edit")</a>
                                                        @if ($department->has_subdepartment)
                                                            <a class="btn btn-sm btn-info"
                                                               href="{{ route("homepage")."#subdepartment/index?department_id={$department->id}" }}">@lang("content.subdepartments")</a>
                                                        @endif
                                                        <a class="btn btn-sm btn-success"
                                                               href="{{ route("homepage")."#position/index?department_id={$department->id}" }}">@lang("content.positions")</a>

                                                        <a class="btn btn-sm btn-danger confirm"
                                                           data-confirm-text="Are you sure you want to remove this department?"
                                                           href="{{ route("homepage")."#department/delete?id={$department->id}" }}">@lang("content.delete")</a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="alert alert-warning margin-top-10">No departments listed.</div>
                @endif

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyDateFormats();

        ApplyTableFilter(".table");

    };

    pagefunction();

</script>

