<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
    <!-- widget options:
    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    data-widget-colorbutton="false"
    data-widget-editbutton="false"
    data-widget-togglebutton="false"
    data-widget-deletebutton="false"
    data-widget-fullscreenbutton="false"
    data-widget-custombutton="false"
    data-widget-collapsed="true"
    data-widget-sortable="false"

    -->
    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>

    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding">

            <table id="datatable_fixed_column" class="table table-striped table-bordered table-hover" width="100%">

                <thead>
                <tr>
                    <th class="hasinput" style="width:4%"></th>
                    <th class="hasinput" style="width:6%"></th>

                    <th class="hasinput" style="width:10%">
                        <input type="text" class="form-control" placeholder="Filter Last Name" />
                    </th>
                    <th class="hasinput" style="width:10%">
                        <input type="text" class="form-control" placeholder="Filter First Name" />
                    </th>
                    <th class="hasinput" style="width:20%">
                        <input type="text" class="form-control" placeholder="Filter Position" />
                    </th>
                    <th class="hasinput" style="width:15%">
                        <input type="text" class="form-control" placeholder="Filter Location" />
                    </th>
                    <th class="hasinput" style="width:7%">
                        <input type="text" class="form-control" placeholder="Filter Phone" />
                    </th>
                    <th class="hasinput" style="width:14%"></th>
                    <th class="hasinput" style="width:14%"></th>
                </tr>
                <tr>
                    <th>No</th>
                    <th>@lang("content.picture")</th>
                    <th>@lang("content.first_name")</th>
                    <th data-class="expand">@lang("content.last_name")</th>
                    <th>@lang("content.position")</th>
                    <th>@lang("content.location")</th>
                    <th>@lang("content.phone")</th>
                    <th>Reports To</th>
                    @if (in_array(\Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]))
                        <th>Privilege</th>
                    @endif
                </tr>
                </thead>

                <tbody>
                @foreach($employees as $j => $user)
                    @php $no = $j + 1 @endphp
                    @php $picture = !is_null($user->thumb) ? '/storage/users/'.$user->thumb : '/assets/img/default-user-picture.png'; @endphp
                    @php $phone = unserialize($user->phone) @endphp
                    <tr>
                        <td>{{ $no }}</td>
                        @if (in_array(\Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]))
                            <td><a href="{{ url("user/{$user->id}") }}" target="_blank"><img src="{{ $picture }}" class="img-thumbnail thumb_report_prev"  /></a></td>
                            <td data-left><a href="{{ url("user/{$user->id}/edit") }}" target="_blank">{{ $user->first_name }}</a></td>
                            <td data-left><a href="{{ url("user/{$user->id}/edit") }}" target="_blank">{{ $user->last_name }}</a></td>
                            <td data-left><a href="{{ url("position/edit?s=".rand(100, 999)."&id={$user->position_id}") }}" target="_blank">{{ $user->position_title }}</a></td>
                            <td>{{ $user->location ? $user->location->airport->name : "" }}</td>
                            <td>{{ isset($phone['office']) ? $phone['office'] : "-" }}</td>
                            <td>
                                {!! Form::open(['method' => 'GET', 'class' => 'form-inline formUsers', 'id' => 'formReportsTo']) !!}
                                    {!! Form::hidden('departmentId', \request("departmentId")) !!}
                                    {!! Form::hidden("user_id", $user->id) !!}
                                    {!! Form::select("reports_to_user_id", $usersList, $user->reports_to_user_id, ["class" => "form-control input-sm floatOnly", "style" => "width: 130px; margin-right: 5px;" ]) !!}
                                    {!! Form::submit("Save", ["name" => "ReportsTo", "class" => "btn btn-success btn-sm floatOnly" ]) !!}
                                {!! Form::close() !!}
                            </td>
                            <td>
                                {!! Form::open(['method' => 'GET', 'class' => 'form-inline formUsers', 'id' => 'formUserRole']) !!}
                                    {!! Form::hidden('departmentId', \request("departmentId")) !!}
                                    {!! Form::hidden("user_id", $user->id) !!}
                                    {!! Form::select("role_id", $roles, $user->user_role_id, ["class" => "form-control input-sm floatOnly", "style" => "width: 130px; margin-right: 5px;" ]) !!}
                                    {!! Form::submit("Save",["name" => "Role", "class" => "btn btn-primary btn-sm floatOnly" ]) !!}
                                {!! Form::close() !!}
                            </td>
                        @else
                            <td><img src="{{ url("/assets/img/{$picture}") }}" class="img-thumbnail thumb_report_prev"  /></td>
                            <td data-left>{{ $user->last_name }}</td>
                            <td data-left>{{ $user->first_name }}</td>
                            <td data-left>{{ $user->position_title }}</td>
                            <td>{{ $user->location ? $user->location->airport->name : "" }}</td>
                            <td>{{ isset($phone['office']) ? $phone['office'] : "-" }}</td>
                            <td data-left>{{ $user->reportsTo ? $user->reportsTo->userFullName : "" }}</td>
                        @endif

                    </tr>
                @endforeach
                </tbody>
            </table>

        </div>
        <!-- end widget content -->

    </div>
    <!-- end widget div -->

</div>
<!-- end widget -->
