<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 12.08.14

 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => trans("content.admin"), 'moduleName' => trans("content.edit_department")])

            <div class="row">
                <div class="col-sm-9">
                {!! Form::open(['method' => 'POST', "url" => url("department/edit?id={$department->id}"), "autocomplete"=>"off", "class" => "form-horizontal", "role" => "form"]) !!}
                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.name")</label>
                        <div class="col-sm-6">
                            {!! Form::text("name", $department->name, ["placeholder" => trans("content.name"), "class" => "form-control"]) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.subdepartments")</label>
                        <div class="col-sm-6 checkbox">
                            <label>{!! Form::checkbox('has_subdepartment', 'on', $department->has_subdepartment) !!}</label>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.library")</label>
                        <div class="col-sm-6 checkbox">
                            <label>{!! Form::checkbox('has_library', 'on', $department->has_library) !!}</label>
                        </div>
                    </div>
                    <!--
                @include("user/assign")
                {{--@include("resource/assign")--}}
                -->
                <hr/>
                <div class="btn-group">
                    {!! Form::submit(trans("content.save_changes"), array('class'=>'btn btn-large btn-primary', "style" => "margin-top:0")) !!}
                    <a href="{{ route("homepage")."#". url('department') }}" class="btn btn-default">@lang("content.back")</a>
                </div>
                {!! Form::close() !!}
                </div>
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

    };

    pagefunction();

</script>


