@php $currentAirlineId = isset($currentAirlineId) ? $currentAirlineId : '' @endphp
@php $emailGroups = getEmailNotificationGroup() @endphp

<div class="col-md-12 no-padding margin-bottom-10">
    <a target="_blank" href="{{ route("homepage")."#". url("delay-code/create?s=".rand(100, 999)."&current_airline_id={$currentAirlineId}") }}" class="btn btn-primary">@lang("content.add_new_delay")</a>
</div>

<div class="col-md-12 form-inline" style="margin: 10px 0 20px 0">
    <label class="control-label" style="margin-right: 20px">
        {!! Form::checkbox("select_all", "1", false, ['class' => 'form-control select-all']) !!}
        @lang("content.select_all")
    </label>

    <p class="inline">@lang("content.notification_group")</p>
    <label class="select">
        {!! Form::select('email_notification', $emailGroups, null, ['class' => 'input-sm', "id" => "email_group_id"]) !!}
        <i></i>
    </label>

    <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="delete-selected"
            data-url="{{ url("delay-code/apply-changes") }}"
            data-toggle="modal" data-target="#confirmation-modal">@lang("content.apply")</button>
</div>


<div class="clearfix"></div>

@php $id = isset($id) ? $id : "delays" @endphp

@if (count($delays))
    <div class="jarviswidget jarviswidget-color-blueDark" id="{{ $id }}-container" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div class="editable_div">

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover" id="{{ $id }}" style="min-width: 100% !important;">
                    <thead>
                    <tr>
                        <th rowspan="2">SEL</th>
                        <th rowspan="2">No</th>
                        <th rowspan="2">@lang("content.group")</th>
                        <th rowspan="2">@lang("content.group")(@lang("content.local"))</th>
                        <th rowspan="2">@lang("content.airline")</th>
                        <th colspan="2" style="min-width: 180px;">@lang("content.code")</th>
                        <th rowspan="2">@lang("content.email")<br/>@lang("content.notification_group")</th>
                        <th rowspan="2">@lang("content.description")</th>
                        <th rowspan="2">@lang("content.description")(@lang("content.local"))</th>
                        <th rowspan="2">@lang("content.explanation")</th>
                        <th rowspan="2">@lang("content.explanation")(@lang("content.local"))</th>
                        <th rowspan="2" style="min-width: 140px;">@lang("content.actions")</th>
                    </tr>
                    <tr>
                        <th>@lang("content.numeric_alpha")</th>
                        <th>@lang("content.alpha")</th>
                    </tr>

                    </thead>
                    <tbody>

                    @foreach($delays as $i => $each)
                        @if ($each->deleted_at)
                            @continue
                        @endif
                        <tr>
                            <td>
                                {!! Form::checkbox("selected", "1", false, ['class' => 'form-control flight', "data-id" => $each->id ]) !!}
                            </td>
                            <td data-center>{{ $i + 1 }}</td>
                            <td>{{ $each->group ? $each->group->name : "-" }}</td>
                            <td>{{ $each->group ? $each->group->name_ln : "-" }}</td>
                            <td>{{ $each->airline ? $each->airline->iata : "-" }}</td>
                            <td class="text-center"><strong>{{ $each->code }}</strong></td>
                            <td class="text-center"><strong>{{ $each->alpha_code }}</strong></td>
                            <td>
                                <a href="#" data-field='email_notification_id' data-model="Delay" data-type="select" data-id='{{ $each->id }}'
                                   data-placeholder="Required" data-value='{{ $each->email_notification_id }}' class="editable {{  $each->email_notification_id ? 'editable-click' : 'editable-empty'  }}">
                                    {{  $each->emailNotification ? $each->emailNotification->name : 'Empty' }}</a>
                            </td>
                            <td>
                                <a href="#" data-field='description' data-model="Delay" data-type="textarea" data-id='{{ $each->id }}'
                                   data-placeholder="Required"
                                   class="editable {{  $each->description ? 'editable-click' : 'editable-empty'  }}">{{ $each->description ? $each->description : 'Empty' }}</a>
                            </td>
                            <td>
                                <a href="#" data-field='description_ln' data-model="Delay" data-type="textarea" data-id='{{ $each->id }}'
                                   data-placeholder="Required"
                                   class="editable {{  $each->description_ln ? 'editable-click' : 'editable-empty'  }}">{{ $each->description_ln ? $each->description_ln : 'Empty' }}</a>
                            </td>
                            <td>
                                <a href="#" data-field='explanation' data-model="Delay" data-type="textarea" data-id='{{ $each->id }}'
                                   data-placeholder="Required"
                                   class="editable {{  $each->explanation ? 'editable-click' : 'editable-empty'  }}">{{ $each->explanation ? $each->explanation : 'Empty' }}</a>
                            </td>
                            <td>
                                <a href="#" data-field='explanation_ln' data-model="Delay" data-type="textarea" data-id='{{ $each->id }}'
                                   data-placeholder="Required"
                                   class="editable {{  $each->explanation_ln ? 'editable-click' : 'editable-empty'  }}">{{ $each->explanation_ln ? $each->explanation_ln : 'Empty' }}</a>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a target="_blank" href="{{ route("homepage")."#". url("delay-code/{$each->id}/edit?current_airline_id={$currentAirlineId}") }}" class="btn btn-warning">@lang("content.edit")</a>
                                    <a href="{{ route("homepage")."#". url("delay-code/{$each->id}/delete?current_airline_id={$currentAirlineId}") }}" class="btn btn-danger">@lang("content.delete")</a>
                                </div>
                            </td>
                        </tr>
                    @endforeach

                    </tbody>

                </table>

            </div>

        </div>

    </div>

    </div>

    <div class="clearfix"></div>

    @include("delay-code.layouts.confirmation")

@endif

<script type="text/javascript">
    $(document).ready(function () {
       $("body").removeClass("modal-open")
                .attr("style", "margin-bottom: 30px;");
    });

    var confirmation_modal = $(document).find("#confirmation-modal"),
        tabContent = $(document).find("#tabContent"),
        confirmation_text = confirmation_modal.find(".confirmation-text"),
        ids = confirmation_modal.find("#ids"),
        group_id = confirmation_modal.find("#group_id")
    ;

    $(document).on("click", ".select-all:checkbox", function () {

        var selectAll = $(this).is(":checked"),
            checkboxes = $(document).find(".flight:checkbox");

        $.each(checkboxes, function () {
            if (selectAll){
                $(this).prop("checked", true);
            }
            else {
                $(this).prop("checked", false);
            }
        });
    });

    $(document).on("click", ".confirmation-modal-action-btn", function () {
        var id = $(this).data('id'),
            url = $(this).data('url'),
            action = $(this).data('action'),
            selected_checkboxes = $(document).find(".flight:checkbox:checked"),
            email_group_id = $("#email_group_id"),
            items = "";

        console.log(email_group_id.val());
        group_id.val(email_group_id.val());

        $("#confirmation-form").attr("action", url);

        switch (action) {
            default:
            case "delete-selected":
                // confirmation_text.text("Are you sure you want to delete selected schedules?");
                $.each(selected_checkboxes, function () {
                    items += $(this).data("id").toString() + ","
                });
                ids.val(items);

                console.log(items)
                break;
        }
    });

    $('#modal-form').submit(function() {
        // Coding
        $('#custom-delete-modal').modal('toggle');
        return false;
    });
</script>