<div class="tab-pane" id="flightsTab" style="padding: 10px 0; height: 700px; overflow: auto">
    @if (count($groupedByFlights))
        <table class="table table-bordered table-striped table-hover">
            <thead>
            <tr>
                <th rowspan="2">No</th>
                <th rowspan="2">@lang("content.flight")</th>
                <th rowspan="2">@lang("content.sector")</th>
                <th rowspan="2">Departure Time</th>
                <th rowspan="2">Arrival Time</th>
                <th colspan="4">FCM Requirement</th>
                <th colspan="8">Crew Names</th>
            </tr>
            <tr>
                <th>Pol</th>
                <th>Min</th>
                {{--<th>Req</th>--}}
                <th>Act</th>
                @if ($crewType == FCM_CREW)
                    <th>CAPT #1</th>
                    <th>CAPT #2</th>
                    <th>F/O #1</th>
                    <th>F/O #2</th>
                @else
                    <th>PSR</th>
                    <th>CC #2</th>
                    <th>CC #3</th>
                    <th>CC #4</th>
                    <th>CC #5</th>
                    <th>CC #6</th>
                    <th>CC #7</th>
                    <th>CC #8</th>
                @endif
            </tr>
            </thead>
            <tbody>
                @foreach($groupedByFlights as $i => $each)
                    @php $flight = $each[FLT] @endphp
                    @if ($flight)
                        @if ($flight->ptd && $flight->pta)
                            @php $departure = $flight->ptd @endphp
                            @php $arrival = $flight->pta @endphp
                        @else
                            @php $departure = $flight->std @endphp
                            @php $arrival = $flight->sta @endphp
                        @endif
                    @endif
                    @php $aircraft = $flight && $flight->aircraft ? $flight->aircraft : null @endphp
                    @php $aircraftType = $aircraft && $aircraft->type ? $aircraft->type : null @endphp

                    @if ($crewType == FCM_CREW)
                        @php $policy = $aircraftType ? $aircraftType->policy_fcm : null @endphp
                        @php $min = $aircraftType ? $aircraftType->min_fcm : null @endphp
                    @else
                        @php $policy = $aircraftType ? $aircraftType->policy_ccm : null @endphp
                        @php $min = $aircraftType ? $aircraftType->min_ccm : null @endphp
                    @endif

                    @php $flightNumber = $flight ? $each[FLT]->flightNumber : null @endphp
                    @php $depAirport = $flightNumber ? $flightNumber->departureAirport : null @endphp
                    @php $arrAirport = $flightNumber ? $flightNumber->arrivalAirport : null @endphp
                    @php $sector = $depAirport && $arrAirport ? $depAirport->iata."-".$arrAirport->iata : "-" @endphp

                    <tr>
                        <td>{{ $i + 1 }}</td>
                        <td>{{ $flightNumber->flight_number }}</td>
                        <td>{{ $sector }}</td>
                        <td>{{ $departure ? baseDateFormat($departure, true) : "-" }}</td>
                        <td>{{ $arrival ? baseDateFormat($arrival, true) : "-" }}</td>
                        <td>{{ $policy ? $policy : "-" }}</td>
                        <td>{{ $min ? $min : "-" }}</td>
                        {{--<td></td>--}}
                        <td>{{ $each[TOTAL] }}</td>

                        @if ($crewType == FCM_CREW)
                            <?php ksort($each[CAPT]) ?>
                            @foreach($each[CAPT] as $crew)
                                @php $position = GetCrewPositionAbbr($crew->position_title) @endphp
                                @php $className = GetCrewPositionCssClass($crew->position_title) @endphp
                                <td class="{{ $className }}">{{ $crew->user_full_name }}<span class="crew_id_small">{{ $position }}</span></td>
                            @endforeach

                            @if (count($each[CAPT]) < 2)
                                @for ($j = count($each[CAPT]); $j < 2; $j++)
                                    <td></td>
                                @endfor
                            @endif

                            <?php ksort($each[FO]) ?>
                            @foreach($each[FO] as $crew)
                                @php $position = GetCrewPositionAbbr($crew->position_title) @endphp
                                @php $className = GetCrewPositionCssClass($crew->position_title) @endphp
                                <td class="{{ $className }}">{{ $crew->user_full_name }}<span class="crew_id_small">{{ $position }}</span></td>
                            @endforeach

                            @if (count($each[FO]) < 2)
                                @for ($j = count($each[FO]); $j < 2; $j++)
                                    <td></td>
                                @endfor
                            @endif

                        @else
                            <?php ksort($each[CC]) ?>
                            @php $n = 0 @endphp
                            @foreach($each[CC] as $crew)
                                @php $position = GetCrewPositionAbbr($crew->position_title) @endphp
                                @if ($n == 0 && !in_array($crew->position_title, [PURSER_POSITION, INSTRUCTOR_FLIGHT_ATTENDANT_POSITION, SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_POSITION]))
                                    <td></td>
                                @endif
                                @php $className = GetCrewPositionCssClass($crew->position_title) @endphp
                                <td class="{{ $className }}">{{ $crew->user_full_name }}<span class="crew_id_small">{{ "(". $position .")"}}</span></td>
                                @php $n++ @endphp
                            @endforeach

                            @if (count($each[CC]) < 8)
                                @for ($j = count($each[CC]); $j < 8; $j++)
                                    <td></td>
                                @endfor
                            @endif
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>