<div class="tab-pane active" id="crewTab" style="padding: 10px 0; overflow: auto">

@if ($crewRoster)

    {!! $crewRosterDetails['pagination']->appends(request()->all())->render() !!}

    <table class="table table-bordered table-striped table-hover">
        <thead>
        <tr>
            <th rowspan="2">Crew Type</th>
            <th rowspan="2">@lang("content.from")</th>
            <th rowspan="2">@lang("content.to")</th>
            <th rowspan="2">Total Crew</th>
            <th colspan="4">@lang("content.flight")</th>
            <th rowspan="2">@lang("content.date")</th>
            <th rowspan="2">User</th>
            <th rowspan="2">@lang("content.status")</th>
        </tr>
        <tr>
            <th>Scheduled</th>
            <th>With No Crew</th>
            <th>Min Req. Not Met</th>
            <th>Standby Shortage</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td>{{ strtoupper($crewRoster->type) }}</td>
            <td>{{ baseDateFormat($crewRoster->roster_from) }}</td>
            <td>{{ baseDateFormat($crewRoster->roster_to) }}</td>
            <td>{{ $crewRoster->total_crew }}</td>
            <td>{{ $crewRoster->total_flights }}</td>
            <td>{{ $crewRoster->flt_no_crew }}</td>
            <td>{{ $crewRoster->flt_no_min_req }}</td>
            <td>{{ $crewRoster->flt_no_standby }}</td>

            <td>{{ $crewRoster->published_data ? baseDateFormat($crewRoster->published_date, true, '-') : baseDateFormat($crewRoster->created_at, true, '-') }}</td>
            <td>{{ $crewRoster->user->first_name." ".$crewRoster->user->last_name }}</td>
            <td>{{ $crewRoster->status }}</td>
        </tr>
        </tbody>
    </table>

    @foreach($crewRosterDetails['pagination'] as $j => $each)
        @if ($j >= ($currentPage - 1) * $perPage && $j < ($currentPage - 1) * $perPage + $perPage)
            @php $user = $each->user @endphp
            @php $position = $each->position ? $each->position->name : "" @endphp
            @php $picture = $user && $user->picture ? 'users/'.$user->picture : 'default-user-picture.png'; @endphp
            @php $location =  "" //$user && $user->location ? $user->location->city->abbr : "" @endphp
            @php $flights = $each->flight @endphp
            @php $crewClass = $user && $user->is_contractor ? "contract" : "staff" @endphp
            <div class="col-lg-12" style="margin: 10px 0 0 0; padding: 0;">
                <div class="col-md-3" style="padding: 0; height: 250px;">
                    <div class="panel panel-primary">
                        <div class="panel-heading" style="position: relative;overflow:hidden; ">
                            <span style="float: left">
                            @if ($user)
                                <a class="{{ $crewClass }}" target="_blank" href="{{ route("homepage")."#".url("/crew/profile?id={$user->id}") }}">{{ $user->first_name." ".$user->last_name }}</a></span>
                            @else
                                <a class="{{ $crewClass }}">-</a></span>
                            @endif

                            <span style="float: right; font-weight: bold">{{$location}}</span>
                        </div>
                        <div class="panel-body">
                            <div style="padding-bottom: 10px;">
                                <div class="profile-image" style="width: 40%; float: left">
                                    <img src="{{ url('/assets/img/'.$picture) }}" alt="Profile Image" class="img-thumbnail" style="max-height: 180px;">
                                </div>
                                <div style="float: left; width: 60%">
                                    <table class="table table-bordered table-striped table-hover" style="width:100%; padding: 0; margin: 0">
                                        <tbody>
                                        <tr>
                                            <td class="td_header" style="width: 40%">ID</td>
                                            <td>{{ $user ? $user->id : "-" }}</td>
                                        </tr>
                                        <tr>
                                            <td class="td_header">@lang("content.position")</td>
                                            <td>{{ $position }}</td>
                                        </tr>
                                        <tr>
                                            <td class="td_header">Planned</td>
                                            <td>{{ hoursToTime($each->hours, true) }}</td>
                                        </tr>

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-md-9" style="padding: 0 0 0 10px; height: 250px; overflow-y: auto;  ">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                        <tr>
                            <th colspan="4">Flights Scheduled</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <th>Flight Num</th>
                            <th>@lang("content.sector")</th>
                            <th>STD</th>
                            <th>STA</th>
                        </tr>
                        @foreach($flights as $flight)
                            @php $flightNumber = $flight->flightNumber ? $flight->flightNumber : null @endphp
                            @php $sector = $flightNumber ? ($flightNumber->departureAirport ? $flightNumber->departureAirport->iata : "") : "" @endphp
                            @php $sector .= $flightNumber ? "-".($flightNumber->arrivalAirport ? $flightNumber->arrivalAirport->iata : "") : "" @endphp
                            <tr>
                                <td class="{{ $flight->class }}">{{ $flightNumber->flight_number }}</td>
                                <td class="{{ $flight->class }}">{{ $sector }}</td>
                                <td class="{{ $flight->class }}">{{ baseDateFormat($flight->std, true, '-') }}</td>
                                <td class="{{ $flight->class }}">{{ baseDateFormat($flight->sta, true, '-') }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endif
    @endforeach

    {!! $crewRosterDetails['pagination']->appends(request()->all())->render() !!}

@endif

</div>