<div class="col-lg-4">
@if (count($hubs))
    <div style="margin-bottom: 5px">
        <h4>Hubs <a href="{!! route("homepage")."#". url('admin/add-hub') !!}" class="btn btn-primary btn-sm">@lang("content.add")</a></h4>
    </div>
    <table class="table table-bordered table-striped table-hover">
        <thead>
        <tr>
            <th>No</th>
            <th>@lang("content.name")</th>
            <th>@lang("content.city")</th>
            <th>@lang("content.hub")</th>
            <th>Crew Base</th>
            <th>@lang("content.actions")</th>
        </tr>
        </thead>
        <tbody>
        @foreach ($hubs as $each_hub)
        <tr>
            <td>{!! $each_hub->id !!}</td>
            <td>{!! $each_hub->name !!}</td>
            <td>{!! $each_hub->city->abbr !!}</td>
            <td> {!! ($each_hub->is_hub == 1) ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>"  !!}</td>
            <td> {!! ($each_hub->is_crew_base == 1) ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>"  !!}</td>
            <td>
                <div class="btn-group">
                    <a target="_blank" href="{!! route("homepage")."#". url('admin/edit-hub') !!}?id={!! $each_hub->id !!}" class="btn btn-primary btn-sm">@lang("content.edit")</a>
                    <a href="{!! route("homepage")."#". url('admin/delete-hub') !!}?id={!! $each_hub->id !!}" data-confirm-text="Are you sure?" class="btn confirm btn-danger btn-sm">@lang("content.remove")</a>
                </div>
            </td>
        </tr>
        @endforeach
        </tbody>
    </table>
@else
    <p class="alert alert-info">Found 0 Types</p>
@endif
</div>