@php $jsHandlerFunction = isset($jsHandlerFunction) ? $jsHandlerFunction : "" @endphp
{!! Form::open(['method' => 'POST', 'class' => 'form-inline', 'data-jsHandlerFunction' => $jsHandlerFunction, 'url' =>  url('crewroster/ajax-generate-crew-roster')]) !!}
<div class="col-lg-12" style="padding: 0; margin: 0">
    <div class="form-group table-bordered marginBottomRight" style="padding: 5px">

        <div class="form-group margin_right">
            {!! Form::hidden('crewType', $crewType) !!}
            <label class="control-label">@lang("content.from")</label>
            {!! Form::input('text', 'from', null,['class'=>'form-control date inputDateSmall', 'id' => 'from_date']) !!}
        </div>

        <div class="form-group margin_right">
            <label class="control-label">@lang("content.to")</label>
            {!! Form::input('text', 'to', null,['class'=>'form-control date inputDateSmall', 'id'=>'to_date']) !!}
        </div>
    </div>

    <div class="form-group table-bordered marginBottomRight" style="padding: 5px">
        <label>
            {!! Form::radio('dyu_pseudo','pseudo',(\request("dyu_pseudo") ? (\request("dyu_pseudo") == 'pseudo' ? true : false) : false),['id'=>'dyu_pseudo_option']) !!}
            PSEUDO (LOCATION 1)</label>
        <div class="form-group margin_right" id="dyu_pseudo">
            @if ($crewType == FCM_CREW)
                <label class="control-label">CAPT</label>
            @else
                <label class="control-label">PSR</label>
            @endif
            {!! Form::input('text', 'pseudo_dyu_rank1', null,['class'=>'form-control crewroster_cc_input']) !!}
        </div>
        <div class="form-group margin_right">
            @if ($crewType == FCM_CREW)
                <label class="control-label">F/O</label>
            @else
                <label class="control-label">CC</label>
            @endif
            {!! Form::input('text', 'pseudo_dyu_rank2', null,['class'=>'form-control crewroster_cc_input']) !!}
        </div>

        <div class="form-group margin_right" id="dyu_none">
            <label>
                {!! Form::radio('dyu_pseudo','none',(\request("dyu_pseudo") ? (\request("dyu_pseudo") == 'none' ? true : false) : true),['id'=>'dyu_none_option']) !!}
                None</label>
        </div>
    </div>

    <div class="form-group table-bordered marginBottomRight" style="padding: 5px">
        <label class="control-label">
        {!! Form::radio('lbd_dhc_pseudo','dhc',(\request("lbd_dhc_pseudo") ? (\request("lbd_dhc_pseudo") == 'dhc' ? true : false) : false),['id'=>'lbd_dhc_option']) !!}
        DHC</label>
        <div class="form-group margin_right">
            {!! Form::text('lbd_min', null, ['class'=>'form-control crewroster_cc_input']) !!}
        </div>

        <label>
        {!! Form::radio('lbd_dhc_pseudo','pseudo',(\request("lbd_dhc_pseudo") ? (\request("lbd_dhc_pseudo") == 'pseudo' ? true : false) : false),['id'=>'lbd_pseudo_option']) !!}
        PSEUDO (LOCATION 2)</label>
        <div class="form-group margin_right">
            @if ($crewType == FCM_CREW)
                <label class="control-label">CAPT</label>
            @else
                <label class="control-label">PSR</label>
            @endif

            {!! Form::input('text', 'pseudo_lbd_rank1', null,['class'=>'form-control crewroster_cc_input']) !!}
        </div>
        <div class="form-group margin_right">
            @if ($crewType == FCM_CREW)
                <label class="control-label">F/O</label>
            @else
                <label class="control-label">CC</label>
            @endif
            {!! Form::input('text', 'pseudo_lbd_rank2', null,['class'=>'form-control crewroster_cc_input']) !!}
        </div>
        <div class="form-group margin_right" id="lbd_none">
             <label>
            {!!Form::radio('lbd_dhc_pseudo','none',(\request("lbd_dhc_pseudo") ? (\request("lbd_dhc_pseudo") == 'none' ? true : false) : true),['id'=>'lbd_none_option'])!!}
            None</label>
        </div>
    </div>

    <div class="form-group table-bordered marginBottomRight" style="padding: 5px">
        <div class="form-group margin_right">
            <label class="control-label">Records Per Page
                {!! Form::select('records_number', ['1' => '1', '5' => '5', '10' => '10', '20' => '20'], $records_number, ['class' => 'input-sm form-control', 'id' => 'records_number']) !!}
            </label>
        </div>
        <div class="btn-group">
            <button type="button" id="ajax_generate" class="btn btn-primary" data-parentElement="#load_content" data-operationType="insert">Generate</button>
            {{--<button type="button" id="publish_roster" class="btn btn-success">Publish</button>--}}
            <button type="button" id="save_roster" class="btn btn-success">Save</button>
            {{--<button type="button" id="cancel_roster" class="btn btn-danger">Cancel</button>--}}
        </div>
    </div>
    <div class="form-group marginBottomRight add_container">

        <div class="btn-group margin_right add_flight_btn">
            <a href="#" class="btn btn-sm btn-primary add_flight">+ Add Flight</a>
            <a href="#" class="btn btn-sm btn-danger remove_flight">- Remove Flight</a>
        </div>

        <div class="form-group table-bordered margin_right add_flight_div" style="padding: 5px; margin-bottom: 10px; display: none">

            <div class="form-group margin_right">
                <label class="control-label">@lang("content.flight_number")</label>
                {!! Form::select('add_flight_numbers[]', ['' => 'None'] + $flight_numbers, null, ['class'=>'form-control']) !!}
            </div>

            <div class="form-group margin_right">
                <label class="control-label">@lang("content.date")</label>
                {!! Form::input('text', 'add_date[]', null,['class' => 'date_format form-control inputDateSmall', 'id' => 'date_add1', 'data-number' => 1]) !!}
            </div>

            <div class="form-group margin_right add_flight_crew_container" style="padding: 5px">
                <div class="form-group margin_right add_flight_crew_div">
                    <label class="control-label">@lang("content.crew")</label>
                    {!! Form::select('crew1[]', $cabincrew_list, null, ['class' => 'form-control input_ccm', 'data-number' => 1]) !!}
                </div>
            </div>

            <div class="btn-group">
                <a href="#" class="btn btn-sm btn-primary add_flight_crew">+ Add Crew</a>
                <a href="#" class="btn btn-sm btn-danger remove_flight_crew">- Remove Crew</a>
            </div>
        </div>
    </div>
</div>
{!! Form::close() !!}
